/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.playerskin;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.maxbogomol.fluffy_fur.client.event.ClientTickHandler;
import mod.maxbogomol.fluffy_fur.client.model.playerskin.EarsModel;
import mod.maxbogomol.fluffy_fur.client.model.playerskin.FurryPlayerSkinData;
import mod.maxbogomol.fluffy_fur.client.model.playerskin.PlayerSkinData;
import mod.maxbogomol.fluffy_fur.client.model.playerskin.TailModel;
import mod.maxbogomol.fluffy_fur.client.playerskin.PlayerSkin;
import mod.maxbogomol.fluffy_fur.client.playerskin.PlayerSkinHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class FurryPlayerSkin
extends PlayerSkin {
    public ResourceLocation earsTexture;
    public ResourceLocation tailTexture;
    public int earsWiggleTime = 5;
    public int earsWiggleMinDelay = 60;
    public int earsWiggleMaxDelay = 120;

    public FurryPlayerSkin(String id) {
        super(id);
    }

    @Override
    public FurryPlayerSkin setSlim(boolean slim) {
        this.slim = slim;
        return this;
    }

    @Override
    public FurryPlayerSkin setSkinTexture(ResourceLocation skinTexture) {
        this.skinTexture = skinTexture;
        return this;
    }

    @Override
    public FurryPlayerSkin setSkinBlinkTexture(ResourceLocation skinBlinkTexture) {
        this.skinBlinkTexture = skinBlinkTexture;
        return this;
    }

    @Override
    public FurryPlayerSkin setBlinkTime(int blinkTime) {
        this.blinkTime = blinkTime;
        return this;
    }

    @Override
    public FurryPlayerSkin setBlinkDelay(int blinkMinDelay, int blinkMaxDelay) {
        this.blinkMinDelay = blinkMinDelay;
        this.blinkMaxDelay = blinkMaxDelay;
        return this;
    }

    public FurryPlayerSkin setEarsTexture(ResourceLocation earsTexture) {
        this.earsTexture = earsTexture;
        return this;
    }

    public FurryPlayerSkin setTailTexture(ResourceLocation tailTexture) {
        this.tailTexture = tailTexture;
        return this;
    }

    public FurryPlayerSkin setEarsWiggleTime(int earsWiggleTime) {
        this.earsWiggleTime = earsWiggleTime;
        return this;
    }

    public FurryPlayerSkin setEarsWiggleDelay(int earsWiggleMinDelay, int earsWiggleMaxDelay) {
        this.earsWiggleMinDelay = earsWiggleMinDelay;
        this.earsWiggleMaxDelay = earsWiggleMaxDelay;
        return this;
    }

    public EarsModel getEarsModel(Player player) {
        return null;
    }

    public TailModel getTailModel(Player player) {
        return null;
    }

    public ResourceLocation getEars(Player player) {
        return this.earsTexture;
    }

    public ResourceLocation getTail(Player player) {
        return this.tailTexture;
    }

    @Override
    public FurryPlayerSkinData getDefaultData() {
        return new FurryPlayerSkinData();
    }

    @Override
    public FurryPlayerSkinData getData(Player player) {
        PlayerSkinData data = PlayerSkinHandler.getSkinData(player);
        if (data instanceof FurryPlayerSkinData) {
            FurryPlayerSkinData furryData = (FurryPlayerSkinData)data;
            return furryData;
        }
        FurryPlayerSkinData furryData = this.getDefaultData();
        PlayerSkinHandler.setSkinData(player, furryData);
        return furryData;
    }

    @Override
    public void tick(Player player) {
        super.tick(player);
        FurryPlayerSkinData data = this.getData(player);
        int ticks = ClientTickHandler.ticksInGame;
        if (data.getEarsWiggleTick() + this.earsWiggleTime < ticks) {
            data.setEarsWiggleTick(ClientTickHandler.ticksInGame + random.nextInt(this.earsWiggleMinDelay, this.earsWiggleMaxDelay));
        }
    }

    @Override
    public void extraRender(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Player player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, HumanoidModel defaultModel) {
        EarsModel earsModel = this.getEarsModel(player);
        ResourceLocation earsTexture = this.getEars(player);
        if (earsModel != null && earsTexture != null) {
            earsModel.f_102610_ = player.m_6162_();
            earsModel.copyFromDefault(defaultModel);
            earsModel.m_6973_((LivingEntity)player, player.f_267362_.m_267590_(partialTick), player.f_267362_.m_267711_(partialTick), (float)player.f_19797_ + partialTick, netHeadYaw, headPitch);
            this.earsAnimation(earsModel, player, player.f_267362_.m_267590_(partialTick), player.f_267362_.m_267711_(partialTick), (float)player.f_19797_ + partialTick, netHeadYaw, headPitch);
            earsModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)earsTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        TailModel tailModel = this.getTailModel(player);
        ResourceLocation tailTexture = this.getTail(player);
        if (tailModel != null && tailTexture != null) {
            tailModel.f_102610_ = player.m_6162_();
            tailModel.copyFromDefault(defaultModel);
            tailModel.m_6973_((LivingEntity)player, player.f_267362_.m_267590_(partialTick), player.f_267362_.m_267711_(partialTick), (float)player.f_19797_ + partialTick, netHeadYaw, headPitch);
            this.tailAnimation(tailModel, player, player.f_267362_.m_267590_(partialTick), player.f_267362_.m_267711_(partialTick), (float)player.f_19797_ + partialTick, netHeadYaw, headPitch);
            tailModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)tailTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void earsAnimation(EarsModel model, Player player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = player.m_6047_() ? 1.0f : 0.0f;
        model.rightEar.f_104205_ = (float)Math.toRadians(-15.0f - 20.0f * f);
        model.leftEar.f_104205_ = (float)Math.toRadians(15.0f + 20.0f * f);
        model.rightEar.f_104203_ = (float)Math.toRadians(10.0f * f);
        model.leftEar.f_104203_ = (float)Math.toRadians(10.0f * f);
        model.rightEar.f_104204_ = (float)Math.toRadians(-10.0f * f);
        model.leftEar.f_104204_ = (float)Math.toRadians(10.0f * f);
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        int ticks = ClientTickHandler.ticksInGame;
        FurryPlayerSkinData data = this.getData(player);
        if (data.getEarsWiggleTick() < ticks) {
            float f1 = (float)Math.sin(Math.toRadians(360.0f * (((float)ticks + partialTicks - (float)data.getEarsWiggleTick()) / ((float)this.earsWiggleTime + 1.0f))));
            double f2 = Math.toRadians(f1 * 10.0f);
            model.rightEar.f_104205_ -= (float)f2;
            model.leftEar.f_104205_ += (float)f2;
            model.rightEar.f_104204_ += (float)f2;
            model.leftEar.f_104204_ -= (float)f2;
        }
    }

    public void tailAnimation(TailModel model, Player player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        model.tail.f_104203_ = (float)Math.toRadians(45.0);
        if (player.m_21255_()) {
            model.tail.f_104203_ += (float)Math.toRadians(-65.0);
        }
        boolean flag = player.m_21256_() > 4;
        float f = 1.0f;
        if (flag) {
            f = (float)player.m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        model.tail.f_104204_ = (float)Math.toRadians(Math.cos(limbSwing * 0.6662f) * 15.0 * (double)limbSwingAmount / (double)f);
        double d0 = Mth.m_14139_((double)partialTicks, (double)player.f_36102_, (double)player.f_36105_) - Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)player.f_36103_, (double)player.f_36106_) - Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)player.f_36104_, (double)player.f_36075_) - Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_());
        f = Mth.m_14189_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_);
        double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f4 = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
        f1 += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)player.f_19867_, (float)player.f_19787_) * 6.0f)) * 32.0f * f4;
        if (player.m_6047_()) {
            f1 += 25.0f;
        }
        model.tail.f_104203_ += (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
        model.tail.f_104204_ += (float)Math.toRadians(f3 / 2.0f);
        model.tail.f_104205_ = (float)Math.toRadians(f3 / 2.0f);
    }
}

