/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.screenshake;

import java.util.Random;
import mod.maxbogomol.fluffy_fur.common.easing.Easing;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ScreenshakeInstance {
    public int progress;
    public final int duration;
    public float intensity1;
    public float intensity2;
    public float intensity3;
    public Easing intensityCurveStartEasing = Easing.LINEAR;
    public Easing intensityCurveEndEasing = Easing.LINEAR;
    public boolean isNormalize = true;
    public boolean isRotation = true;
    public boolean isPosition = false;
    public boolean isVector = false;
    public boolean isFov = false;
    public boolean isFovNormalize = false;
    public Vec3 vector = Vec3.f_82478_;
    public static final Random random = new Random();

    public ScreenshakeInstance(int duration) {
        this.duration = duration;
    }

    public ScreenshakeInstance setIntensity(float intensity) {
        return this.setIntensity(intensity, intensity);
    }

    public ScreenshakeInstance setIntensity(float intensity1, float intensity2) {
        return this.setIntensity(intensity1, intensity2, intensity2);
    }

    public ScreenshakeInstance setIntensity(float intensity1, float intensity2, float intensity3) {
        this.intensity1 = intensity1;
        this.intensity2 = intensity2;
        this.intensity3 = intensity3;
        return this;
    }

    public ScreenshakeInstance setEasing(Easing easing) {
        return this.setEasing(easing, easing);
    }

    public ScreenshakeInstance setEasing(Easing intensityCurveStartEasing, Easing intensityCurveEndEasing) {
        this.intensityCurveStartEasing = intensityCurveStartEasing;
        this.intensityCurveEndEasing = intensityCurveEndEasing;
        return this;
    }

    public ScreenshakeInstance enableNormalize() {
        return this.setNormalize(true);
    }

    public ScreenshakeInstance disableNormalize() {
        return this.setNormalize(false);
    }

    public ScreenshakeInstance setNormalize(boolean normalize) {
        this.isNormalize = normalize;
        return this;
    }

    public ScreenshakeInstance enableRotation() {
        return this.setRotation(true);
    }

    public ScreenshakeInstance disableRotation() {
        return this.setRotation(false);
    }

    public ScreenshakeInstance setRotation(boolean rotation) {
        this.isRotation = rotation;
        return this;
    }

    public ScreenshakeInstance enablePosition() {
        return this.setPosition(true);
    }

    public ScreenshakeInstance disablePosition() {
        return this.setPosition(false);
    }

    public ScreenshakeInstance setPosition(boolean position) {
        this.isPosition = position;
        return this;
    }

    public ScreenshakeInstance enableVector() {
        return this.setVector(true);
    }

    public ScreenshakeInstance disableVector() {
        return this.setVector(false);
    }

    public ScreenshakeInstance setVector(boolean vector) {
        this.isVector = vector;
        return this;
    }

    public ScreenshakeInstance setVector(Vec3 vector) {
        this.vector = vector;
        return this;
    }

    public ScreenshakeInstance setRandomVector() {
        double angleA = random.nextDouble() * Math.PI * 2.0;
        double angleB = random.nextDouble() * Math.PI * 2.0;
        float x = (float)(Math.cos(angleA) * Math.cos(angleB));
        float y = (float)(Math.sin(angleA) * Math.cos(angleB));
        float z = (float)Math.sin(angleB);
        this.vector = new Vec3((double)x, (double)y, (double)z);
        return this;
    }

    public ScreenshakeInstance enableFov() {
        return this.setFov(true);
    }

    public ScreenshakeInstance disableFov() {
        return this.setFov(false);
    }

    public ScreenshakeInstance setFov(boolean fov) {
        this.isFov = fov;
        return this;
    }

    public ScreenshakeInstance enableFovNormalize() {
        return this.setFovNormalize(true);
    }

    public ScreenshakeInstance disableFovNormalize() {
        return this.setFovNormalize(false);
    }

    public ScreenshakeInstance setFovNormalize(boolean fovNormalize) {
        this.isFovNormalize = fovNormalize;
        return this;
    }

    public float updateIntensity(Camera camera) {
        ++this.progress;
        float percentage = (float)this.progress / (float)this.duration;
        if (this.intensity2 != this.intensity3) {
            if (percentage >= 0.5f) {
                return Mth.m_14179_((float)this.intensityCurveEndEasing.ease(percentage - 0.5f, 0.0f, 1.0f, 0.5f), (float)this.intensity2, (float)this.intensity1);
            }
            return Mth.m_14179_((float)this.intensityCurveStartEasing.ease(percentage, 0.0f, 1.0f, 0.5f), (float)this.intensity1, (float)this.intensity2);
        }
        return Mth.m_14179_((float)this.intensityCurveStartEasing.ease(percentage, 0.0f, 1.0f, 1.0f), (float)this.intensity1, (float)this.intensity2);
    }
}

