/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.shader.postprocess;

import java.util.function.BiConsumer;
import mod.maxbogomol.fluffy_fur.client.event.ClientTickHandler;
import mod.maxbogomol.fluffy_fur.client.shader.postprocess.PostProcessInstance;
import org.joml.Vector3f;

public class GlowPostProcessInstance
extends PostProcessInstance {
    public Vector3f center;
    public Vector3f color;
    public float radius = 10.0f;
    public float intensity = 1.0f;
    public float fade = 1.0f;
    public float startTick = 0.0f;
    public float tickTime = 0.0f;
    public float fadeTime = 20.0f;
    public boolean isFade = true;

    public GlowPostProcessInstance(Vector3f center, Vector3f color) {
        this.center = center;
        this.color = color;
        this.startTick = ClientTickHandler.getTotal();
    }

    public GlowPostProcessInstance setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public GlowPostProcessInstance setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }

    public GlowPostProcessInstance setFade(float fade) {
        this.fade = fade;
        return this;
    }

    public GlowPostProcessInstance setStartTime(float time) {
        this.startTick = time;
        return this;
    }

    public GlowPostProcessInstance setTime(float time) {
        this.tickTime = time;
        return this;
    }

    public GlowPostProcessInstance setFadeTime(float fade) {
        this.fadeTime = fade;
        return this;
    }

    public GlowPostProcessInstance setIsFade(boolean fade) {
        this.isFade = fade;
        return this;
    }

    public void fadeUpdate(double deltaTime) {
        if (this.isFade) {
            this.tickTime = ClientTickHandler.getTotal() - this.startTick;
            this.fade = 1.0f - this.tickTime / this.fadeTime;
            if (this.tickTime > this.fadeTime) {
                this.fade = 0.0f;
                this.remove();
            }
        }
    }

    @Override
    public void update(double deltaTime) {
        super.update(deltaTime);
        this.fadeUpdate(deltaTime);
    }

    @Override
    public void writeDataToBuffer(BiConsumer<Integer, Float> writer) {
        writer.accept(0, Float.valueOf(this.center.x()));
        writer.accept(1, Float.valueOf(this.center.y()));
        writer.accept(2, Float.valueOf(this.center.z()));
        writer.accept(3, Float.valueOf(this.color.x()));
        writer.accept(4, Float.valueOf(this.color.y()));
        writer.accept(5, Float.valueOf(this.color.z()));
        writer.accept(6, Float.valueOf(this.radius));
        writer.accept(7, Float.valueOf(this.intensity));
        writer.accept(8, Float.valueOf(this.fade));
        writer.accept(9, Float.valueOf(this.tickTime));
        writer.accept(10, Float.valueOf(this.fadeTime));
    }
}

