/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import mod.maxbogomol.fluffy_fur.common.command.ItemSkinArgumentType;
import mod.maxbogomol.fluffy_fur.common.itemskin.ItemSkin;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class FluffyFurCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fluffy_fur").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"skin").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"item").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"skin", (ArgumentType)ItemSkinArgumentType.skins()).executes(ctx -> FluffyFurCommand.setItemSkin((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"player"), ItemSkinArgumentType.getSkin(ctx, "skin"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> FluffyFurCommand.removeItemSkin((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"player"))))))));
    }

    private static int setItemSkin(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> targetPlayers, ItemSkin itemSkin) throws CommandSyntaxException {
        int players = 0;
        for (ServerPlayer player : targetPlayers) {
            ItemStack stack = player.m_21205_();
            if (stack.m_41619_() || !itemSkin.canApplyOnItem(stack)) continue;
            itemSkin.applyOnItem(stack);
            ++players;
        }
        if (players == 0) {
            ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.fluffy_fur.skin.item.set.failed", (Object[])new Object[]{Component.m_237115_((String)itemSkin.getTranslatedName())}));
        } else if (players == 1) {
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.fluffy_fur.skin.item.set.single", (Object[])new Object[]{Component.m_237115_((String)itemSkin.getTranslatedName()), ((ServerPlayer)targetPlayers.iterator().next()).m_21205_().m_41611_()}), true);
        } else {
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.fluffy_fur.skin.item.set.multiple", (Object[])new Object[]{Component.m_237115_((String)itemSkin.getTranslatedName()), targetPlayers.size()}), true);
        }
        return 1;
    }

    private static int removeItemSkin(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> targetPlayers) throws CommandSyntaxException {
        int players = 0;
        for (ServerPlayer player : targetPlayers) {
            ItemSkin itemSkin;
            ItemStack stack = player.m_21205_();
            if (stack.m_41619_() || (itemSkin = ItemSkin.getSkinFromItem(stack)) == null) continue;
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128473_("skin");
            ++players;
        }
        if (players == 0) {
            ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.fluffy_fur.skin.item.remove.failed"));
        } else if (players == 1) {
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.fluffy_fur.skin.item.remove.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_21205_().m_41611_()}), true);
        } else {
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.fluffy_fur.skin.item.remove.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
        }
        return 1;
    }
}

