/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.common.event;

import com.mojang.brigadier.CommandDispatcher;
import mod.maxbogomol.fluffy_fur.common.capability.IPlayerSkin;
import mod.maxbogomol.fluffy_fur.common.capability.PlayerSkinProvider;
import mod.maxbogomol.fluffy_fur.common.command.FluffyFurCommand;
import mod.maxbogomol.fluffy_fur.common.network.BloodPacket;
import mod.maxbogomol.fluffy_fur.common.network.FluffyFurPacketHandler;
import mod.maxbogomol.fluffy_fur.common.network.playerskin.PlayerSkinUpdatePacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FluffyFurEvents {
    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("fluffy_fur", "player_skin"), (ICapabilityProvider)new PlayerSkinProvider());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        Capability<IPlayerSkin> SKIN = IPlayerSkin.INSTANCE;
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(SKIN).ifPresent(k -> event.getOriginal().getCapability(SKIN).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        if (!event.getEntity().m_9236_().f_46443_) {
            FluffyFurPacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new PlayerSkinUpdatePacket(event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!event.getLevel().m_5776_()) {
                FluffyFurPacketHandler.sendTo((ServerPlayer)event.getEntity(), (Object)new PlayerSkinUpdatePacket(player));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            FluffyFurPacketHandler.sendTo(player, (Object)new PlayerSkinUpdatePacket(target));
            FluffyFurPacketHandler.sendTo(target, (Object)new PlayerSkinUpdatePacket(player));
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            FluffyFurPacketHandler.sendToTracking(level, BlockPos.m_274446_((Position)pos), new BloodPacket(pos, event.getAmount()));
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        FluffyFurCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

