/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.common.itemskin;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mod.maxbogomol.fluffy_fur.client.model.armor.ArmorModel;
import mod.maxbogomol.fluffy_fur.common.itemskin.ItemSkinEntry;
import mod.maxbogomol.fluffy_fur.common.itemskin.ItemSkinHandler;
import mod.maxbogomol.fluffy_fur.registry.client.FluffyFurModels;
import mod.maxbogomol.fluffy_fur.util.ColorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemSkin {
    public String id;
    public Color color;
    public List<ItemSkinEntry> skinEntries = new ArrayList<ItemSkinEntry>();
    public List<Component> applyingItems = new ArrayList<Component>();

    public ItemSkin(String id) {
        this.id = id;
        this.color = Color.WHITE;
    }

    public ItemSkin(String id, Color color) {
        this.id = id;
        this.color = color;
    }

    public String getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }

    public String getTranslatedName() {
        return ItemSkin.getTranslatedName(this.id);
    }

    public static String getTranslatedName(String id) {
        int i = id.indexOf(":");
        String modId = id.substring(0, i);
        String monogramId = id.substring(i + 1);
        return "item_skin." + modId + "." + monogramId;
    }

    public static Component getSkinName(ItemSkin skin) {
        Color color = skin.getColor();
        return Component.m_237115_((String)skin.getTranslatedName()).m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(color)));
    }

    public static Component getSkinComponent(ItemSkin skin) {
        return Component.m_237115_((String)"lore.fluffy_fur.skin").m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(255, 249, 210, 129))).m_130946_(" ").m_7220_(ItemSkin.getSkinName(skin));
    }

    public static List<Component> getApplyingItemsComponents(ItemSkin skin, boolean isShift) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"lore.fluffy_fur.skin_applies").m_7220_((Component)(isShift ? Component.m_237119_() : Component.m_237113_((String)" []"))).m_130940_(ChatFormatting.GRAY));
        if (isShift) {
            for (Component component : skin.applyingItems) {
                list.add((Component)Component.m_237113_((String)" ").m_7220_(component).m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(255, 249, 210, 129))));
            }
        }
        return list;
    }

    public Component getSkinName() {
        return ItemSkin.getSkinName(this);
    }

    public Component getSkinComponent() {
        return ItemSkin.getSkinComponent(this);
    }

    public List<Component> getApplyingItemsComponents(boolean isShift) {
        return ItemSkin.getApplyingItemsComponents(this, isShift);
    }

    public void addApplyingItem(Component component) {
        this.applyingItems.add(component);
    }

    public boolean canApplyOnItem(ItemStack itemStack) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack applyOnItem(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128359_("skin", this.getId());
        return itemStack;
    }

    public static ItemSkin getSkinFromItem(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_("skin")) {
            return ItemSkinHandler.getSkin(nbt.m_128461_("skin"));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmorModel getArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(itemStack)) continue;
            return skinEntry.getArmorModel(entity, itemStack, armorSlot, _default);
        }
        return FluffyFurModels.EMPTY_ARMOR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(stack)) continue;
            return skinEntry.getArmorTexture(stack, entity, slot, type);
        }
        return "fluffy_fur:textures/models/armor/skin/empty.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getItemModelName(ItemStack stack) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(stack)) continue;
            return skinEntry.getItemModelName(stack);
        }
        return null;
    }

    public List<ItemSkinEntry> getSkinEntries() {
        return this.skinEntries;
    }

    public void addSkinEntry(ItemSkinEntry skinEntry) {
        this.skinEntries.add(skinEntry);
    }

    public void setupSkinEntries() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isDefaultModel(Entity entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            return player.m_108564_().equals("default");
        }
        return true;
    }
}

