/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.common.network;

import java.awt.Color;
import mod.maxbogomol.fluffy_fur.common.network.ClientPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public abstract class TwoPositionColorClientPacket
extends ClientPacket {
    protected final double x1;
    protected final double y1;
    protected final double z1;
    protected final double x2;
    protected final double y2;
    protected final double z2;
    protected final float r;
    protected final float g;
    protected final float b;
    protected final float a;

    public TwoPositionColorClientPacket(double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public TwoPositionColorClientPacket(BlockPos pos, Vec3 vec, Color color) {
        this.x1 = pos.m_123341_();
        this.y1 = pos.m_123342_();
        this.z1 = pos.m_123343_();
        this.x2 = vec.m_7096_();
        this.y2 = vec.m_7098_();
        this.z2 = vec.m_7094_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = 1.0f;
    }

    public TwoPositionColorClientPacket(Vec3 vec1, Vec3 vec2, Color color) {
        this.x1 = vec1.m_7096_();
        this.y1 = vec1.m_7098_();
        this.z1 = vec1.m_7094_();
        this.x2 = vec2.m_7096_();
        this.y2 = vec2.m_7098_();
        this.z2 = vec2.m_7094_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = 1.0f;
    }

    public TwoPositionColorClientPacket(Vec3 vec1, Vec3 vec2, Color color, float a) {
        this.x1 = vec1.m_7096_();
        this.y1 = vec1.m_7098_();
        this.z1 = vec1.m_7094_();
        this.x2 = vec2.m_7096_();
        this.y2 = vec2.m_7098_();
        this.z2 = vec2.m_7094_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = a;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x1);
        buf.writeDouble(this.y1);
        buf.writeDouble(this.z1);
        buf.writeDouble(this.x2);
        buf.writeDouble(this.y2);
        buf.writeDouble(this.z2);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.a);
    }

    public static <T extends TwoPositionColorClientPacket> T decode(PacketProvider<T> provider, FriendlyByteBuf buf) {
        double x1 = buf.readDouble();
        double y1 = buf.readDouble();
        double z1 = buf.readDouble();
        double x2 = buf.readDouble();
        double y2 = buf.readDouble();
        double z2 = buf.readDouble();
        float r = buf.readFloat();
        float g = buf.readFloat();
        float b = buf.readFloat();
        float a = buf.readFloat();
        return provider.getPacket(x1, y1, z1, x2, y2, z2, r, g, b, a);
    }

    public static interface PacketProvider<T extends TwoPositionColorClientPacket> {
        public T getPacket(double var1, double var3, double var5, double var7, double var9, double var11, float var13, float var14, float var15, float var16);
    }
}

