/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.common.raycast;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.maxbogomol.fluffy_fur.common.raycast.RayCastContext;
import mod.maxbogomol.fluffy_fur.common.raycast.RayHitResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RayCast {
    public static RayHitResult getHit(Level level, RayCastContext context) {
        Vec3 start = context.getStartPos();
        Vec3 end = context.getEndPos();
        int entityCount = context.getEntityCount();
        float size = context.getEntitySize();
        boolean entityEnd = context.getEntityEnd();
        Predicate<BlockPos> blockPosFilter = context.getBlockPosFilter();
        Predicate<Entity> entityFilter = context.getEntityFilter();
        double distance = Math.sqrt(Math.pow(start.m_7096_() - end.m_7096_(), 2.0) + Math.pow(start.m_7098_() - end.m_7098_(), 2.0) + Math.pow(start.m_7094_() - end.m_7094_(), 2.0));
        double X = start.m_7096_();
        double Y = start.m_7098_();
        double Z = start.m_7094_();
        double oldX = X;
        double oldY = Y;
        double oldZ = Z;
        int count = 0;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        float i = 0.0f;
        while ((double)i < distance * 160.0) {
            BlockPos blockPos;
            BlockHitResult blockHitResult;
            double dst = distance * 160.0;
            double dX = start.m_7096_() - end.m_7096_();
            double dY = start.m_7098_() - end.m_7098_();
            double dZ = start.m_7094_() - end.m_7094_();
            double x = -(dX / dst) * (double)i;
            double y = -(dY / dst) * (double)i;
            double z = -(dZ / dst) * (double)i;
            X = start.m_7096_() + x;
            Y = start.m_7098_() + y;
            Z = start.m_7094_() + z;
            boolean canEntity = true;
            if (entityEnd) {
                boolean bl = canEntity = entityCount > 0;
            }
            if (canEntity) {
                List entityList = level.m_45976_(Entity.class, new AABB(X - (double)size, Y - (double)size, Z - (double)size, X + (double)size, Y + (double)size, Z + (double)size));
                for (Entity entity : entityList) {
                    if (!entityFilter.test(entity) || entities.contains(entity)) continue;
                    entities.add(entity);
                    if (!entityEnd || ++count < entityCount) continue;
                    return new RayHitResult(new Vec3(X, Y, Z)).setEntities(entities);
                }
            }
            if ((blockHitResult = context.getBlockShape(level.m_8055_(blockPos = BlockPos.m_274561_((double)X, (double)Y, (double)Z)), (BlockGetter)level, blockPos).m_83220_(start, end, blockPos)) != null && blockPosFilter.test(blockPos)) {
                boolean isBlock = !level.m_8055_(blockHitResult.m_82425_()).m_60795_();
                return new RayHitResult(new Vec3(oldX, oldY, oldZ)).setHitPos(new Vec3(X, Y, Z)).setBlockPos(blockHitResult.m_82425_()).setDirection(blockHitResult.m_82434_()).setBlock(isBlock).setEntities(entities);
            }
            blockHitResult = context.getFluidShape(level.m_6425_(blockPos), (BlockGetter)level, blockPos).m_83220_(start, end, blockPos);
            if (blockHitResult != null) {
                return new RayHitResult(new Vec3(oldX, oldY, oldZ)).setHitPos(new Vec3(X, Y, Z)).setBlockPos(blockHitResult.m_82425_()).setDirection(blockHitResult.m_82434_()).setBlock(true).setEntities(entities);
            }
            oldX = X;
            oldY = Y;
            oldZ = Z;
            i += 1.0f;
        }
        return new RayHitResult(new Vec3(X, Y, Z)).setEntities(entities);
    }

    public static RayHitResult getHit(Level level, Vec3 start, Vec3 end) {
        return RayCast.getHit(level, new RayCastContext(start, end));
    }

    public static List<Entity> getHitEntities(Level level, Vec3 start, Vec3 endPos, float distance) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        float ds = (float)Math.sqrt(Math.pow(start.m_7096_() - endPos.m_7096_(), 2.0) + Math.pow(start.m_7098_() - endPos.m_7098_(), 2.0) + Math.pow(start.m_7094_() - endPos.m_7094_(), 2.0));
        for (float i = 0.0f; i < ds * 10.0f; i += 1.0f) {
            float dst = ds * 10.0f;
            double dX = start.m_7096_() - endPos.m_7096_();
            double dY = start.m_7098_() - endPos.m_7098_();
            double dZ = start.m_7094_() - endPos.m_7094_();
            float x = (float)(-(dX / (double)dst)) * i;
            float y = (float)(-(dY / (double)dst)) * i;
            float z = (float)(-(dZ / (double)dst)) * i;
            float X = (float)(start.m_7096_() + (double)x);
            float Y = (float)(start.m_7098_() + (double)y);
            float Z = (float)(start.m_7094_() + (double)z);
            List entityList = level.m_45976_(Entity.class, new AABB((double)(X - distance), (double)(Y - distance), (double)(Z - distance), (double)(X + distance), (double)(Y + distance), (double)(Z + distance)));
            for (Entity entity : entityList) {
                if (list.contains(entity)) continue;
                list.add(entity);
            }
        }
        return list;
    }
}

