/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.integration.client.fusion.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MatchBlockTagConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchBlockTagConnectionPredicate> SERIALIZER = new Serializer<MatchBlockTagConnectionPredicate>(){

        public MatchBlockTagConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match block predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier((String)json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
            return new MatchBlockTagConnectionPredicate((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)identifier));
        }

        public JsonObject serialize(MatchBlockTagConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", value.block.toString());
            return json;
        }
    };
    private final TagKey<Block> block;

    public MatchBlockTagConnectionPredicate(TagKey<Block> block) {
        this.block = block;
    }

    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        return otherState.m_204336_(this.block);
    }

    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchBlockTagConnectionPredicate)) {
            return false;
        }
        MatchBlockTagConnectionPredicate that = (MatchBlockTagConnectionPredicate)o;
        return this.block.equals(that.block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }
}

