/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.registry.common.block;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import mod.maxbogomol.fluffy_fur.FluffyFur;
import mod.maxbogomol.fluffy_fur.common.block.plush.PlushBlock;
import mod.maxbogomol.fluffy_fur.common.fire.FireBlockHandler;
import mod.maxbogomol.fluffy_fur.common.fire.FireBlockModifier;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FluffyFurBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"fluffy_fur");
    public static final RegistryObject<Block> POTTED_PINK_PETALS = BLOCKS.register("potted_pink_petals", () -> new FlowerPotBlock(Blocks.f_271445_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_).m_60966_().m_60955_()));
    public static final RegistryObject<Block> MAXBOGOMOL_PLUSH = BLOCKS.register("maxbogomol_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283870_).m_60955_()));
    public static final RegistryObject<Block> ONIXTHECAT_PLUSH = BLOCKS.register("onixthecat_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283919_).m_60955_()));
    public static final RegistryObject<Block> UNOLOGICALSAMSAR_PLUSH = BLOCKS.register("unlogicalsamsar_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283774_).m_60955_()));
    public static final RegistryObject<Block> FOXAIRPLANE_PLUSH = BLOCKS.register("foxairplane_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283798_).m_60955_()));
    public static final RegistryObject<Block> ONJERLAY_PLUSH = BLOCKS.register("onjerlay_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283843_).m_60955_()));
    public static final RegistryObject<Block> SAMMYSEMICOLON_PLUSH = BLOCKS.register("sammysemicolon_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283861_).m_60955_()));
    public static final RegistryObject<Block> BOYKISSER_PLUSH = BLOCKS.register("boykisser_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283919_).m_60955_()));
    public static final RegistryObject<Block> NANACHI_PLUSH = BLOCKS.register("nanachi_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283895_).m_60955_()));
    public static final RegistryObject<Block> SPECKLE_PLUSH = BLOCKS.register("speckle_plush", () -> new PlushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(MapColor.f_283919_).m_60955_()));
    public static final RegistryObject<Block> YONKABLOCK = BLOCKS.register("yonkablock", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_)));
    public static FireBlock fireblock;

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public static Block[] getBlocks(Class<?> ... blockClasses) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(block))) continue;
            matchingBlocks.add(block);
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static Block[] getBlocksExact(Class<?> clazz) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!clazz.equals(block.getClass())) continue;
            matchingBlocks.add(block);
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static void setFireBlock() {
        fireblock = (FireBlock)Blocks.f_50083_;
        FireBlockHandler.register(new FireBlockModifier());
    }

    public static void axeStrippables(Block block, Block result) {
        AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)block, (Object)result).build();
    }

    public static void fireBlock(Block block, int encouragement, int flammability) {
        fireblock.m_53444_(block, encouragement, flammability);
    }

    public static void weatheringCopper(Block block, Block result) {
        try {
            Field delegateField = WeatheringCopper.f_154886_.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            java.util.function.Supplier originalWeatheringMapDelegate = (java.util.function.Supplier)delegateField.get(WeatheringCopper.f_154886_);
            Supplier weatheringMapDelegate = () -> FluffyFurBlocks.lambda$weatheringCopper$12((java.util.function.Supplier)originalWeatheringMapDelegate, block, result);
            delegateField.set(WeatheringCopper.f_154886_, weatheringMapDelegate);
        }
        catch (Exception e) {
            FluffyFur.LOGGER.error("Failed weathering copper", (Throwable)e);
        }
    }

    public static void waxedCopper(Block block, Block result) {
        java.util.function.Supplier originalWaxableMapSupplier = HoneycombItem.f_150863_;
        HoneycombItem.f_150863_ = Suppliers.memoize(() -> FluffyFurBlocks.lambda$waxedCopper$13((java.util.function.Supplier)originalWaxableMapSupplier, block, result));
    }

    private static /* synthetic */ BiMap lambda$waxedCopper$13(java.util.function.Supplier originalWaxableMapSupplier, Block block, Block result) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.putAll((Map)originalWaxableMapSupplier.get());
        builder.put((Object)block, (Object)result);
        return builder.build();
    }

    private static /* synthetic */ BiMap lambda$weatheringCopper$12(java.util.function.Supplier originalWeatheringMapDelegate, Block block, Block result) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.putAll((Map)originalWeatheringMapDelegate.get());
        builder.put((Object)block, (Object)result);
        return builder.build();
    }

    @Mod.EventBusSubscriber(modid="fluffy_fur", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEntities(FMLCommonSetupEvent event) {
            PlushBlock.foxSoundPlush.add((Block)MAXBOGOMOL_PLUSH.get());
            PlushBlock.foxSoundPlush.add((Block)UNOLOGICALSAMSAR_PLUSH.get());
            PlushBlock.foxSoundPlush.add((Block)FOXAIRPLANE_PLUSH.get());
            PlushBlock.foxSoundPlush.add((Block)ONJERLAY_PLUSH.get());
            PlushBlock.foxSoundPlush.add((Block)NANACHI_PLUSH.get());
            PlushBlock.goatSoundPlush.add((Block)ONIXTHECAT_PLUSH.get());
            PlushBlock.catSoundPlush.add((Block)SAMMYSEMICOLON_PLUSH.get());
            PlushBlock.catSoundPlush.add((Block)BOYKISSER_PLUSH.get());
            PlushBlock.catSoundPlush.add((Block)SPECKLE_PLUSH.get());
        }
    }
}

