/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.util;

import java.awt.Color;
import java.util.ArrayList;

public class ColorUtil {
    public static int getAlpha(int packedColor) {
        return packedColor >>> 24;
    }

    public static int getRed(int packedColor) {
        return packedColor >> 16 & 0xFF;
    }

    public static int getGreen(int packedColor) {
        return packedColor >> 8 & 0xFF;
    }

    public static int getBlue(int packedColor) {
        return packedColor & 0xFF;
    }

    public static Color getColor(int color) {
        return new Color(ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), ColorUtil.getAlpha(color));
    }

    public static int packColor(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int packColor(Color color) {
        return color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public static Color rainbowColor(float ticks) {
        int r = (int)(Math.sin(ticks) * 127.0 + 128.0);
        int g = (int)(Math.sin((double)ticks + 1.5707963267948966) * 127.0 + 128.0);
        int b = (int)(Math.sin((double)ticks + Math.PI) * 127.0 + 128.0);
        return new Color(r, g, b);
    }

    public static Color getBlendColor(ArrayList<Color> colors) {
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (Color color : colors) {
            int k = ColorUtil.packColor(color);
            f += (float)(k >> 16 & 0xFF) / 255.0f;
            f1 += (float)(k >> 8 & 0xFF) / 255.0f;
            f2 += (float)(k >> 0 & 0xFF) / 255.0f;
            ++j;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return ColorUtil.getColor((int)f << 16 | (int)f1 << 8 | (int)f2);
    }
}

