/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeUtil {
    public static FluidStack deserializeFluidStack(JsonObject json) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Unknown fluid " + fluidName);
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        return new FluidStack(fluid, amount);
    }

    public static MobEffectInstance deserializeMobEffect(JsonObject json) {
        String effectName = GsonHelper.m_13906_((JsonObject)json, (String)"effect");
        MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        if (mobEffect == null) {
            throw new JsonSyntaxException("Unknown effect " + effectName);
        }
        int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        int amplifier = GsonHelper.m_13927_((JsonObject)json, (String)"amplifier");
        return new MobEffectInstance(mobEffect, duration, amplifier);
    }

    public static MobEffectInstance mobEffectFromNetwork(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            MobEffect mobEffect = (MobEffect)buffer.readRegistryId();
            int duration = buffer.readInt();
            int amplifier = buffer.readInt();
            return new MobEffectInstance(mobEffect, duration, amplifier);
        }
        return null;
    }

    public static void mobEffectToNetwork(MobEffectInstance effect, FriendlyByteBuf buffer) {
        if (effect == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeRegistryId(ForgeRegistries.MOB_EFFECTS, (Object)effect.m_19544_());
            buffer.writeInt(effect.m_19557_());
            buffer.writeInt(effect.m_19564_());
        }
    }

    public static Enchantment deserializeEnchantment(JsonObject json) {
        String enchantmentName = GsonHelper.m_13906_((JsonObject)json, (String)"enchantment");
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentName));
        if (enchantment == null) {
            throw new JsonSyntaxException("Unknown enchantment " + enchantmentName);
        }
        return enchantment;
    }

    public static Enchantment enchantmentFromNetwork(FriendlyByteBuf buffer) {
        return !buffer.readBoolean() ? null : (Enchantment)buffer.readRegistryId();
    }

    public static void enchantmentToNetwork(Enchantment enchantment, FriendlyByteBuf buffer) {
        if (enchantment == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeRegistryId(ForgeRegistries.ENCHANTMENTS, (Object)enchantment);
        }
    }
}

