/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.compat.jei;

import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.coolerpromc.arrowplus.util.ArrowData;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)"jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getJeiHelpers().getVanillaRecipeFactory();
        String group = "arrowplus.arrow";
        List<RecipeHolder> arrowRecipes = RegistryUtil.getRegistryAccess().lookupOrThrow(ModRegistries.ARROW_DATA_KEY).listElements().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.key().location().getPath())).map(data -> {
            Ingredient ingredient = Ingredient.of((ItemLike)Items.FLINT);
            ResourceLocation materialLocation = ResourceLocation.parse((String)"invalid");
            ItemStack output = new ItemStack((ItemLike)ModItems.ARROW_PLUS.get(), 4);
            output.set(ModDataComponents.ARROW_DATA, data);
            if (((ArrowData)data.value()).material().left().isPresent()) {
                ingredient = Ingredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.getValue((ResourceLocation)((ArrowData)data.value()).material().left().get())));
                materialLocation = (ResourceLocation)((ArrowData)data.value()).material().left().get();
            } else if (((ArrowData)data.value()).material().right().isPresent()) {
                ingredient = Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow((TagKey)((ArrowData)data.value()).material().right().get()));
                materialLocation = ((TagKey)((ArrowData)data.value()).material().right().get()).location();
            }
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)("arrowplus.arrow." + materialLocation.getPath()));
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id);
            SlotDisplay.ItemStackSlotDisplay slotDisplay = new SlotDisplay.ItemStackSlotDisplay(output);
            CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, (SlotDisplay)slotDisplay).group(group).define(Character.valueOf('m'), ingredient).define(Character.valueOf('s'), Ingredient.of((ItemLike)Items.STICK)).define(Character.valueOf('f'), Ingredient.of((ItemLike)Items.FEATHER)).pattern(" m ").pattern(" s ").pattern(" f ").build();
            return new RecipeHolder(resourceKey, (Recipe)recipe);
        }).toList();
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, arrowRecipes);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerFromDataComponentTypes((Item)ModItems.ARROW_PLUS.get(), new DataComponentType[]{ModDataComponents.ARROW_DATA.get()});
    }
}

