/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.compat.rei;

import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.datagen.datapack.ArrowRecipe;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.coolerpromc.arrowplus.util.ArrowData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class ArrowRecipeFiller
implements Function<RecipeHolder<ArrowRecipe>, Collection<Display>> {
    public void registerDisplays(ServerDisplayRegistry registry) {
        registry.beginRecipeFiller(this.getRecipeClass()).filterType(RecipeType.CRAFTING).fillMultiple((Function)this);
    }

    Class<ArrowRecipe> getRecipeClass() {
        return ArrowRecipe.class;
    }

    @Override
    public Collection<Display> apply(RecipeHolder<ArrowRecipe> recipeHolder) {
        ArrayList<Display> displays = new ArrayList<Display>();
        BasicDisplay.registryAccess().lookupOrThrow(ModRegistries.ARROW_DATA_KEY).listElements().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.key().location().getPath())).forEach(data -> {
            Ingredient ingredient = Ingredient.of((ItemLike)Items.FLINT);
            ResourceLocation materialLocation = ResourceLocation.parse((String)"invalid");
            ItemStack output = new ItemStack((ItemLike)ModItems.ARROW_PLUS.get(), 4);
            output.set(ModDataComponents.ARROW_DATA, data);
            if (((ArrowData)data.value()).material().left().isPresent()) {
                ingredient = Ingredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.getValue((ResourceLocation)((ArrowData)data.value()).material().left().get())));
                materialLocation = (ResourceLocation)((ArrowData)data.value()).material().left().get();
            } else if (((ArrowData)data.value()).material().right().isPresent()) {
                ingredient = Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow((TagKey)((ArrowData)data.value()).material().right().get()));
                materialLocation = ((TagKey)((ArrowData)data.value()).material().right().get()).location();
            }
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)("arrowplus.arrow." + materialLocation.getPath()));
            List<EntryIngredient> inputEntries = List.of(EntryIngredient.empty(), EntryIngredients.ofIngredient((Ingredient)ingredient), EntryIngredient.empty(), EntryIngredient.empty(), EntryIngredients.of((ItemLike)Items.STICK), EntryIngredient.empty(), EntryIngredient.empty(), EntryIngredients.of((ItemLike)Items.FEATHER), EntryIngredient.empty());
            displays.add((Display)new DefaultCustomDisplay(inputEntries, List.of(EntryIngredients.of((ItemStack)output)), Optional.of(id)));
        });
        return displays;
    }
}

