/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.datagen.datapack;

import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.coolerpromc.arrowplus.util.ArrowData;
import com.coolerpromc.arrowplus.util.ModRecipeSerializer;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ArrowRecipe
extends CustomRecipe {
    public ArrowRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() == 1 && craftingInput.height() == 3 && craftingInput.ingredientCount() == 3) {
            ArrayList materialList = new ArrayList();
            level.registryAccess().lookupOrThrow(ModRegistries.ARROW_DATA_KEY).listElements().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.key().location().getPath())).forEach(arrowData -> materialList.add(((ArrowData)arrowData.value()).material()));
            boolean hasMaterial = false;
            boolean hasStick = false;
            boolean hasFeather = false;
            ItemStack materialStack = craftingInput.getItem(0);
            for (Either material : materialList) {
                if (material.left().isPresent() && ((ResourceLocation)material.left().get()).equals((Object)BuiltInRegistries.ITEM.getKey((Object)materialStack.getItem()))) {
                    hasMaterial = true;
                    break;
                }
                if (!material.right().isPresent() || !materialStack.is((TagKey)material.right().get())) continue;
                hasMaterial = true;
                break;
            }
            if (craftingInput.getItem(1).is(Items.STICK)) {
                hasStick = true;
            }
            if (craftingInput.getItem(2).is(Items.FEATHER)) {
                hasFeather = true;
            }
            return hasMaterial && hasStick && hasFeather;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ArrayList materialList = new ArrayList();
        AtomicReference arrowData = new AtomicReference();
        ItemStack materialStack = craftingInput.getItem(0);
        provider.lookupOrThrow(ModRegistries.ARROW_DATA_KEY).listElements().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.key().location().getPath())).forEach(holder -> {
            materialList.add(((ArrowData)holder.value()).material());
            if (((ArrowData)holder.value()).material().left().isPresent() && ((ResourceLocation)((ArrowData)holder.value()).material().left().get()).equals((Object)BuiltInRegistries.ITEM.getKey((Object)materialStack.getItem()))) {
                arrowData.set(holder);
            } else if (((ArrowData)holder.value()).material().right().isPresent() && materialStack.is((TagKey)((ArrowData)holder.value()).material().right().get())) {
                arrowData.set(holder);
            }
        });
        if (materialList.contains(((ArrowData)((Holder)arrowData.get()).value()).material())) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.ARROW_PLUS.get(), 4);
            stack.set(ModDataComponents.ARROW_DATA, (Object)((Holder)arrowData.get()));
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializer.ARROW_RECIPE_SERIALIZER.get();
    }
}

