/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.renderer;

import com.coolerpromc.arrowplus.entity.custom.ModArrowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class ModArrowRenderer
extends ArrowRenderer<ModArrowEntity> {
    public final ResourceLocation arrowTexture;
    public static final ResourceLocation BODY_TEXTURE = ModArrowRenderer.getTextureLocation("arrow_plus");
    public static final ResourceLocation HEAD_TEXTURE = ModArrowRenderer.getTextureLocation("arrow_plus_head");

    public ModArrowRenderer(EntityRendererProvider.Context context, ResourceLocation arrowTexture) {
        super(context);
        this.arrowTexture = arrowTexture;
    }

    public static ResourceLocation getTextureLocation(String textureName) {
        return ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)("textures/entity/projectiles/" + textureName + ".png"));
    }

    public void render(ModArrowEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) - 90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        float f9 = (float)entity.f_36706_ - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -Mth.m_14031_((float)(f9 * 3.0f)) * f9;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f10));
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        poseStack.m_85841_(0.05625f, 0.05625f, 0.05625f);
        poseStack.m_252880_(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)HEAD_TEXTURE));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight, entity.getArrowData().color());
        for (int j = 0; j < 4; ++j) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            this.setVertex(posestack$pose, vertexconsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight, entity.getArrowData().color());
            this.setVertex(posestack$pose, vertexconsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight, entity.getArrowData().color());
            this.setVertex(posestack$pose, vertexconsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight, entity.getArrowData().color());
            this.setVertex(posestack$pose, vertexconsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight, entity.getArrowData().color());
        }
        poseStack.m_85849_();
        super.m_7392_((AbstractArrow)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void setVertex(PoseStack.Pose pose, VertexConsumer consumer, int x, int y, int z, float u, float v, int normalX, int normalY, int normalZ, int packedLight, int color) {
        consumer.m_252986_(pose.m_252922_(), (float)x, (float)y, (float)z).m_193479_(color).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), (float)normalX, (float)normalZ, (float)normalY).m_5752_();
    }

    public ResourceLocation getTextureLocation(ModArrowEntity arrowEntity) {
        return BODY_TEXTURE;
    }
}

