/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus;

import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.entity.ModEntities;
import com.coolerpromc.arrowplus.entity.renderer.ModArrowRenderer;
import com.coolerpromc.arrowplus.item.ModCreativeTabs;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.util.ArrowData;
import com.coolerpromc.arrowplus.util.ModRecipeSerializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="arrowplus")
public class ArrowPlus {
    public static final String MODID = "arrowplus";

    public ArrowPlus() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModEntities.register(modEventBus);
        ModRecipeSerializer.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ArrowPlusConfig.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingGetProjectile);
    }

    @SubscribeEvent
    public void onLivingGetProjectile(LivingGetProjectileEvent event) {
        if (event.getProjectileItemStack().m_150930_(Items.f_42412_)) {
            event.setProjectileItemStack(new ItemStack((ItemLike)event.getProjectileItemStack().m_41720_(), event.getProjectileItemStack().m_41613_()));
        }
    }

    @Mod.EventBusSubscriber(modid="arrowplus", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntities.ARROW_PLUS.get(), context -> new ModArrowRenderer(context, ModArrowRenderer.getTextureLocation("arrow_plus")));
        }

        @SubscribeEvent
        public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
            event.register((itemStack, i) -> {
                ArrowData arrowData;
                if (itemStack.m_41720_() == ModItems.ARROW_PLUS.get() && Minecraft.m_91087_().f_91073_ != null && (arrowData = ArrowData.load(itemStack.m_41784_(), Minecraft.m_91087_().f_91073_.m_9598_())) != null && i == 1) {
                    return arrowData.color();
                }
                return -1;
            }, new ItemLike[]{(ItemLike)ModItems.ARROW_PLUS.get()});
            event.register((itemStack, i) -> {
                if (itemStack.m_150930_(Items.f_42411_)) {
                    ItemStack projectile;
                    CompoundTag projectileTag;
                    ArrowData arrowData;
                    Minecraft minecraft = Minecraft.m_91087_();
                    LocalPlayer player = minecraft.f_91074_;
                    if (player != null && Minecraft.m_91087_().f_91073_ != null && (arrowData = ArrowData.load(projectileTag = (projectile = player.m_6298_(itemStack)).m_41784_(), Minecraft.m_91087_().f_91073_.m_9598_())) != null && i == 1) {
                        return arrowData.color();
                    }
                }
                return -1;
            }, new ItemLike[]{Items.f_42411_});
        }
    }
}

