/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.custom;

import com.coolerpromc.arrowplus.entity.ModEntities;
import com.coolerpromc.arrowplus.util.ArrowData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModArrowEntity
extends AbstractArrow {
    private final ItemStack stack;
    private static final EntityDataAccessor<ArrowData> ARROW_DATA = SynchedEntityData.m_135353_(ModArrowEntity.class, ModEntities.ARROW_DATA.get());

    public ModArrowEntity(EntityType<? extends AbstractArrow> p_331098_, Level p_331626_, ItemStack pickupItemStack) {
        super(p_331098_, p_331626_);
        this.stack = pickupItemStack;
        this.updateArrowData();
    }

    public ModArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, Level level, ItemStack pickupItemStack, double baseDamage) {
        super(entityType, owner, level);
        this.stack = pickupItemStack;
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        ItemStack firedFromWeapon = owner.m_21211_();
        if (firedFromWeapon.m_41720_() instanceof BowItem) {
            int infinityLevel;
            int powerLevel = firedFromWeapon.getEnchantmentLevel(Enchantments.f_44988_);
            if (powerLevel > 0) {
                baseDamage += baseDamage * 0.25 * (double)(powerLevel + 1);
            }
            this.f_36705_ = (infinityLevel = firedFromWeapon.getEnchantmentLevel(Enchantments.f_44952_)) > 0 ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
        }
        this.m_36781_(baseDamage);
        this.updateArrowData();
    }

    public ModArrowEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(entityType, x, y, z, level);
        this.stack = pickupItemStack;
        this.updateArrowData();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARROW_DATA, (Object)ArrowData.EMPTY);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.getArrowData().save(tag, this.m_9236_().m_9598_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.getArrowData() != null) {
            this.f_19804_.m_135381_(ARROW_DATA, (Object)ArrowData.load(tag, this.m_9236_().m_9598_()));
        }
    }

    protected ItemStack m_7941_() {
        return this.stack;
    }

    public void updateArrowData() {
        this.f_19804_.m_135381_(ARROW_DATA, (Object)ArrowData.load(this.stack.m_41784_(), this.m_9236_().m_9598_()));
    }

    public ArrowData getArrowData() {
        return (ArrowData)this.f_19804_.m_135370_(ARROW_DATA);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)this.getArrowData().translationKey());
    }

    public void m_8119_() {
        if (this.f_36703_) {
            super.m_8119_();
            return;
        }
        Vec3 motion = this.m_20184_();
        double gravity = this.getArrowData().gravity();
        if (!this.m_20068_()) {
            motion = motion.m_82520_(0.0, -gravity, 0.0);
        }
        this.m_20256_(motion);
        super.m_8119_();
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        this.getArrowData().effects().forEach((resourceLocation, integer) -> BuiltInRegistries.f_256980_.m_6612_(resourceLocation).ifPresent(potionReference -> potionReference.m_43488_().forEach(instance -> entity.m_7292_(new MobEffectInstance(instance.m_19544_(), integer.intValue(), instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_())))));
    }

    public boolean m_6060_() {
        return this.getArrowData().flame();
    }
}

