/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.util;

import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public record ArrowData(Either<ResourceLocation, TagKey<Item>> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<ResourceLocation, Integer> effects) {
    public static final Codec<Either<ResourceLocation, TagKey<Item>>> MATERIAL_CODEC = Codec.either((Codec)ResourceLocation.f_135803_, (Codec)TagKey.m_203886_((ResourceKey)Registries.f_256913_));
    public static final Codec<ArrowData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_CODEC.fieldOf("material").forGetter(ArrowData::material), (App)Codec.DOUBLE.fieldOf("baseDamage").forGetter(ArrowData::baseDamage), (App)Codec.INT.fieldOf("color").forGetter(ArrowData::color), (App)Codec.STRING.fieldOf("translationKey").forGetter(ArrowData::translationKey), (App)Codec.BOOL.fieldOf("flame").forGetter(ArrowData::flame), (App)Codec.DOUBLE.fieldOf("gravity").forGetter(ArrowData::gravity), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT).fieldOf("effects").forGetter(ArrowData::effects)).apply((Applicative)instance, ArrowData::new));
    public static final ArrowData EMPTY = new ArrowData(Items.f_41852_, 0.0, -15461356, "item.arrowplus.cheated_item", false, 0.05, Map.of());

    public ArrowData(Item material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<ResourceLocation, Integer> effects) {
        this((Either<ResourceLocation, TagKey<Item>>)Either.left((Object)BuiltInRegistries.f_257033_.m_7981_((Object)material)), baseDamage, color, translationKey, flame, gravity, effects);
    }

    public ArrowData(TagKey<Item> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<ResourceLocation, Integer> effects) {
        this((Either<ResourceLocation, TagKey<Item>>)Either.right(material), baseDamage, color, translationKey, flame, gravity, effects);
    }

    public CompoundTag save(CompoundTag existingTag, @Nullable ResourceLocation rl) {
        if (rl != null) {
            existingTag.m_128359_("arrow_data", rl.toString());
        }
        return existingTag;
    }

    public CompoundTag save(CompoundTag existingTag, RegistryAccess registryAccess) {
        ResourceLocation rl = registryAccess.m_175515_(ModRegistries.ARROW_DATA_KEY).m_7981_((Object)this);
        return this.save(existingTag, rl);
    }

    public static ArrowData load(CompoundTag tag, RegistryAccess registryAccess) {
        if (!tag.m_128441_("arrow_data")) {
            return EMPTY;
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)tag.m_128461_("arrow_data"));
        return (ArrowData)registryAccess.m_175515_(ModRegistries.ARROW_DATA_KEY).m_7745_(rl);
    }

    public static void encode(FriendlyByteBuf buf, ArrowData data) {
        ArrowData.writeMaterial(buf, data.material);
        buf.writeDouble(data.baseDamage);
        buf.writeInt(data.color);
        buf.m_130070_(data.translationKey);
        buf.writeBoolean(data.flame);
        buf.writeDouble(data.gravity);
        buf.m_236831_(data.effects, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeInt);
    }

    public static ArrowData decode(FriendlyByteBuf buf) {
        return new ArrowData(ArrowData.readMaterial(buf), buf.readDouble(), buf.readInt(), buf.m_130277_(), buf.readBoolean(), buf.readDouble(), (Map<ResourceLocation, Integer>)buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readInt));
    }

    public static void writeMaterial(FriendlyByteBuf buf, Either<ResourceLocation, TagKey<Item>> material) {
        buf.writeBoolean(material.left().isPresent());
        material.ifLeft(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        material.ifRight(tag -> buf.m_130085_(tag.f_203868_()));
    }

    public static Either<ResourceLocation, TagKey<Item>> readMaterial(FriendlyByteBuf buf) {
        boolean isLeft = buf.readBoolean();
        if (isLeft) {
            return Either.left((Object)buf.m_130281_());
        }
        return Either.right((Object)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buf.m_130281_()));
    }
}

