/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.renderer;

import com.coolerpromc.arrowplus.entity.custom.ModArrowEntity;
import com.coolerpromc.arrowplus.entity.renderer.ModArrowRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArrowModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.joml.Quaternionfc;

public class ModArrowRenderer
extends ArrowRenderer<ModArrowEntity, ModArrowRenderState> {
    private final ArrowModel model;
    public final ResourceLocation arrowTexture;
    public static final ResourceLocation BODY_TEXTURE = ModArrowRenderer.getTextureLocation("arrow_plus");
    public static final ResourceLocation HEAD_TEXTURE = ModArrowRenderer.getTextureLocation("arrow_plus_head");

    public ModArrowRenderer(EntityRendererProvider.Context p_174399_, ResourceLocation arrowTexture) {
        super(p_174399_);
        this.arrowTexture = arrowTexture;
        this.model = new ArrowModel(p_174399_.bakeLayer(ModelLayers.ARROW));
    }

    protected ResourceLocation getTextureLocation(ModArrowRenderState p_364566_) {
        return BODY_TEXTURE;
    }

    public ModArrowRenderState createRenderState() {
        return new ModArrowRenderState();
    }

    public static ResourceLocation getTextureLocation(String textureName) {
        return ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)("textures/entity/projectiles/" + textureName + ".png"));
    }

    public void submit(ModArrowRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot));
        nodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, RenderType.entityCutout((ResourceLocation)this.getTextureLocation(renderState)), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, null, renderState.outlineColor, null);
        nodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, RenderType.entityCutout((ResourceLocation)HEAD_TEXTURE), renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.color, null, renderState.outlineColor, null);
        poseStack.popPose();
        super.submit((ArrowRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
    }

    public void extractRenderState(ModArrowEntity arrowEntity, ModArrowRenderState renderState, float p_360538_) {
        super.extractRenderState((AbstractArrow)arrowEntity, (ArrowRenderState)renderState, p_360538_);
        renderState.color = arrowEntity.getArrowData().color();
    }
}

