/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.JsonOps;
import com.mojang.util.UUIDTypeAdapter;
import dev.sisby.switchy.Switchy;
import dev.sisby.switchy.data.SwitchyComponentType;
import dev.sisby.switchy.data.SwitchyComponentTypes;
import dev.sisby.switchy.data.SwitchyPlayerData;
import dev.sisby.switchy.data.SwitchyProfile;
import dev.sisby.switchy.exception.NbtException;
import dev.sisby.switchy.exception.ProfileCurrentException;
import dev.sisby.switchy.exception.ProfileMissingException;
import dev.sisby.switchy.exception.ProfilePreciousException;
import dev.sisby.switchy.util.TypeRegistry;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SwitchyCommands {
    private static final Pattern COLOR_PATTERN = Pattern.compile("<(?:color:)?#([0-9a-fA-f]{6})>", 2);
    private static final Pattern BIO_PATTERN = Pattern.compile("<hover:'?([^<'>]+)'?>", 2);
    private static final Pattern BRACKETED_PATTERN = Pattern.compile("(\\([^()]+\\))", 2);
    private static final Map<String, String> COMMANDS = new TreeMap<String, String>(Map.of("/switchy", "switch profiles", "/switchy components", "configure components", "/switchy delete ", "delete a profile", "/switchy import ", "add profiles from PK.JSON", "/switchy export", "export profiles to PK.JSON", "/switchy update ", "update profiles from PK"));

    public static void greet(class_3244 handler, PacketSender sender, MinecraftServer server) {
        SwitchyPlayerData data = SwitchyPlayerData.ofEarly(handler.method_32311());
        if (data == null) {
            return;
        }
        handler.method_32311().method_43496(data.greet());
    }

    private static int list(String input, class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"you have ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(data.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" profiles available. ").method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyCommands.clickable("new", "/switchy switch ", false)));
        List<String> profiles = Stream.concat(Sets.difference(data.keySet(), Set.of(data.current())).stream().sorted(), Stream.of(data.current())).toList();
        for (String id : profiles) {
            SwitchyProfile profile;
            try {
                profile = data.getProfile(id, player);
            }
            catch (NbtException e) {
                throw new RuntimeException(e);
            }
            feedback.accept((class_2561)SwitchyCommands.indent().method_10852((class_2561)(profile.id().equals(data.current()) ? class_2561.method_43470((String)"current").method_27692(class_124.field_1080) : SwitchyCommands.clickable("switch", "/switchy switch %s".formatted(StringArgumentType.escapeIfRequired((String)profile.id())), true))).method_27693(" ").method_10852((class_2561)SwitchyCommands.clickable("view", "/switchy view %s".formatted(StringArgumentType.escapeIfRequired((String)profile.id())), true)).method_27693(" ").method_10852((class_2561)SwitchyCommands.clickable("edit", "/switchy edit %s ".formatted(StringArgumentType.escapeIfRequired((String)profile.id())), false)).method_27693(" ").method_10852((class_2561)SwitchyComponentTypes.NAME.asText(profile.getOrGetDefault(SwitchyComponentTypes.NAME, SwitchyProfile::id)).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2564.method_37112(profile.asTexts(player), (class_2561)class_2561.method_30163((String)"\n")))))));
        }
        return data.size();
    }

    private static int components(String input, class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You're switching ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(data.componentSet().size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" components and sharing ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(SwitchyComponentTypes.instance().keys().size() - data.componentSet().size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        SwitchyComponentTypes.grouped(SwitchyComponentTypes.instance().values()).forEach((id, types) -> {
            boolean enabled = data.componentSet().contains(types.get(0));
            feedback.accept((class_2561)SwitchyCommands.indent().method_10852((class_2561)(enabled ? SwitchyCommands.clickable("share", "/switchy components disable %s".formatted(id), false) : SwitchyCommands.clickable("switch", "/switchy components enable %s".formatted(id), true))).method_27693(" ").method_27693(id.method_12832()).method_10862(class_2583.field_24360.method_10977(enabled ? class_124.field_1068 : class_124.field_1080).method_10949(!enabled ? null : new class_2568(class_2568.class_5247.field_24342, (Object)class_2564.method_37112(data.values().stream().sorted(Comparator.comparing(SwitchyProfile::id)).filter(p -> types.stream().anyMatch(t -> p.get(t) != null && (t.emptyChecker() == null || t.isPrecious(p.components())))).map(p -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)p.id()).method_27692(class_124.field_1080)).method_27693(": ").method_10852(class_2564.method_37112(types.stream().filter(t -> p.get(t) != null).map(t -> t.asText(p.components())).toList(), (class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080)))).toList(), (class_2561)class_2561.method_30163((String)"\n"))))));
        });
        return data.componentSet().size();
    }

    private static int help(String input, class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Switchy provides ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(COMMANDS.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" top-level commands:").method_27692(class_124.field_1080)));
        for (String command : COMMANDS.keySet()) {
            String description = COMMANDS.get(command);
            feedback.accept((class_2561)SwitchyCommands.indent().method_10852((class_2561)SwitchyCommands.clickable(command.trim(), command, !command.endsWith(" "), class_124.field_1075, "", "")).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)description).method_27692(class_124.field_1068)));
        }
        feedback.accept((class_2561)SwitchyCommands.indent().method_10852((class_2561)class_2561.method_43470((String)"(").method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyCommands.clickable("aqua text", "a preview of the command appears here!", false, class_124.field_1075, "", "")).method_10852((class_2561)class_2561.method_43470((String)" in command feedback is clickable)").method_27692(class_124.field_1080)));
        return 1;
    }

    private static int importProfiles(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, String url, boolean allowNew) {
        PlayerImportData importData;
        int beforeSize = data.size();
        try {
            importData = (PlayerImportData)new Gson().fromJson((Reader)new InputStreamReader(new URL(url).openStream()), PlayerImportData.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Function<Integer, class_2561> feedbackGetter = updated -> SwitchyCommands.prefix().method_10852((class_2561)(allowNew ? class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"imported ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(data.size() - beforeSize)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" new and ").method_27692(class_124.field_1080)) : class_2561.method_43473())).method_10852((class_2561)class_2561.method_43470((String)"updated ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(updated - (data.size() - beforeSize))).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" existing profiles. ").method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true));
        try {
            int updated2 = data.importProfiles(importData.members(), player, importData.name(), allowNew, feedbackGetter);
            feedback.accept(feedbackGetter.apply(updated2));
            return data.size() - beforeSize;
        }
        catch (Exception e) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_27693("Error while switching: ").method_27692(class_124.field_1061).method_27693(Objects.requireNonNullElse(e.getMessage(), "???")).method_27692(class_124.field_1080).method_27693(" See server logs for more info.").method_27692(class_124.field_1061));
            Switchy.LOGGER.error("[Switchy] Error while switching to {} for player {}", new Object[]{data.current(), player.method_7334().getName(), e});
            return 0;
        }
    }

    private static int export(String input, class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback) {
        String sysName = null;
        ArrayList<SwitchyPlayerData.ProfileImportData> members = new ArrayList<SwitchyPlayerData.ProfileImportData>();
        try {
            for (String profileId : data.keySet()) {
                Object group;
                SwitchyProfile profile = data.getProfile(profileId, player);
                HashMap<String, JsonElement> components = new HashMap<String, JsonElement>();
                for (SwitchyComponentType<?> type : profile.components().keySet()) {
                    if (!type.importable()) continue;
                    type.encode(JsonOps.INSTANCE, profile.components()).ifPresent(e -> components.put(type.id().toString(), (JsonElement)e));
                }
                String name = profile.get(SwitchyComponentTypes.NAME);
                String color = null;
                String description = null;
                String pronouns = null;
                StringBuilder bracketed = new StringBuilder(" ");
                if (name != null) {
                    List<String> splitBio;
                    Matcher colorMatcher = COLOR_PATTERN.matcher(name);
                    if (colorMatcher.find()) {
                        color = colorMatcher.group(1);
                    }
                    String bio = "";
                    Matcher bioMatcher = BIO_PATTERN.matcher(name);
                    if (bioMatcher.find()) {
                        bio = bioMatcher.group(1);
                    }
                    if ((splitBio = Arrays.stream(bio.split(" \\| ")).toList()).size() > 1) {
                        String remainder = splitBio.get(0);
                        Matcher bracketedMatcher = BRACKETED_PATTERN.matcher(splitBio.get(0));
                        while (bracketedMatcher.find()) {
                            group = bracketedMatcher.group(1);
                            remainder = remainder.replace((CharSequence)group, "").trim();
                            bracketed.append((String)group);
                        }
                        if (!remainder.isEmpty()) {
                            pronouns = remainder;
                        }
                        if (!player.method_7334().getName().equals(splitBio.get(1))) {
                            sysName = splitBio.get(1);
                        }
                    }
                    if (splitBio.size() > 2) {
                        description = splitBio.get(2);
                    }
                    name = (SwitchyComponentTypes.NAME.asText(name).getString() + String.valueOf(bracketed)).trim();
                }
                String avatarUrl = null;
                if (Switchy.CONFIG.exportAvatarUrl.contains("%s")) {
                    class_2487 skinCompound;
                    String key = player.method_7334().getName();
                    MinecraftProfileTexture skin = player.method_5682().method_3844().getTextures(player.method_7334()).skin();
                    SwitchyComponentType skinComponent = (SwitchyComponentType)SwitchyComponentTypes.instance().get(SwitchyComponentTypes.TAILOR_SKIN);
                    if (skinComponent != null && profile.contains(skinComponent) && (group = profile.get(skinComponent)) instanceof class_2487 && (group = (skinCompound = (class_2487)group).method_10580("value")) instanceof class_2519) {
                        class_2519 valueString = (class_2519)group;
                        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
                        MinecraftTexturesPayload payload = (MinecraftTexturesPayload)gson.fromJson(new String(Base64.getDecoder().decode(valueString.method_10714())), MinecraftTexturesPayload.class);
                        MinecraftProfileTexture minecraftProfileTexture = skin = payload.textures().get(MinecraftProfileTexture.Type.SKIN) != null ? (MinecraftProfileTexture)payload.textures().get(MinecraftProfileTexture.Type.SKIN) : skin;
                    }
                    if (skin != null) {
                        key = skin.getHash();
                    }
                    avatarUrl = Switchy.CONFIG.exportAvatarUrl.formatted(key);
                }
                members.add(new SwitchyPlayerData.ProfileImportData(profileId, name, color, pronouns, description, avatarUrl, List.of(new SwitchyPlayerData.ProxyTag(profileId + ":", null)), components));
            }
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Exported ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(data.size())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" profiles. ").method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyCommands.clickable("copy", SwitchyComponentTypes.GSON.toJson((Object)new PlayerImportData(sysName, members)), class_2558.class_2559.field_21462, class_124.field_1075, "<", ">")));
        }
        catch (NbtException e2) {
            throw new RuntimeException(e2);
        }
        return data.size();
    }

    private static int viewProfile(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, String profileId) {
        SwitchyProfile profile;
        try {
            profile = data.getProfile(profileId, player);
        }
        catch (NbtException e) {
            throw new RuntimeException(e);
        }
        if (profile == null) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"profile doesn't exist!").method_27692(class_124.field_1054)));
            return 0;
        }
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"profile ").method_27692(class_124.field_1080)).method_27693(profileId).method_10852((class_2561)class_2561.method_43470((String)" contains ").method_27692(class_124.field_1080)).method_27693("%d".formatted(profile.components().size())).method_10852((class_2561)class_2561.method_43470((String)" components. ").method_27692(class_124.field_1080)).method_10852((class_2561)(profileId.equals(data.current()) ? class_2561.method_43473() : SwitchyCommands.clickable("switch", "/switchy switch %s".formatted(StringArgumentType.escapeIfRequired((String)profileId)), true))));
        profile.components().asTexts().forEach(componentText -> feedback.accept((class_2561)SwitchyCommands.indent().method_10852((class_2561)componentText)));
        return profile.components().size();
    }

    private static int switchProfile(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, String profileId) {
        try {
            SwitchyProfile currentProfile = data.getCurrentProfile(player);
            SwitchyProfile nextProfile = data.getOrCreateProfile(profileId, player);
            data.switchOrCreateProfile(profileId, player, (class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Switched from ").method_27692(class_124.field_1060)).method_10852((class_2561)SwitchyComponentTypes.NAME.asText(currentProfile.getOrGetDefault(SwitchyComponentTypes.NAME, SwitchyProfile::id))).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1060)).method_10852((class_2561)SwitchyComponentTypes.NAME.asText(nextProfile.getOrGetDefault(SwitchyComponentTypes.NAME, SwitchyProfile::id))).method_10852((class_2561)class_2561.method_43470((String)"! ").method_27692(class_124.field_1060)).method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true)));
        }
        catch (Exception e) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_27693("Error while switching: ").method_27692(class_124.field_1061).method_27693(Objects.requireNonNullElse(e.getMessage(), "???")).method_27692(class_124.field_1080).method_27693(" See server logs for more info.").method_27692(class_124.field_1061));
            Switchy.LOGGER.error("[Switchy] Error while switching to {} for player {}", new Object[]{profileId, player.method_7334().getName(), e});
            return 0;
        }
        return 1;
    }

    private static int switchNextProfile(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback) {
        return SwitchyCommands.switchProfile(player, data, feedback, data.profileAfter(data.current()));
    }

    private static int switchRandomProfile(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback) {
        return SwitchyCommands.switchProfile(player, data, feedback, data.randomBesides(data.current(), player.method_59922()));
    }

    public static <T> int editComponent(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, String profileId, SwitchyComponentType<T> type, T value) {
        SwitchyProfile profile;
        if (!data.componentSet().contains(type)) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"can't edit a shared component!").method_27692(class_124.field_1054)));
            return 0;
        }
        try {
            profile = data.getProfile(profileId, player);
        }
        catch (NbtException e) {
            throw new RuntimeException(e);
        }
        T oldValue = profile.set(type, value);
        class_5250 feedbackText = SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"edited ").method_27692(class_124.field_1060)).method_27693(profileId).method_10852((class_2561)class_2561.method_43470((String)":").method_27692(class_124.field_1080)).method_27693(type.id().method_12832()).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1060)).method_10852((class_2561)(oldValue == null ? class_2561.method_30163((String)"empty") : type.asText(oldValue))).method_10852((class_2561)class_2561.method_43470((String)" \ud83e\udc46 ").method_27692(class_124.field_1060)).method_10852((class_2561)type.asText(value)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1060)).method_27693(" ").method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true));
        if (profileId.equals(data.current())) {
            try {
                data.selfSwitch(profile, player, (class_2561)feedbackText);
                return 2;
            }
            catch (Exception e) {
                feedback.accept((class_2561)SwitchyCommands.prefix().method_27693("Error while self-switching: ").method_27692(class_124.field_1061).method_27693(Objects.requireNonNullElse(e.getMessage(), "???")).method_27692(class_124.field_1080).method_27693(" See server logs for more info.").method_27692(class_124.field_1061));
                Switchy.LOGGER.error("[Switchy] Error while switching to {} for player {}", new Object[]{profileId, player.method_7334().getName(), e});
                return 0;
            }
        }
        feedback.accept((class_2561)feedbackText);
        return 1;
    }

    private static int renameProfile(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, String profileId, String newId) {
        try {
            data.renameProfile(profileId, newId);
        }
        catch (IllegalArgumentException e) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1054)));
            return 0;
        }
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"renamed ").method_27692(class_124.field_1060)).method_27693(profileId).method_10852((class_2561)class_2561.method_43470((String)" \ud83e\udc46 ").method_27692(class_124.field_1060)).method_27693(newId).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1060)).method_27693(" ").method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true)));
        return 1;
    }

    private static int deleteProfile(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, String profileId) {
        try {
            SwitchyProfile profile = data.deleteProfile(profileId);
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"profile ").method_27692(class_124.field_1060)).method_27693(profileId).method_10852((class_2561)class_2561.method_43470((String)" deleted successfully!").method_27692(class_124.field_1060)).method_27693(" ").method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true)));
            return profile.components().size();
        }
        catch (ProfileCurrentException e) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"can't delete current profile!").method_27692(class_124.field_1054)));
            return 0;
        }
        catch (ProfilePreciousException e) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"profile ").method_27692(class_124.field_1054)).method_27693(profileId).method_10852((class_2561)class_2561.method_43470((String)" contains ").method_27692(class_124.field_1054)).method_27693(String.valueOf(e.getPreciousComponents().size())).method_10852((class_2561)class_2561.method_43470((String)"x precious components!").method_27692(class_124.field_1054)));
            e.getPreciousComponents().asTexts().forEach(componentText -> feedback.accept((class_2561)SwitchyCommands.indent().method_10852((class_2561)componentText)));
            return 0;
        }
    }

    private static int enableComponent(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, class_2960 id) {
        Set<SwitchyComponentType<?>> types = SwitchyComponentTypes.instance().values().stream().filter(t -> id.equals((Object)t.group())).collect(Collectors.toSet());
        if (types.isEmpty() && SwitchyComponentTypes.instance().contains(id) && ((SwitchyComponentType)SwitchyComponentTypes.instance().get(id)).group() == null) {
            types.add((SwitchyComponentType)SwitchyComponentTypes.instance().get(id));
        }
        if (types.isEmpty()) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"component doesn't exist!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (types.stream().anyMatch(t -> data.componentSet().contains(t))) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"component is already enabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        int changed = data.initComponents(types, player);
        if (changed == 0) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"component failed to initialize! see logs for more info").method_27692(class_124.field_1061)));
            return 0;
        }
        SwitchyCommands.components("", player, data, feedback);
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)id.method_12832())).method_10852((class_2561)class_2561.method_43470((String)" will now be switched between profiles. ").method_27692(class_124.field_1060)).method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true)));
        return changed;
    }

    private static int disableComponent(class_3222 player, SwitchyPlayerData data, Consumer<class_2561> feedback, class_2960 id) {
        Set<SwitchyComponentType<?>> types = SwitchyComponentTypes.instance().values().stream().filter(t -> id.equals((Object)t.group())).collect(Collectors.toSet());
        if (types.isEmpty() && SwitchyComponentTypes.instance().contains(id) && ((SwitchyComponentType)SwitchyComponentTypes.instance().get(id)).group() == null) {
            types.add((SwitchyComponentType)SwitchyComponentTypes.instance().get(id));
        }
        if (types.isEmpty()) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"component doesn't exist!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (types.stream().anyMatch(t -> !data.componentSet().contains(t))) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"component is already disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        int changed = data.removeComponents(types);
        if (changed == 0) {
            feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"component is precious! empty it first.").method_27692(class_124.field_1054)));
            return 0;
        }
        SwitchyCommands.components("", player, data, feedback);
        feedback.accept((class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)id.method_12832())).method_10852((class_2561)class_2561.method_43470((String)" will now be shared between profiles. ").method_27692(class_124.field_1060)).method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true)));
        return changed;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registries, class_2170.class_5364 environment) {
        RequiredArgumentBuilder<class_2168, String> editBuilder = SwitchyCommands.profile(true);
        for (SwitchyComponentType type : SwitchyComponentTypes.getStatic().values()) {
            type.tryCreateEditor(arg -> editBuilder.then(class_2170.method_9247((String)type.id().toString().replace("switchy:", "")).then(arg)));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"switchy").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"switch").then(SwitchyCommands.profile(false).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.switchProfile(p, d, f, ((String)c.getArgument("profile", String.class)).toLowerCase()))))).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.switchNextProfile(p, d, f))))).then(class_2170.method_9247((String)"switch?").executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.switchRandomProfile(p, d, f))))).then(class_2170.method_9247((String)"view").then(SwitchyCommands.profile(true).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.viewProfile(p, d, f, ((String)c.getArgument("profile", String.class)).toLowerCase())))))).then(class_2170.method_9247((String)"delete").then(SwitchyCommands.profile(false).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.deleteProfile(p, d, f, ((String)c.getArgument("profile", String.class)).toLowerCase())))))).then(class_2170.method_9247((String)"edit").then(editBuilder.then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.renameProfile(p, d, f, ((String)c.getArgument("profile", String.class)).toLowerCase(), ((String)c.getArgument("id", String.class)).toLowerCase())))))))).then(class_2170.method_9247((String)"import").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.importProfiles(p, d, f, (String)c.getArgument("url", String.class), true)))))).then(class_2170.method_9247((String)"update").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.importProfiles(p, d, f, (String)c.getArgument("url", String.class), false)))))).then(class_2170.method_9247((String)"export").executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, SwitchyCommands::export)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"components").then(class_2170.method_9247((String)"disable").then(SwitchyCommands.groupedComponent(true).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.disableComponent(p, d, f, (class_2960)c.getArgument("component", class_2960.class))))))).then(class_2170.method_9247((String)"enable").then(SwitchyCommands.groupedComponent(false).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.enableComponent(p, d, f, (class_2960)c.getArgument("component", class_2960.class))))))).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, SwitchyCommands::components)))).then(class_2170.method_9247((String)"help").executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, SwitchyCommands::help)))).executes(c -> SwitchyCommands.execute((CommandContext<class_2168>)c, SwitchyCommands::list)));
    }

    private static RequiredArgumentBuilder<class_2168, String> profile(boolean includeCurrent) {
        return class_2170.method_9244((String)"profile", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9265((Iterable)SwitchyCommands.map((CommandContext<class_2168>)c, (i, p, d, f) -> (includeCurrent ? d.keySet() : Sets.difference(d.keySet(), Set.of(d.current()))).stream().map(StringArgumentType::escapeIfRequired).toList(), false), (SuggestionsBuilder)b));
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> groupedComponent(Boolean enabled) {
        return class_2170.method_9244((String)"component", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270((Iterable)SwitchyCommands.map((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyComponentTypes.instance().values().stream().filter(t -> enabled == null || enabled == false ^ d.componentSet().contains(t)).map(t -> Objects.requireNonNullElse(t.group(), t.id())).distinct().toList(), false), (SuggestionsBuilder)b));
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> component(Boolean enabled) {
        return class_2170.method_9244((String)"component", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270((Iterable)SwitchyCommands.map((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyComponentTypes.instance().values().stream().filter(t -> enabled == null || enabled == false ^ d.componentSet().contains(t)).map(TypeRegistry.Type::id).toList(), false), (SuggestionsBuilder)b));
    }

    public static class_5250 prefix() {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[Switchy] ").method_27692(class_124.field_1064));
    }

    public static class_5250 indent() {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"|| ").method_27692(class_124.field_1064));
    }

    public static class_5250 clickable(String name, String contents, class_2558.class_2559 action, class_124 formatting, String prefix, String suffix) {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)prefix).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)name).method_10862(class_2583.field_24360.method_27706(formatting).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(contents + (action == class_2558.class_2559.field_11745 ? "..." : ""))).method_27692(formatting))).method_10958(new class_2558(action, contents)))).method_10852((class_2561)class_2561.method_43470((String)suffix).method_27692(class_124.field_1080));
    }

    public static class_5250 clickable(String name, String contents, boolean instant, class_124 formatting, String prefix, String suffix) {
        return SwitchyCommands.clickable(name, contents, instant ? class_2558.class_2559.field_11750 : class_2558.class_2559.field_11745, formatting, prefix, suffix);
    }

    public static class_5250 clickable(String name, String command, boolean instant) {
        return SwitchyCommands.clickable(name, command, instant, class_124.field_1075, "<", ">");
    }

    public static <T> T map(CommandContext<class_2168> context, SurveyorCommandExecutor<T> executor, boolean feedback) {
        class_3222 player;
        try {
            player = ((class_2168)context.getSource()).method_9207();
        }
        catch (CommandSyntaxException e) {
            if (feedback) {
                Switchy.LOGGER.error("[Switchy] Commands cannot be invoked by a non-player");
            }
            return null;
        }
        SwitchyPlayerData data = SwitchyPlayerData.of(player);
        try {
            return executor.execute(context.getInput(), player, data, t -> ((class_2168)context.getSource()).method_9226(() -> t, false));
        }
        catch (ProfileMissingException e) {
            ((class_2168)context.getSource()).method_9226(() -> SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"profile doesn't exist!").method_27692(class_124.field_1054)), false);
            return null;
        }
        catch (Exception e) {
            if (feedback) {
                ((class_2168)context.getSource()).method_9226(() -> SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Command \"/%s...\" failed! Check log for details.".formatted(context.getInput().substring(0, Math.min(context.getInput().length(), 20)))).method_27692(class_124.field_1061)), false);
            }
            if (feedback) {
                Switchy.LOGGER.error("[Switchy] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            }
            return null;
        }
    }

    public static int execute(CommandContext<class_2168> context, SurveyorCommandExecutor<Integer> executor) {
        return Objects.requireNonNullElse(SwitchyCommands.map(context, executor, true), 0);
    }

    public record PlayerImportData(@Nullable String name, List<SwitchyPlayerData.ProfileImportData> members) {
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(String var1, class_3222 var2, SwitchyPlayerData var3, Consumer<class_2561> var4);
    }
}

