/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.sisby.switchy.Switchy;
import dev.sisby.switchy.data.SwitchyComponentType;
import dev.sisby.switchy.data.SwitchyComponentTypes;
import dev.sisby.switchy.util.FormatUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_124;
import net.minecraft.class_2203;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class ComponentTypeLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String PATH = "switchy_components";
    public static final Gson GSON = new Gson();

    public ComponentTypeLoader() {
        super(GSON, PATH);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        SwitchyComponentTypes types = new SwitchyComponentTypes();
        for (class_2960 id : SwitchyComponentTypes.getStatic().keys()) {
            types.register(id, i -> (SwitchyComponentType)SwitchyComponentTypes.getStatic().get(id));
        }
        for (class_2960 id : prepared.keySet()) {
            EditableComponentType type = (EditableComponentType)GSON.fromJson(prepared.get(id), EditableComponentType.class);
            if (!type.enabled()) continue;
            Codec<?> codec = SwitchyComponentTypes.CODECS.get(type.codec != null && SwitchyComponentTypes.CODECS.containsKey(class_2960.method_12829((String)type.codec)) ? class_2960.method_12829((String)type.codec) : class_2960.method_12829((String)"nbt"));
            ComponentTypeLoader.registerDataType(types, codec, id, type);
        }
        SwitchyComponentTypes.setInstance(types);
        Switchy.LOGGER.info("[Switchy] Initialized {} component types: {}", (Object)types.keys().size(), types.keys().stream().sorted().toList());
    }

    public static <T> void registerDataType(SwitchyComponentTypes types, Codec<T> codec, class_2960 id, EditableComponentType type) {
        SwitchyComponentType.Initializer<Object> initializer;
        SwitchyComponentType.EmptyChecker<Object> checker;
        SwitchyComponentType.TextProvider<Object> provider = type.preview == null ? null : SwitchyComponentTypes.TEXT_PROVIDERS.get(class_2960.method_12829((String)type.preview));
        SwitchyComponentType.ArgumentEditor<?> editor = type.editor == null ? null : SwitchyComponentTypes.ARGUMENT_EDITORS.get(class_2960.method_12829((String)type.editor));
        SwitchyComponentType.EmptyChecker<?> emptyChecker = checker = type.emptyChecker == null ? null : SwitchyComponentTypes.EMPTY_CHECKERS.get(class_2960.method_12829((String)type.emptyChecker));
        if (type.defaultValue == null) {
            initializer = (nbt, player, pId) -> null;
        } else if (type.defaultValue.toString().equals("\"$copy\"")) {
            initializer = null;
        } else if (type.defaultValue.isJsonPrimitive() && type.defaultValue.getAsJsonPrimitive().isString() && type.defaultValue.getAsJsonPrimitive().getAsString().startsWith("$")) {
            initializer = SwitchyComponentTypes.INITIALIZERS.get(class_2960.method_12829((String)type.defaultValue.getAsString().substring(1)));
        } else {
            Object defaultValue = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)type.defaultValue).getOrThrow();
            initializer = (nbt, player, pId) -> defaultValue;
        }
        try {
            int finalDecompositions;
            int decompositions;
            String nbtPath;
            if (provider == null) {
                if (type.preview != null && type.preview.startsWith("$")) {
                    nbtPath = type.preview.substring(1);
                    decompositions = 0;
                    while (nbtPath.startsWith("*")) {
                        nbtPath = nbtPath.substring(1);
                        ++decompositions;
                    }
                    class_2203.class_2209 previewPath = class_2203.method_9360().method_9362(new StringReader(nbtPath));
                    finalDecompositions = decompositions;
                    provider = v -> {
                        try {
                            class_2520 element = (class_2520)v;
                            for (int decomposed = 0; decomposed < finalDecompositions; ++decomposed) {
                                element = FormatUtils.decompose(element);
                            }
                            return FormatUtils.nbtPathResultText(previewPath.method_9366(element), true);
                        }
                        catch (CommandSyntaxException e) {
                            return FormatUtils.nbtPathResultText(List.of(), true);
                        }
                    };
                } else {
                    provider = v -> class_2561.method_43470((String)Objects.toString(v));
                }
            }
            if (checker == null && type.emptyChecker != null && type.emptyChecker.startsWith("$")) {
                nbtPath = type.emptyChecker.substring(1);
                decompositions = 0;
                while (nbtPath.startsWith("*")) {
                    nbtPath = nbtPath.substring(1);
                    ++decompositions;
                }
                class_2203.class_2209 checkerPath = class_2203.method_9360().method_9362(new StringReader(nbtPath));
                finalDecompositions = decompositions;
                checker = v -> {
                    try {
                        class_2520 element = (class_2520)v;
                        for (int decomposed = 0; decomposed < finalDecompositions; ++decomposed) {
                            element = FormatUtils.decompose(element);
                        }
                        return checkerPath.method_9366(element).stream().allMatch(FormatUtils::isEmpty);
                    }
                    catch (CommandSyntaxException e) {
                        return true;
                    }
                };
            }
            SwitchyComponentType.TextProvider<?> finalProvider = provider;
            SwitchyComponentType.TextProvider<Object> prefixedPreviewer = v -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)Objects.requireNonNullElse(type.prefix, "")).method_27692(class_124.field_1080)).method_10852(finalProvider.toText(v));
            class_2203.class_2209 path = class_2203.method_9360().method_9362(new StringReader(type.path));
            SwitchyComponentType.EmptyChecker<?> finalChecker = checker;
            types.register(id, codec, b -> b.nbtSwitcher(path).textProvider(prefixedPreviewer).argumentEditor(editor).emptyChecker(finalChecker).group(type.group == null ? null : class_2960.method_12829((String)type.group)).hidden(type.hidden != null && type.hidden != false).importable(type.importable != null && type.importable != false).previewPriority(type.priority == null ? 0 : type.priority).initializer(initializer));
        }
        catch (CommandSyntaxException e) {
            Switchy.LOGGER.error("[Switchy] Failed to register component type {} due to a malformed NBT path", (Object)id);
        }
    }

    public class_2960 getFabricId() {
        return Switchy.id(PATH);
    }

    public record EditableComponentType(boolean enabled, String codec, String path, String preview, String prefix, String editor, String emptyChecker, String group, @SerializedName(value="default") JsonElement defaultValue, Boolean hidden, Boolean importable, Integer priority) {
    }
}

