/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import dev.sisby.switchy.Switchy;
import dev.sisby.switchy.compat.StyledNicknamesCompat;
import dev.sisby.switchy.data.SwitchyComponentType;
import dev.sisby.switchy.util.DispatchMapCodec;
import dev.sisby.switchy.util.FormatUtils;
import dev.sisby.switchy.util.SwitchyCodecs;
import dev.sisby.switchy.util.TypeRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public class SwitchyComponentTypes
extends TypeRegistry<SwitchyComponentType<?>> {
    private static SwitchyComponentTypes INSTANCE = null;
    private static final SwitchyComponentTypes STATIC = new SwitchyComponentTypes();
    public final Codec<Set<SwitchyComponentType<?>>> SET_CODEC = Codec.list(this.codec()).xmap(LinkedHashSet::new, ArrayList::new);
    public final Codec<Map<SwitchyComponentType<?>, Object>> TYPE_TO_VALUE_MAP_CODEC = DispatchMapCodec.of(this.codec(), t -> t.codec());
    public static final Map<class_2960, Codec<?>> CODECS = new HashMap<class_2960, Codec<class_2371<class_1799>>>(Map.of(class_2960.method_60655((String)"minecraft", (String)"nbt"), SwitchyCodecs.NBT, class_2960.method_60655((String)"minecraft", (String)"boolean"), Codec.BOOL, class_2960.method_60655((String)"minecraft", (String)"string"), Codec.STRING, class_2960.method_60655((String)"minecraft", (String)"text"), class_8824.field_46597, class_2960.method_60655((String)"minecraft", (String)"float"), Codec.FLOAT, class_2960.method_60655((String)"minecraft", (String)"int"), Codec.INT, class_2960.method_60655((String)"minecraft", (String)"vec3d"), class_243.field_38277, class_2960.method_60655((String)"minecraft", (String)"identifier"), class_2960.field_25139, class_2960.method_60655((String)"minecraft", (String)"inventory"), SwitchyCodecs.INVENTORY_CODEC));
    public static final Map<class_2960, SwitchyComponentType.TextProvider<?>> TEXT_PROVIDERS = new HashMap<class_2960, SwitchyComponentType.SimpleTextProvider<class_2371>>(Map.of(class_2960.method_60655((String)"minecraft", (String)"trunc"), new SwitchyComponentType.SimpleTextProvider<Object>(o -> Objects.toString(o).length() <= 10 ? class_2561.method_30163((String)Objects.toString(o)) : class_2561.method_43470((String)(Objects.toString(o).substring(0, 10) + "...")).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)Objects.toString(o)))))), class_2960.method_60655((String)"minecraft", (String)"nbt"), new SwitchyComponentType.SimpleTextProvider<class_2520>(e -> FormatUtils.nbtPathResultText(List.of(e), true)), class_2960.method_60655((String)"minecraft", (String)"text"), new SwitchyComponentType.SimpleTextProvider<class_2561>(t -> t), class_2960.method_60655((String)"minecraft", (String)"percent"), new SwitchyComponentType.SimpleTextProvider<Float>(n -> class_2561.method_30163((String)"%.0f%%".formatted((double)n.floatValue() * 100.0))), class_2960.method_60655((String)"minecraft", (String)"rounded"), new SwitchyComponentType.SimpleTextProvider<Float>(n -> class_2561.method_30163((String)"%.0f".formatted(n))), class_2960.method_60655((String)"minecraft", (String)"halves"), new SwitchyComponentType.SimpleTextProvider<Float>(FormatUtils::statText), class_2960.method_60655((String)"minecraft", (String)"vec3d"), new SwitchyComponentType.SimpleTextProvider<class_243>(c -> class_2564.method_37112(List.of(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"X:").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(class_2338.method_49638((class_2374)c).method_10263()))), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Y:").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(class_2338.method_49638((class_2374)c).method_10264()))), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Z:").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(class_2338.method_49638((class_2374)c).method_10260())))), (class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080))), class_2960.method_60655((String)"minecraft", (String)"identifier"), new SwitchyComponentType.SimpleTextProvider<class_2960>(i -> class_2561.method_30163((String)FormatUtils.prettify(i.method_12832()))), class_2960.method_60655((String)"minecraft", (String)"inventory"), new SwitchyComponentType.SimpleTextProvider<class_2371>(FormatUtils::inventoryText)));
    public static final Map<class_2960, SwitchyComponentType.ArgumentEditor<?>> ARGUMENT_EDITORS = new HashMap(Map.of(class_2960.method_60655((String)"minecraft", (String)"text"), new SwitchyComponentType.SimpleArgumentEditor(e -> class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> e.execute((CommandContext<class_2168>)c, class_2561.method_30163((String)((String)c.getArgument("name", String.class))))))));
    public static final Map<class_2960, SwitchyComponentType.EmptyChecker<?>> EMPTY_CHECKERS = new HashMap<class_2960, SwitchyComponentType.SimpleEmptyChecker<class_2371>>(Map.of(class_2960.method_60655((String)"minecraft", (String)"inventory"), new SwitchyComponentType.SimpleEmptyChecker<class_2371>(dl -> dl.stream().allMatch(class_1799::method_7960))));
    public static final Map<class_2960, SwitchyComponentType.Initializer<?>> INITIALIZERS = new HashMap<class_2960, SwitchyComponentType.Initializer<Object>>(Map.of(class_2960.method_60655((String)"minecraft", (String)"spawn_pos"), (nbt, player, id) -> player.method_5682().method_30002().method_43126().method_46558()));
    public static final class_2960 NAME_ID = Switchy.id("name");
    public static final class_2960 DIMENSION = class_2960.method_60655((String)"minecraft", (String)"location/dimension");
    public static final class_2960 POS = class_2960.method_60655((String)"minecraft", (String)"location/pos");
    public static final class_2960 YAW = class_2960.method_60655((String)"minecraft", (String)"location/yaw");
    public static final class_2960 PITCH = class_2960.method_60655((String)"minecraft", (String)"location/pitch");
    public static final class_2960 SPAWN_X = class_2960.method_60655((String)"minecraft", (String)"spawn/x");
    public static final class_2960 SPAWN_Y = class_2960.method_60655((String)"minecraft", (String)"spawn/y");
    public static final class_2960 SPAWN_Z = class_2960.method_60655((String)"minecraft", (String)"spawn/z");
    public static final class_2960 SPAWN_FORCED = class_2960.method_60655((String)"minecraft", (String)"spawn/forced");
    public static final class_2960 SPAWN_ANGLE = class_2960.method_60655((String)"minecraft", (String)"spawn/angle");
    public static final class_2960 SPAWN_DIMENSION = class_2960.method_60655((String)"minecraft", (String)"spawn/dimension");
    public static final class_2960 EFFECTS = class_2960.method_60655((String)"minecraft", (String)"effects");
    public static final class_2960 HEALTH = class_2960.method_60655((String)"minecraft", (String)"health");
    public static final class_2960 FOOD = class_2960.method_60655((String)"minecraft", (String)"hunger/food");
    public static final class_2960 SATURATION = class_2960.method_60655((String)"minecraft", (String)"hunger/saturation");
    public static final class_2960 EXHAUSTION = class_2960.method_60655((String)"minecraft", (String)"hunger/exhaustion");
    public static final class_2960 XP = class_2960.method_60655((String)"minecraft", (String)"xp/progress");
    public static final class_2960 LEVEL = class_2960.method_60655((String)"minecraft", (String)"xp/level");
    public static final class_2960 INVENTORY = class_2960.method_60655((String)"minecraft", (String)"inventory/inventory");
    public static final class_2960 ENDER_CHEST = class_2960.method_60655((String)"minecraft", (String)"inventory/ender_chest");
    public static final class_2960 ORIGINS_ORIGIN = class_2960.method_60655((String)"origins", (String)"origin");
    public static final class_2960 ORIGINS_POWERS = class_2960.method_60655((String)"origins", (String)"powers");
    public static final class_2960 TAILOR_SKIN = class_2960.method_60655((String)"fabrictailor", (String)"skin");
    public static final class_2960 TRINKETS_SLOTS = class_2960.method_60655((String)"trinkets", (String)"slots");
    public static final SwitchyComponentType<String> NAME = SwitchyComponentTypes.registerStatic(NAME_ID, Codec.STRING, builder -> {
        builder = builder.importable(true).textProvider(s -> s != null ? class_2561.method_43470((String)s) : class_2561.method_43473()).textProvider(s -> class_2561.method_43470((String)s.replaceAll("<[^>]*>", "")).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)s))))).argumentEditor(e -> class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> e.execute((CommandContext<class_2168>)c, (String)c.getArgument("name", String.class))));
        return FabricLoader.getInstance().isModLoaded("styled-nicknames") ? StyledNicknamesCompat.nicknameComponent(builder) : builder;
    });
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Map<class_2960, List<SwitchyComponentType<?>>> grouped(Set<SwitchyComponentType<?>> keyset) {
        Comparator<class_2960> prioritizedIdComparator = Comparator.comparing(id -> !id.method_12836().equals("switchy")).thenComparing(id -> !id.method_12836().equals("minecraft")).thenComparing(id -> id);
        TreeMap grouped = new TreeMap(prioritizedIdComparator);
        Comparator<SwitchyComponentType> comparator = Comparator.comparing(SwitchyComponentType::previewPriority, Comparator.reverseOrder()).thenComparing(t -> Objects.requireNonNullElse(t.group(), t.id()), prioritizedIdComparator);
        for (SwitchyComponentType t2 : keyset.stream().sorted(comparator).toList()) {
            class_2960 group = t2.group();
            grouped.computeIfAbsent(group != null ? group : t2.id(), k -> new ArrayList()).add(t2);
        }
        return grouped;
    }

    public static <T> SwitchyComponentType<T> registerStatic(class_2960 id, Codec<T> codec, UnaryOperator<SwitchyComponentType.Builder<T>> operations) {
        return STATIC.register(id, i -> ((SwitchyComponentType.Builder)operations.apply(SwitchyComponentType.builder(i, codec))).build());
    }

    public static void setInstance(SwitchyComponentTypes types) {
        INSTANCE = types;
    }

    public <T> SwitchyComponentType<T> register(class_2960 id, Codec<T> codec, UnaryOperator<SwitchyComponentType.Builder<T>> operations) {
        return this.register(id, i -> ((SwitchyComponentType.Builder)operations.apply(SwitchyComponentType.builder(i, codec))).build());
    }

    @Nullable
    public static SwitchyComponentTypes instance() {
        return INSTANCE;
    }

    public static SwitchyComponentTypes getStatic() {
        return STATIC;
    }
}

