/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public interface SwitchyCodecs {
    public static final PrimitiveCodec<Byte> BYTE = new PrimitiveCodec<Byte>(){

        public <T> DataResult<Byte> read(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::byteValue);
        }

        public <T> T write(DynamicOps<T> ops, Byte value) {
            return (T)ops.createByte(value.byteValue());
        }
    };
    public static final Codec<class_2520> NBT = Codec.PASSTHROUGH.comapFlatMap(dynamic -> DataResult.success((Object)((class_2520)dynamic.convert((DynamicOps)class_2509.field_11560).getValue())), nbt -> new Dynamic((DynamicOps)class_2509.field_11560, nbt));
    public static final MapCodec<class_1799> ITEM_STACK_MAP_CODEC = MapCodec.recursive((String)"ItemStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("id").forGetter(class_1799::method_41409), (App)class_5699.method_48766((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new)));
    public static final Codec<class_2371<class_1799>> INVENTORY_CODEC = Codec.list(StackWithSlot.CODEC).xmap(l -> {
        class_2371 dl = class_2371.method_10213((int)l.stream().mapToInt(s -> s.slot + 1).max().orElse(0), (Object)class_1799.field_8037);
        l.forEach(sws -> dl.set(sws.slot(), (Object)sws.stack()));
        return dl;
    }, dl -> {
        ArrayList<StackWithSlot> l = new ArrayList<StackWithSlot>();
        for (int i = 0; i < dl.size(); ++i) {
            if (((class_1799)dl.get(i)).method_7960()) continue;
            l.add(new StackWithSlot(i, (class_1799)dl.get(i)));
        }
        return l;
    });

    public record StackWithSlot(int slot, class_1799 stack) {
        public static final Codec<StackWithSlot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BYTE.fieldOf("Slot").xmap(b -> b & 0xFF, Integer::byteValue).forGetter(StackWithSlot::slot), (App)ITEM_STACK_MAP_CODEC.forGetter(StackWithSlot::stack)).apply((Applicative)instance, StackWithSlot::new));
    }
}

