/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sisby.switchy.Switchy;
import dev.sisby.switchy.SwitchyCommands;
import dev.sisby.switchy.data.SwitchyComponentMap;
import dev.sisby.switchy.data.SwitchyComponentType;
import dev.sisby.switchy.data.SwitchyComponentTypes;
import dev.sisby.switchy.data.SwitchyProfile;
import dev.sisby.switchy.duck.SwitchyPlayer;
import dev.sisby.switchy.exception.NbtException;
import dev.sisby.switchy.exception.ProfileCurrentException;
import dev.sisby.switchy.exception.ProfileExistsException;
import dev.sisby.switchy.exception.ProfileMissingException;
import dev.sisby.switchy.exception.ProfilePreciousException;
import dev.sisby.switchy.util.DispatchMapCodec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_2203;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5218;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SwitchyPlayerData {
    private String current;
    private class_2561 greeting;
    private final Set<SwitchyComponentType<?>> componentTypes;
    private final Map<String, SwitchyProfile> profiles;
    private static final Map<class_2960, class_3545<String, String>> LEGACY_RECOVERIES = Map.ofEntries(Map.entry(SwitchyComponentTypes.INVENTORY, new class_3545((Object)"switchy_inventories:inventories", (Object)"inventory")), Map.entry(SwitchyComponentTypes.ENDER_CHEST, new class_3545((Object)"switchy_inventories:ender_chests", (Object)"inventory")), Map.entry(SwitchyComponentTypes.LEVEL, new class_3545((Object)"switchy_inventories:experience", (Object)"experienceLevel")), Map.entry(SwitchyComponentTypes.XP, new class_3545((Object)"switchy_inventories:experience", (Object)"experienceProgress")), Map.entry(SwitchyComponentTypes.TRINKETS_SLOTS, new class_3545((Object)"switchy_inventories:trinkets", (Object)"trinkets:trinkets")), Map.entry(SwitchyComponentTypes.NAME_ID, new class_3545((Object)"switchy:styled_nicknames", (Object)"styled_nickname")), Map.entry(SwitchyComponentTypes.TAILOR_SKIN, new class_3545((Object)"switchy:fabric_tailor", (Object)"")), Map.entry(SwitchyComponentTypes.DIMENSION, new class_3545((Object)"switchy_teleport:last_location", (Object)"last_location.dimension")), Map.entry(SwitchyComponentTypes.YAW, new class_3545((Object)"switchy_teleport:last_location", (Object)"last_location.yaw")), Map.entry(SwitchyComponentTypes.PITCH, new class_3545((Object)"switchy_teleport:last_location", (Object)"last_location.pitch")), Map.entry(SwitchyComponentTypes.SPAWN_X, new class_3545((Object)"switchy_teleport:spawn_point", (Object)"respawn_point.x")), Map.entry(SwitchyComponentTypes.SPAWN_Y, new class_3545((Object)"switchy_teleport:spawn_point", (Object)"respawn_point.y")), Map.entry(SwitchyComponentTypes.SPAWN_Z, new class_3545((Object)"switchy_teleport:spawn_point", (Object)"respawn_point.z")), Map.entry(SwitchyComponentTypes.SPAWN_DIMENSION, new class_3545((Object)"switchy_teleport:spawn_point", (Object)"respawn_point.dimension")), Map.entry(SwitchyComponentTypes.SPAWN_ANGLE, new class_3545((Object)"switchy_teleport:spawn_point", (Object)"respawn_point.dimension")), Map.entry(SwitchyComponentTypes.SPAWN_FORCED, new class_3545((Object)"switchy_teleport:spawn_point", (Object)"respawn_point.setSpawn")), Map.entry(SwitchyComponentTypes.HEALTH, new class_3545((Object)"switchy_status:health", (Object)"healthValue")), Map.entry(SwitchyComponentTypes.EFFECTS, new class_3545((Object)"switchy_status:status_effects", (Object)"status_effects")), Map.entry(SwitchyComponentTypes.FOOD, new class_3545((Object)"switchy_status:hunger", (Object)"foodLevel")), Map.entry(SwitchyComponentTypes.SATURATION, new class_3545((Object)"switchy_status:hunger", (Object)"foodSaturationLevel")), Map.entry(SwitchyComponentTypes.EXHAUSTION, new class_3545((Object)"switchy_status:hunger", (Object)"exhaustion")));
    private static final Pattern PARENTHESES = Pattern.compile("([<(\\[][^>)\\]]*[)>\\]])");

    private static Codec<SwitchyPlayerData> codec(SwitchyComponentTypes types) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("current").forGetter(SwitchyPlayerData::current), (App)class_5699.field_40722.optionalFieldOf("greeting").forGetter(SwitchyPlayerData::greeting), (App)types.SET_CODEC.fieldOf("componentTypes").forGetter(p -> p.componentTypes), (App)DispatchMapCodec.of(class_5699.field_41759, id -> SwitchyProfile.codec(types, id)).fieldOf("profiles").xmap(a -> new HashMap(a), b -> b).forGetter(p -> p.profiles)).apply((Applicative)instance, (current, optionalGreeting, componentTypes, profiles) -> new SwitchyPlayerData((String)current, optionalGreeting.orElse(null), (Set<SwitchyComponentType<?>>)componentTypes, (Map<String, SwitchyProfile>)profiles)));
    }

    public SwitchyPlayerData(String current, class_2561 greeting, Set<SwitchyComponentType<?>> componentTypes, Map<String, SwitchyProfile> profiles) {
        this.current = current;
        this.greeting = greeting;
        this.componentTypes = componentTypes;
        this.profiles = profiles;
    }

    public static SwitchyPlayerData of(class_3222 player) {
        return ((SwitchyPlayer)player).switchy$getOrCreatePlayerData();
    }

    public static SwitchyPlayerData ofEarly(class_3222 player) {
        return ((SwitchyPlayer)player).switchy$getPlayerData();
    }

    public static SwitchyPlayerData create(class_3222 player, class_2487 nbt) {
        SwitchyPlayerData data = new SwitchyPlayerData("default", null, new LinkedHashSet(), new LinkedHashMap<String, SwitchyProfile>());
        data.profiles.put("default", new SwitchyProfile("default", SwitchyComponentMap.empty()));
        for (SwitchyComponentType componentType : Sets.difference(SwitchyComponentTypes.instance().values(), data.componentTypes)) {
            data.initComponent(componentType, player, nbt);
        }
        if (nbt.method_10573("switchy:presets", 10)) {
            data.recoverLegacyData(player, nbt.method_10562("switchy:presets"));
        }
        return data;
    }

    public boolean profileExists(String profileId) {
        return this.profiles.containsKey(profileId);
    }

    public SwitchyProfile getCurrentProfile(class_3222 player) throws NbtException {
        return this.getProfile(this.current(), player);
    }

    public Set<String> keySet() {
        return this.profiles.keySet();
    }

    public Set<SwitchyComponentType<?>> componentSet() {
        return this.componentTypes;
    }

    public Collection<SwitchyProfile> values() {
        return this.profiles.values();
    }

    public int size() {
        return this.profiles.size();
    }

    public String current() {
        return this.current;
    }

    public Optional<class_2561> greeting() {
        return Optional.ofNullable(this.greeting);
    }

    public class_2561 greet() {
        class_2561 defaultedGreeting = Optional.ofNullable(this.greeting).orElseGet(() -> SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"welcome back! current profile: ").method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyComponentTypes.NAME.asText(this.profiles.get(this.current).getOrGetDefault(SwitchyComponentTypes.NAME, SwitchyProfile::id))).method_10852((class_2561)class_2561.method_43470((String)". ").method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyCommands.clickable("list", "/switchy", true)));
        this.greeting = null;
        return defaultedGreeting;
    }

    public SwitchyProfile getProfile(String profileId, class_3222 player) throws NbtException {
        if (profileId.equals(this.current)) {
            this.updateFromPlayer(this.profiles.get(profileId), player);
        }
        return this.profiles.get(profileId);
    }

    public int initComponents(Set<SwitchyComponentType<?>> types, class_3222 player) {
        class_2487 compound = new class_2487();
        player.method_5647(compound);
        for (SwitchyComponentType<?> type : types) {
            if (this.initComponent(type, player, compound)) {
                types.add(type);
                continue;
            }
            types.forEach(this::removeComponent);
            return 0;
        }
        return types.size();
    }

    public boolean initComponent(SwitchyComponentType<?> componentType, class_3222 player, class_2487 nbt) {
        try {
            componentType.tryInitialize(this.profiles.values().stream().map(SwitchyProfile::components).toList(), nbt, player, player.method_7334().getName());
        }
        catch (Exception e) {
            Switchy.LOGGER.warn("Failed to initialize {} for {}", new Object[]{componentType.id(), player.method_7334().getName(), e});
            return false;
        }
        this.componentTypes.add(componentType);
        return true;
    }

    public int removeComponents(Set<SwitchyComponentType<?>> types) {
        if (this.profiles.values().stream().anyMatch(p -> !p.id().equals(this.current) && types.stream().anyMatch(t -> t.isPrecious(p.components())))) {
            return 0;
        }
        for (SwitchyComponentType<?> type : types) {
            for (SwitchyProfile p2 : this.profiles.values()) {
                p2.remove(type);
            }
            this.componentTypes.remove(type);
        }
        return types.size();
    }

    public boolean removeComponent(SwitchyComponentType<?> componentType) {
        if (!this.profiles.values().stream().filter(p -> !p.id().equals(this.current) && componentType.isPrecious(p.components())).toList().isEmpty()) {
            return false;
        }
        for (SwitchyProfile profile : this.profiles.values()) {
            profile.remove(componentType);
        }
        this.componentTypes.remove(componentType);
        return true;
    }

    public void recoverLegacyData(class_3222 player, class_2487 legacyData) {
        Switchy.LOGGER.warn("[Switchy] Found legacy switchy profiles in {}, performing data recovery...", (Object)player.method_7334().getName());
        try {
            File playerDataDir = player.method_5682().method_27050(class_5218.field_24182).toFile();
            File file = File.createTempFile(player.method_5845() + "-switchy-", ".dat_old", playerDataDir);
            class_2507.method_30614((class_2487)legacyData, (File)file);
            File file2 = new File(playerDataDir, player.method_5845() + "-switchy.dat_old");
            File file3 = new File(playerDataDir, player.method_5845() + "-switchy.dat_older");
            class_156.method_27760((File)file2, (File)file, (File)file3);
            Switchy.LOGGER.info("[Switchy] Backed up legacy switchy data for {} to {}", (Object)player.method_7334().getName(), (Object)file2.getName());
        }
        catch (IOException e) {
            Switchy.LOGGER.error("[Switchy] Failed to save switchy data backup for {}! Please manually back up and remove switchy:presets from the player.dat", (Object)player.method_7334().getName(), (Object)e);
            throw new class_148(class_128.method_560((Throwable)e, (String)"Failed to save switchy data backup for %s!".formatted(player.method_7334().getName())));
        }
        class_2487 presets = legacyData.method_10562("list");
        boolean containsDefault = false;
        int recovered = 0;
        HashSet<class_2960> skippedTypeIds = new HashSet<class_2960>();
        for (String id : presets.method_10541()) {
            SwitchyProfile profile = this.getOrCreateProfile(id.toLowerCase(), player);
            if (profile.id().equals("default")) {
                containsDefault = true;
            }
            try {
                class_2487 compound;
                class_2520 layers;
                SwitchyComponentType positionType;
                class_2499 list;
                class_2520 layers2;
                SwitchyComponentType powersType;
                class_2499 list2;
                class_2520 layers3;
                class_2487 modules = presets.method_10562(id);
                for (class_2960 typeId : LEGACY_RECOVERIES.keySet()) {
                    SwitchyComponentType type = (SwitchyComponentType)SwitchyComponentTypes.instance().get(typeId);
                    class_2487 moduleCompound = modules.method_10562((String)LEGACY_RECOVERIES.get(typeId).method_15442());
                    if (type == null) continue;
                    class_2203.class_2209 path = class_2203.method_9360().method_9362(new StringReader((String)LEGACY_RECOVERIES.get(typeId).method_15441()));
                    try {
                        class_2520 element = (class_2520)path.method_9366((class_2520)moduleCompound).get(0);
                        type.codec().parse((DynamicOps)class_2509.field_11560, (Object)element).result().ifPresent(v -> profile.set(type, v));
                        ++recovered;
                    }
                    catch (CommandSyntaxException e) {
                        skippedTypeIds.add(typeId);
                    }
                }
                SwitchyComponentType originType = (SwitchyComponentType)SwitchyComponentTypes.instance().get(SwitchyComponentTypes.ORIGINS_ORIGIN);
                if (originType != null && (layers3 = modules.method_10562("switchy:origins").method_10580("OriginLayers")) instanceof class_2499 && !(list2 = (class_2499)layers3).isEmpty()) {
                    class_2487 originsCompound = new class_2487();
                    originsCompound.method_10566("OriginLayers", (class_2520)list2);
                    originsCompound.method_10556("HadOriginBefore", true);
                    originsCompound.method_10556("SelectingOrigin", false);
                    profile.set(originType, originsCompound);
                    ++recovered;
                }
                if ((powersType = (SwitchyComponentType)SwitchyComponentTypes.instance().get(SwitchyComponentTypes.ORIGINS_POWERS)) != null && (layers2 = modules.method_10562("switchy:apoli").method_10580("PowerData")) instanceof class_2499 && !(list = (class_2499)layers2).isEmpty()) {
                    class_2487 powersCompound = new class_2487();
                    powersCompound.method_10566("Powers", (class_2520)list);
                    profile.set(powersType, powersCompound);
                    ++recovered;
                }
                if ((positionType = (SwitchyComponentType)SwitchyComponentTypes.instance().get(SwitchyComponentTypes.POS)) == null || !((layers = modules.method_10562("switchy_teleport:last_location").method_10580("last_location")) instanceof class_2487) || (compound = (class_2487)layers).method_33133()) continue;
                class_243 position = new class_243((double)compound.method_10583("x"), (double)compound.method_10583("y"), (double)compound.method_10583("z"));
                profile.set(positionType, position);
                ++recovered;
            }
            catch (Exception e) {
                Switchy.LOGGER.error("[Switchy] Failed to recover legacy precious data {} of {}, please manually recover via -switchy.dat_old", new Object[]{id, player.method_7334().getName(), e});
            }
        }
        this.current = legacyData.method_10558("current").toLowerCase();
        if (!containsDefault) {
            this.profiles.remove("default");
        }
        Switchy.LOGGER.info("[Switchy] Finished recovering {} components from {} legacy switchy profiles for {}. Skipped: {}", new Object[]{recovered, presets.method_10546(), player.method_7334().getName(), skippedTypeIds});
    }

    public SwitchyProfile getOrCreateProfile(String profileId, class_3222 player) {
        if (this.profileExists(profileId)) {
            return this.profiles.get(profileId);
        }
        class_2487 nbt = new class_2487();
        player.method_5647(nbt);
        SwitchyComponentMap components = SwitchyComponentMap.empty();
        for (SwitchyComponentType<?> componentType : this.componentTypes) {
            try {
                componentType.tryInitialize(List.of(components), nbt, player, profileId);
            }
            catch (Exception e) {
                Switchy.LOGGER.warn("Failed to initialize {} for {} profile {}", new Object[]{componentType.id(), player.method_7334().getName(), profileId, e});
            }
        }
        SwitchyProfile newProfile = new SwitchyProfile(profileId, components);
        this.profiles.put(profileId, newProfile);
        return newProfile;
    }

    public void validate(class_3222 self, class_2487 nbt) {
        HashSet<class_2960> groupsChecked = new HashSet<class_2960>();
        for (SwitchyComponentType<?> type : new HashSet(this.componentTypes)) {
            class_2960 group = type.group();
            if (group == null || groupsChecked.contains(group)) continue;
            groupsChecked.add(group);
            for (SwitchyComponentType otherType : SwitchyComponentTypes.instance().values()) {
                if (!group.equals((Object)otherType.group()) || this.componentTypes.contains(otherType)) continue;
                Switchy.LOGGER.info("[Switchy] Enabling component {} of partially enabled group {} for user {}", new Object[]{otherType.id(), group, self.method_7334().getName()});
                this.initComponent(otherType, self, nbt);
            }
        }
    }

    public String profileAfter(String current) {
        if (!this.profileExists(current)) {
            throw new ProfileMissingException(current);
        }
        List orderedProfiles = this.profiles.keySet().stream().sorted().toList();
        return (String)orderedProfiles.get((orderedProfiles.indexOf(current) + 1) % orderedProfiles.size());
    }

    public String randomBesides(String current, class_5819 random) {
        if (!this.profileExists(current)) {
            throw new ProfileMissingException(current);
        }
        ArrayList orderedProfiles = new ArrayList(this.profiles.keySet().stream().sorted().toList());
        orderedProfiles.remove(current);
        return (String)orderedProfiles.get(random.method_43048(orderedProfiles.size()));
    }

    public int importProfiles(List<ProfileImportData> profileData, class_3222 player, @Nullable String name, boolean allowNew, Function<Integer, class_2561> greetingGetter) throws NbtException {
        int updated = 0;
        SwitchyProfile newCurrent = null;
        for (ProfileImportData data : profileData) {
            String newName;
            String id = data.name().toLowerCase();
            if (!allowNew && !this.keySet().contains(id)) continue;
            ++updated;
            SwitchyProfile profile = this.getOrCreateProfile(id, player);
            StringBuilder bracketed = new StringBuilder();
            if (data.display_name() != null) {
                Matcher matcher = PARENTHESES.matcher(data.display_name());
                while (matcher.find()) {
                    bracketed.append(matcher.group(1));
                }
            }
            if (!(newName = "<hover:'%s%s | %s%s'><#%s>%s".formatted(bracketed.isEmpty() ? "" : String.valueOf(bracketed) + (data.pronouns() != null ? " - " : ""), Objects.requireNonNullElse(data.pronouns(), ""), Objects.requireNonNullElse(name, player.method_7334().getName()), data.description() == null ? "" : " | " + data.description(), Objects.requireNonNullElse(data.color(), "FFFFFF"), Objects.requireNonNullElse(data.display_name(), id).replace(bracketed, "")).trim()).equals(profile.get(SwitchyComponentTypes.NAME))) {
                if (this.current.equals(id)) {
                    newCurrent = profile;
                }
                profile.set(SwitchyComponentTypes.NAME, newName);
            }
            if (data.components() == null) continue;
            for (String componentKey : data.components().keySet()) {
                SwitchyComponentType type = profile.components().keySet().stream().filter(t -> t.id().toString().equals(componentKey)).findFirst().orElse(null);
                if (type == null || !type.importable()) continue;
                if (this.current.equals(id)) {
                    newCurrent = profile;
                }
                type.decode(JsonOps.INSTANCE, data.components.get(componentKey), profile.components());
            }
        }
        if (newCurrent != null) {
            this.selfSwitch(newCurrent, player, greetingGetter.apply(updated));
        }
        return updated;
    }

    private class_2487 updateFromPlayer(SwitchyProfile profile, class_3222 player) throws NbtException {
        class_2487 nbt = new class_2487();
        player.method_5647(nbt);
        for (SwitchyComponentType<?> componentType : this.componentTypes) {
            if (componentType.nbtReader() != null) {
                profile.components().set(componentType, componentType.nbtReader().read(nbt));
                continue;
            }
            if (componentType.playerReader() == null) continue;
            profile.components().set(componentType, componentType.playerReader().read(player, profile.id()));
        }
        return nbt;
    }

    public void renameProfile(String oldId, String newId) throws IllegalArgumentException {
        if (!this.profileExists(oldId)) {
            throw new ProfileMissingException(oldId);
        }
        if (this.profileExists(newId)) {
            throw new ProfileExistsException(newId);
        }
        this.profiles.put(newId, this.profiles.remove(oldId).withId(newId));
        if (this.current.equals(oldId)) {
            this.current = newId;
        }
    }

    public SwitchyProfile deleteProfile(String profileId) {
        if (this.current.equals(profileId)) {
            throw new ProfileCurrentException(profileId);
        }
        if (!this.profileExists(profileId)) {
            throw new ProfileMissingException(profileId);
        }
        SwitchyProfile profile = this.profiles.get(profileId);
        Set<SwitchyComponentType<?>> preciousComponents = profile.components().keySet().stream().filter(t -> t.isPrecious(profile.components())).collect(Collectors.toSet());
        if (!preciousComponents.isEmpty()) {
            throw new ProfilePreciousException(preciousComponents, profile.components());
        }
        this.profiles.remove(profileId);
        return profile;
    }

    private void switchProfile(SwitchyProfile nextProfile, class_3222 player, class_2561 greeting) throws NbtException {
        class_2487 playerNbt;
        boolean selfSwitch;
        SwitchyProfile currentProfile = this.profiles.get(this.current);
        boolean bl = selfSwitch = currentProfile == nextProfile;
        if (selfSwitch) {
            playerNbt = new class_2487();
            player.method_5647(playerNbt);
        } else {
            playerNbt = this.updateFromPlayer(currentProfile, player);
        }
        for (SwitchyComponentType<?> componentType : nextProfile.components().keySet()) {
            componentType.tryMutate(nextProfile.components(), playerNbt, player);
        }
        this.greeting = greeting;
        this.current = nextProfile.id();
        ((SwitchyPlayer)player).switchy$hotSwap(playerNbt, (class_2561)SwitchyCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(selfSwitch ? "Updated current profile " : "Switching to ")).method_27692(class_124.field_1080)).method_10852((class_2561)SwitchyComponentTypes.NAME.asText(nextProfile.getOrGetDefault(SwitchyComponentTypes.NAME, SwitchyProfile::id))).method_10852((class_2561)class_2561.method_43470((String)"! Please reconnect.").method_27692(class_124.field_1080)));
    }

    public static SwitchyPlayerData fromNbt(class_2487 playerNbt) {
        if (SwitchyComponentTypes.instance() == null) {
            throw new IllegalStateException("Can't load switchy data while the types aren't loaded!");
        }
        return (SwitchyPlayerData)SwitchyPlayerData.codec(SwitchyComponentTypes.instance()).parse((DynamicOps)class_2509.field_11560, (Object)playerNbt.method_10562("switchy")).getOrThrow(true, arg_0 -> ((Logger)Switchy.LOGGER).error(arg_0));
    }

    public void writeNbt(class_2487 playerNbt) {
        if (SwitchyComponentTypes.instance() == null) {
            throw new IllegalStateException("Can't save switchy data while the types aren't loaded!");
        }
        if (this.size() > 1) {
            playerNbt.method_10566("switchy", (class_2520)SwitchyPlayerData.codec(SwitchyComponentTypes.instance()).encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow(true, arg_0 -> ((Logger)Switchy.LOGGER).error(arg_0)));
        }
    }

    public void switchOrCreateProfile(String profileId, class_3222 player, class_2561 greeting) throws NbtException {
        SwitchyProfile nextProfile = this.getOrCreateProfile(profileId.toLowerCase(), player);
        if (nextProfile.id().equals(this.current)) {
            throw new ProfileCurrentException(nextProfile.id());
        }
        this.switchProfile(nextProfile, player, greeting);
    }

    public void selfSwitch(SwitchyProfile currentProfile, class_3222 player, class_2561 greeting) throws NbtException {
        if (!currentProfile.id().equals(this.current)) {
            throw new ProfileCurrentException(currentProfile.id());
        }
        this.switchProfile(currentProfile, player, greeting);
    }

    public record ProfileImportData(String name, @Nullable String display_name, @Nullable String color, @Nullable String pronouns, @Nullable String description, @Nullable String avatar_url, @Nullable List<ProxyTag> proxy_tags, @Nullable Map<String, JsonElement> components) {
    }

    public record ProxyTag(@Nullable String prefix, @Nullable String suffix) {
    }
}

