/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy.data;

import dev.sisby.switchy.data.SwitchyComponentMap;
import dev.sisby.switchy.data.SwitchyComponentType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public interface SwitchyComponentHolder<H extends SwitchyComponentHolder<H>> {
    public SwitchyComponentMap components();

    @Nullable
    default public <T> T get(SwitchyComponentType<? extends T> type) {
        return this.components().get(type);
    }

    default public <T> T getOrDefault(SwitchyComponentType<? extends T> type, T fallback) {
        return this.components().getOrDefault(type, fallback);
    }

    default public <T> T getOrGetDefault(SwitchyComponentType<? extends T> type, Function<H, T> fallback) {
        return this.components().getOrDefault(type, fallback.apply(this));
    }

    @Nullable
    default public <T> T set(SwitchyComponentType<? extends T> type, @Nullable T value) {
        return this.components().set(type, value);
    }

    @Nullable
    default public <T, U> T apply(SwitchyComponentType<T> type, T defaultValue, U change, BiFunction<T, U, T> applier) {
        return this.set(type, applier.apply(this.getOrDefault(type, defaultValue), change));
    }

    @Nullable
    default public <T> T apply(SwitchyComponentType<T> type, T defaultValue, UnaryOperator<T> applier) {
        T object = this.getOrDefault(type, defaultValue);
        return this.set(type, applier.apply(object));
    }

    @Nullable
    default public <T> T remove(SwitchyComponentType<? extends T> type) {
        return this.components().remove(type);
    }

    default public boolean contains(SwitchyComponentType<?> type) {
        return this.components().contains(type);
    }
}

