/*
 * Decompiled with CFR 0.152.
 */
package dev.sisby.switchy.data;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.sisby.switchy.Switchy;
import dev.sisby.switchy.SwitchyCommands;
import dev.sisby.switchy.data.SwitchyComponentMap;
import dev.sisby.switchy.exception.ComponentFailedInitializeException;
import dev.sisby.switchy.exception.NbtException;
import dev.sisby.switchy.util.TypeRegistry;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface SwitchyComponentType<T>
extends TypeRegistry.Type {
    public static <T> Builder<T> builder(@NotNull class_2960 id, @NotNull Codec<T> codec) {
        return new Builder<T>(id, codec);
    }

    @NotNull
    public Codec<T> codec();

    @Nullable
    public Initializer<T> initializer();

    @Nullable
    public NbtReader<T> nbtReader();

    @Nullable
    public NbtMutator<T> nbtMutator();

    @Nullable
    public PlayerReader<T> playerReader();

    @Nullable
    public PlayerMutator<T> playerMutator();

    @Nullable
    public EmptyChecker<T> emptyChecker();

    @Nullable
    public TextProvider<T> textProvider();

    @Nullable
    public ArgumentEditor<T> argumentEditor();

    @Nullable
    public class_2960 group();

    public boolean hidden();

    public boolean importable();

    public int previewPriority();

    default public <S> Optional<S> encode(DynamicOps<S> ops, SwitchyComponentMap components) {
        return this.codec().encodeStart(ops, components.get(this)).resultOrPartial(arg_0 -> ((Logger)Switchy.LOGGER).error(arg_0));
    }

    default public <S> void decode(DynamicOps<S> ops, S input, SwitchyComponentMap components) {
        this.codec().decode(ops, input).resultOrPartial(arg_0 -> ((Logger)Switchy.LOGGER).error(arg_0)).ifPresent(p -> components.set(this, p.getFirst()));
    }

    default public void tryInitialize(Collection<SwitchyComponentMap> consumer, class_2487 nbt, class_3222 player, String profileId) {
        Initializer<T> initializer = this.initializer();
        if (initializer == null) {
            return;
        }
        T value = initializer.initialize(nbt, player, profileId);
        consumer.forEach(c -> c.set(this, value));
    }

    default public void tryMutate(SwitchyComponentMap components, class_2487 playerData, class_3222 player) throws NbtException {
        NbtMutator nbtMutator = this.nbtMutator();
        PlayerMutator playerMutator = this.playerMutator();
        if (nbtMutator != null) {
            nbtMutator.mutate(components.get(this), playerData);
        } else if (playerMutator != null) {
            playerMutator.mutate(components.get(this), player);
        }
    }

    default public class_5250 asText(T value) {
        TextProvider<T> textProvider = this.textProvider();
        if (textProvider != null) {
            return textProvider.toText(value).method_27661();
        }
        return class_2561.method_43470((String)Objects.toString(value));
    }

    default public void tryCreateEditor(Consumer<ArgumentBuilder<class_2168, ?>> consumer) {
        ArgumentEditor<Object> editor = this.argumentEditor();
        if (editor != null) {
            consumer.accept(editor.create((c, v) -> SwitchyCommands.execute((CommandContext<class_2168>)c, (i, p, d, f) -> SwitchyCommands.editComponent(p, d, f, ((String)c.getArgument("profile", String.class)).toLowerCase(), this, v))));
        }
    }

    default public class_5250 asText(SwitchyComponentMap components) {
        return this.asText(components.get(this));
    }

    default public boolean isPrecious(SwitchyComponentMap components) {
        EmptyChecker emptyChecker = this.emptyChecker();
        if (emptyChecker != null) {
            return !emptyChecker.isEmpty(components.get(this));
        }
        return false;
    }

    public static class Builder<T> {
        @NotNull
        private final class_2960 id;
        @NotNull
        private final Codec<T> codec;
        @Nullable
        private Initializer<T> initializer;
        @Nullable
        private NbtReader<T> nbtReader;
        @Nullable
        private NbtMutator<T> nbtMutator;
        @Nullable
        private PlayerReader<T> playerReader;
        @Nullable
        private PlayerMutator<T> playerMutator;
        @Nullable
        private EmptyChecker<T> emptyChecker;
        @Nullable
        private TextProvider<T> textProvider;
        @Nullable
        private ArgumentEditor<T> argumentEditor;
        @Nullable
        private class_2960 group;
        private boolean hidden = false;
        private boolean importable = false;
        private int previewPriority = 0;

        public Builder(@NotNull class_2960 id, @NotNull Codec<T> codec) {
            this.id = id;
            this.codec = codec;
        }

        public Builder<T> initializer(@Nullable Initializer<T> initializer) {
            if (initializer != null) {
                this.initializer = initializer;
            }
            return this;
        }

        public Builder<T> playerReader(@Nullable PlayerReader<T> playerReader) {
            this.playerReader = playerReader;
            return this;
        }

        public Builder<T> playerMutator(@Nullable PlayerMutator<T> playerMutator) {
            this.playerMutator = playerMutator;
            return this;
        }

        public Builder<T> emptyChecker(@Nullable EmptyChecker<T> emptyChecker) {
            this.emptyChecker = emptyChecker;
            return this;
        }

        public Builder<T> textProvider(@Nullable TextProvider<T> textProvider) {
            this.textProvider = textProvider;
            return this;
        }

        public Builder<T> argumentEditor(@Nullable ArgumentEditor<T> argumentEditor) {
            this.argumentEditor = argumentEditor;
            return this;
        }

        public Builder<T> nbtSwitcher(class_2203.class_2209 path) {
            NbtSwitcher<T> switcher = new NbtSwitcher<T>(path, this.codec);
            this.nbtReader = switcher;
            this.nbtMutator = switcher;
            this.initializer = new CopyInitializer<T>(switcher);
            return this;
        }

        public Builder<T> group(@Nullable class_2960 group) {
            this.group = group;
            return this;
        }

        public Builder<T> hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder<T> importable(boolean importable) {
            this.importable = importable;
            return this;
        }

        public Builder<T> previewPriority(int priority) {
            this.previewPriority = priority;
            return this;
        }

        public SwitchyComponentType<T> build() {
            return new SimpleSwitchyComponentType<T>(this.id, this.codec, this.initializer, this.nbtReader, this.nbtMutator, this.playerReader, this.playerMutator, this.emptyChecker, this.textProvider, this.argumentEditor, this.group, this.hidden, this.importable, this.previewPriority);
        }
    }

    @FunctionalInterface
    public static interface Initializer<T> {
        public T initialize(class_2487 var1, class_3222 var2, String var3) throws ComponentFailedInitializeException;
    }

    @FunctionalInterface
    public static interface NbtMutator<T> {
        public void mutate(T var1, class_2487 var2) throws NbtException;
    }

    @FunctionalInterface
    public static interface PlayerMutator<T> {
        public void mutate(T var1, class_3222 var2);
    }

    @FunctionalInterface
    public static interface TextProvider<T> {
        public class_2561 toText(T var1);
    }

    @FunctionalInterface
    public static interface ArgumentEditor<T> {
        public ArgumentBuilder<class_2168, ?> create(EditExecutor<T> var1);
    }

    @FunctionalInterface
    public static interface EditExecutor<T> {
        public int execute(CommandContext<class_2168> var1, T var2);
    }

    @FunctionalInterface
    public static interface EmptyChecker<T> {
        public boolean isEmpty(T var1);
    }

    public record SimpleSwitchyComponentType<T>(class_2960 id, @Nullable Codec<T> codec, @Nullable Initializer<T> initializer, @Nullable NbtReader<T> nbtReader, @Nullable NbtMutator<T> nbtMutator, @Nullable PlayerReader<T> playerReader, @Nullable PlayerMutator<T> playerMutator, @Nullable EmptyChecker<T> emptyChecker, @Nullable TextProvider<T> textProvider, @Nullable ArgumentEditor<T> argumentEditor, @Nullable class_2960 group, boolean hidden, boolean importable, int previewPriority) implements SwitchyComponentType<T>
    {
        @Override
        public String toString() {
            return this.id.toString();
        }
    }

    public static class NbtSwitcher<T>
    implements NbtMutator<T>,
    NbtReader<T> {
        private final class_2203.class_2209 nbtPath;
        private final Codec<T> codec;

        public NbtSwitcher(class_2203.class_2209 nbtPath, Codec<T> codec) {
            this.nbtPath = nbtPath;
            this.codec = codec;
        }

        @Override
        public T read(class_2487 nbt) throws NbtException {
            try {
                DataResult result = this.codec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)this.nbtPath.method_9366((class_2520)nbt).get(0)));
                if (result.error().isPresent()) {
                    throw new NbtException("Failed to read from serialized player! %s".formatted(((DataResult.Error)result.error().get()).message()));
                }
                return result.resultOrPartial(arg_0 -> ((Logger)Switchy.LOGGER).error(arg_0)).orElse(null);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        }

        @Override
        public void mutate(T value, class_2487 nbt) throws NbtException {
            try {
                if (value == null) {
                    this.nbtPath.method_9372((class_2520)nbt);
                    return;
                }
                DataResult result = this.codec.encodeStart((DynamicOps)class_2509.field_11560, value);
                if (result.error().isPresent()) {
                    throw new NbtException("Failed to serialize component! %s".formatted(((DataResult.Error)result.error().get()).message()));
                }
                class_2520 encoded = result.resultOrPartial(arg_0 -> ((Logger)Switchy.LOGGER).error(arg_0)).orElse(null);
                if (encoded == null) {
                    this.nbtPath.method_9372((class_2520)nbt);
                    return;
                }
                this.nbtPath.method_35722((class_2520)nbt, encoded);
            }
            catch (CommandSyntaxException e) {
                throw new NbtException("NBT path too deep!");
            }
        }

        public String toString() {
            return this.nbtPath.toString();
        }
    }

    public record CopyInitializer<T>(NbtReader<T> nbtReader) implements Initializer<T>
    {
        @Override
        public T initialize(class_2487 playerNbt, class_3222 player, String profileId) throws ComponentFailedInitializeException {
            try {
                return this.nbtReader.read(playerNbt);
            }
            catch (Exception e) {
                throw new ComponentFailedInitializeException("", e);
            }
        }
    }

    public record SimpleArgumentEditor<T>(Function<EditExecutor<T>, ArgumentBuilder<class_2168, ?>> editor) implements ArgumentEditor<T>
    {
        @Override
        public ArgumentBuilder<class_2168, ?> create(EditExecutor<T> executor) {
            return this.editor.apply(executor);
        }
    }

    public record SimpleEmptyChecker<T>(Predicate<T> predicate) implements EmptyChecker<T>
    {
        @Override
        public boolean isEmpty(T value) {
            return this.predicate.test(value);
        }
    }

    public record SimpleTextProvider<T>(Function<T, class_2561> provider) implements TextProvider<T>
    {
        @Override
        public class_2561 toText(T value) {
            return value == null ? class_2561.method_43473() : this.provider.apply(value);
        }
    }

    @FunctionalInterface
    public static interface PlayerReader<T> {
        public T read(class_3222 var1, String var2);
    }

    @FunctionalInterface
    public static interface NbtReader<T> {
        public T read(class_2487 var1) throws NbtException;
    }
}

