/*
 * Decompiled with CFR 0.152.
 */
package net.spidx.advanced_copper_mod.event;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.spidx.advanced_copper_mod.util.ModMaps;

@EventBusSubscriber(modid="advanced_copper")
public class ModEvents {
    @SubscribeEvent
    public static void onTickInventoryEvent(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        Inventory inventory = player.getInventory();
        if (!level.isClientSide() && (double)player.getRandom().nextFloat() < 0.3) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                float second_chance = player.getRandom().nextFloat();
                ItemStack itemStack = inventory.getItem(i);
                if (!ModMaps.OXIDATION_MAP.containsKey(itemStack.getItem()) || !(second_chance < 5.2E-4f)) continue;
                int count = itemStack.getCount();
                int currentDamage = inventory.getItem(i).getDamageValue();
                inventory.setItem(i, new ItemStack((ItemLike)ModMaps.getOxidized(itemStack.getItem()), count));
                if (currentDamage <= 0) continue;
                inventory.getItem(i).setDamageValue(currentDamage);
            }
        }
    }

    @SubscribeEvent
    public static void onTickEvent(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide() && entity instanceof ItemEntity) {
            int waterLevel;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.getItem();
            BlockPos pos = itemEntity.blockPosition();
            BlockState state = level.getBlockState(pos);
            if (state.is(Blocks.WATER_CAULDRON) && ModMaps.OXIDATION_MAP_FOR_CAULDRON.containsKey(itemStack.getItem()) && itemEntity.getAge() > 20 && (waterLevel = ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) > 0) {
                if (waterLevel == 1) {
                    level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, 10, 0.3, 0.2, 0.3, 0.05);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 0.01);
                }
                int currentDamage = itemEntity.getItem().getDamageValue();
                ItemStack newItemStack = new ItemStack((ItemLike)ModMaps.OXIDATION_MAP_FOR_CAULDRON.get(itemStack.getItem()), itemStack.getCount());
                newItemStack.setDamageValue(currentDamage);
                ItemEntity newEntity = new ItemEntity(level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), newItemStack);
                itemEntity.discard();
                level.addFreshEntity((Entity)newEntity);
                level.playSound(null, pos, SoundEvents.COPPER_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.ITEM_INTERACT_FINISH, pos);
            }
        }
    }
}

