/*
 * Decompiled with CFR 0.152.
 */
package net.spidx.advanced_copper_mod.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.spidx.advanced_copper_mod.item.ModItems;

public class ModMaps {
    public static final Map<Item, Item> OXIDATION_MAP = ModMaps.createOxidationMap();
    public static final Map<Item, Item> OXIDATION_MAP_FOR_CAULDRON = Collections.unmodifiableMap(ModMaps.createOxidationMapForCauldron());

    private static Map<Item, Item> createOxidationMapForCauldron() {
        HashMap<Item, Item> map = new HashMap();
        map = ModMaps.createOxidationMap();
        ModMaps.addOxidationChain(map, Items.COPPER_BLOCK, Items.EXPOSED_COPPER, Items.WEATHERED_COPPER, Items.OXIDIZED_COPPER);
        ModMaps.addOxidationChain(map, Items.COPPER_GRATE, Items.EXPOSED_COPPER_GRATE, Items.WEATHERED_COPPER_GRATE, Items.OXIDIZED_COPPER_GRATE);
        ModMaps.addOxidationChain(map, Items.CHISELED_COPPER, Items.EXPOSED_CHISELED_COPPER, Items.WEATHERED_CHISELED_COPPER, Items.OXIDIZED_CHISELED_COPPER);
        ModMaps.addOxidationChain(map, Items.CUT_COPPER, Items.EXPOSED_CUT_COPPER, Items.WEATHERED_CUT_COPPER, Items.OXIDIZED_CUT_COPPER);
        ModMaps.addOxidationChain(map, Items.CUT_COPPER_STAIRS, Items.EXPOSED_CUT_COPPER_STAIRS, Items.WEATHERED_CUT_COPPER_STAIRS, Items.OXIDIZED_CUT_COPPER_STAIRS);
        ModMaps.addOxidationChain(map, Items.CUT_COPPER_SLAB, Items.EXPOSED_CUT_COPPER_SLAB, Items.WEATHERED_CUT_COPPER_SLAB, Items.OXIDIZED_CUT_COPPER_SLAB);
        ModMaps.addOxidationChain(map, Items.COPPER_DOOR, Items.EXPOSED_COPPER_DOOR, Items.WEATHERED_COPPER_DOOR, Items.OXIDIZED_COPPER_DOOR);
        ModMaps.addOxidationChain(map, Items.COPPER_TRAPDOOR, Items.EXPOSED_COPPER_TRAPDOOR, Items.WEATHERED_COPPER_TRAPDOOR, Items.OXIDIZED_COPPER_TRAPDOOR);
        ModMaps.addOxidationChain(map, (Item)ModItems.PRODUCTION_FURNACE.get(), (Item)ModItems.EXPOSED_PRODUCTION_FURNACE.get(), (Item)ModItems.WEATHERED_PRODUCTION_FURNACE.get(), (Item)ModItems.OXIDIZED_PRODUCTION_FURNACE.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_BARS.get(), (Item)ModItems.EXPOSED_COPPER_BARS.get(), (Item)ModItems.WEATHERED_COPPER_BARS.get(), (Item)ModItems.OXIDIZED_COPPER_BARS.get());
        return map;
    }

    private static Map<Item, Item> createOxidationMap() {
        HashMap<Item, Item> map = new HashMap<Item, Item>();
        ModMaps.addOxidationChain(map, Items.COPPER_INGOT, (Item)ModItems.EXPOSED_COPPER_INGOT.get(), (Item)ModItems.WEATHERED_COPPER_INGOT.get(), (Item)ModItems.OXIDIZED_COPPER_INGOT.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_SWORD.get(), (Item)ModItems.EXPOSED_COPPER_SWORD.get(), (Item)ModItems.WEATHERED_COPPER_SWORD.get(), (Item)ModItems.OXIDIZED_COPPER_SWORD.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_PICKAXE.get(), (Item)ModItems.EXPOSED_COPPER_PICKAXE.get(), (Item)ModItems.WEATHERED_COPPER_PICKAXE.get(), (Item)ModItems.OXIDIZED_COPPER_PICKAXE.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_AXE.get(), (Item)ModItems.EXPOSED_COPPER_AXE.get(), (Item)ModItems.WEATHERED_COPPER_AXE.get(), (Item)ModItems.OXIDIZED_COPPER_AXE.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_SHOVEL.get(), (Item)ModItems.EXPOSED_COPPER_SHOVEL.get(), (Item)ModItems.WEATHERED_COPPER_SHOVEL.get(), (Item)ModItems.OXIDIZED_COPPER_SHOVEL.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_HOE.get(), (Item)ModItems.EXPOSED_COPPER_HOE.get(), (Item)ModItems.WEATHERED_COPPER_HOE.get(), (Item)ModItems.OXIDIZED_COPPER_HOE.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_NUGGET.get(), (Item)ModItems.EXPOSED_COPPER_NUGGET.get(), (Item)ModItems.WEATHERED_COPPER_NUGGET.get(), (Item)ModItems.OXIDIZED_COPPER_NUGGET.get());
        return map;
    }

    private static void addOxidationChain(Map<Item, Item> map, Item ... items) {
        if (items.length < 2) {
            return;
        }
        for (int i = 0; i < items.length - 1; ++i) {
            map.put(items[i], items[i + 1]);
        }
    }

    public static Item getOxidized(Item item) {
        return OXIDATION_MAP.get(item);
    }
}

