/*
 * Decompiled with CFR 0.152.
 */
package net.spidx.advanced_copper_mod.item.custom;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class WaxedatorItem
extends HoneycombItem {
    public static final int MAX_DURABILITY = 256;

    public WaxedatorItem(Item.Properties properties) {
        super(properties.durability(256));
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        BlockPos blockpos = useOnContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        return WaxedatorItem.getWaxed((BlockState)blockstate).map(blockState -> {
            Player player = useOnContext.getPlayer();
            ItemStack itemstack = useOnContext.getItemInHand();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverplayer, blockpos, itemstack);
            }
            itemstack.setDamageValue(itemstack.getDamageValue() + 1);
            if (itemstack.getDamageValue() >= 256) {
                itemstack.shrink(1);
                level.playSound((Entity)player, (double)useOnContext.getClickedPos().getX(), (double)useOnContext.getClickedPos().getY(), (double)useOnContext.getClickedPos().getZ(), (Holder)SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            level.setBlock(blockpos, blockState, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            level.levelEvent((Entity)player, 3003, blockpos, 0);
            return InteractionResult.SUCCESS;
        }).orElse((InteractionResult)InteractionResult.PASS);
    }

    public boolean isCombineRepairable(ItemStack stack) {
        return stack.is(Items.COPPER_INGOT);
    }
}

