/*
 * Decompiled with CFR 0.152.
 */
package net.spidx.advanced_copper_mod.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.spidx.advanced_copper_mod.item.ModItems;

public class ModMaps {
    public static final Map<Item, Item> OXIDATION_MAP = ModMaps.createOxidationMap();

    private static Map<Item, Item> createOxidationMap() {
        HashMap<Item, Item> map = new HashMap<Item, Item>();
        ModMaps.addOxidationChain(map, Items.COPPER_INGOT, (Item)ModItems.EXPOSED_COPPER_INGOT.get(), (Item)ModItems.WEATHERED_COPPER_INGOT.get(), (Item)ModItems.OXIDIZED_COPPER_INGOT.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_SWORD.get(), (Item)ModItems.EXPOSED_COPPER_SWORD.get(), (Item)ModItems.WEATHERED_COPPER_SWORD.get(), (Item)ModItems.OXIDIZED_COPPER_SWORD.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_PICKAXE.get(), (Item)ModItems.EXPOSED_COPPER_PICKAXE.get(), (Item)ModItems.WEATHERED_COPPER_PICKAXE.get(), (Item)ModItems.OXIDIZED_COPPER_PICKAXE.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_AXE.get(), (Item)ModItems.EXPOSED_COPPER_AXE.get(), (Item)ModItems.WEATHERED_COPPER_AXE.get(), (Item)ModItems.OXIDIZED_COPPER_AXE.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_SHOVEL.get(), (Item)ModItems.EXPOSED_COPPER_SHOVEL.get(), (Item)ModItems.WEATHERED_COPPER_SHOVEL.get(), (Item)ModItems.OXIDIZED_COPPER_SHOVEL.get());
        ModMaps.addOxidationChain(map, (Item)ModItems.COPPER_HOE.get(), (Item)ModItems.EXPOSED_COPPER_HOE.get(), (Item)ModItems.WEATHERED_COPPER_HOE.get(), (Item)ModItems.OXIDIZED_COPPER_HOE.get());
        return Collections.unmodifiableMap(map);
    }

    private static void addOxidationChain(Map<Item, Item> map, Item ... items) {
        if (items.length < 2) {
            return;
        }
        for (int i = 0; i < items.length - 1; ++i) {
            map.put(items[i], items[i + 1]);
        }
    }

    public static Item getOxidized(Item item) {
        return OXIDATION_MAP.get(item);
    }
}

