/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream.api;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface Rewriter {
    public static final Logger logger = LogManager.getLogger(Rewriter.class);
    public static final Rewriter DEFAULT = (origin, target) -> {
        logger.trace("Creating parent directories for {}", target);
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Couldn't create parent directories for {}", target, e);
        }
        if (Files.exists(target, new LinkOption[0])) {
            logger.trace("Target file {} already exists, skipping", target);
            return target;
        }
        logger.trace("Creating link from {} to {}", target, origin);
        try {
            logger.trace("Trying to create symbolic link");
            Files.createSymbolicLink(target, origin, new FileAttribute[0]);
            logger.trace("Created symbolic link");
            return target;
        }
        catch (UnsupportedOperationException uoe) {
            logger.warn("Symbolic links are not supported on this platform, falling back to hard links.");
        }
        catch (IOException e) {
            logger.error("Couldn't create symbolic link, falling back to hard link.", (Throwable)e);
        }
        try {
            logger.trace("Trying to create hard link");
            Files.createLink(target, origin);
            logger.trace("Created hard link");
            return target;
        }
        catch (UnsupportedOperationException uoe) {
            logger.warn("Hard links are not supported on this platform, falling back to copying.");
        }
        catch (IOException e) {
            logger.error("Couldn't create hard link, falling back to copying.", (Throwable)e);
        }
        try {
            logger.trace("Trying to copy file");
            Files.copy(origin, target, new CopyOption[0]);
            logger.trace("Copied file");
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Couldn't copy target file %s to %s", origin, target), e);
        }
        return target;
    };

    @NotNull
    public Path rewrite(@NotNull Path var1, @NotNull Path var2);
}

