/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream.api;

import dev.deftu.filestream.store.FastHashSchema;
import dev.deftu.filestream.store.FileStore;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

public interface Store {
    @NotNull
    public Path getStoreRoot();

    @NotNull
    public Path getObject(String var1);

    @NotNull
    public Store getSubStore(String var1);

    @NotNull
    public Store getSubStore(String var1, ObjectSchema var2);

    @NotNull
    public static Store getGlobalStore() {
        return FileStore.GLOBAL_STORE;
    }

    public static Store of(@NotNull String name) {
        return new FileStore(Store.getGlobalStore().getStoreRoot(), name);
    }

    @NotNull
    public static Store of(@NotNull String name, @NotNull ObjectSchema objectSchema) {
        return new FileStore(Store.getGlobalStore().getStoreRoot(), name, objectSchema);
    }

    @FunctionalInterface
    public static interface ObjectSchema {
        public static final ObjectSchema DIRECT = Path::resolve;
        public static final ObjectSchema URL_ENCODED = (storeRoot, name) -> storeRoot.resolve(URLEncoder.encode(name, "UTF-8"));
        public static final ObjectSchema MAVEN = (storeRoot, name) -> {
            String[] dataBits = name.split(":");
            if (dataBits.length < 3) {
                throw new UnsupportedOperationException("Invalid maven schema");
            }
            String groupId = dataBits[0];
            String artifactId = dataBits[1];
            String version = dataBits[2];
            String classifier = dataBits.length > 3 ? dataBits[3] : null;
            String extension = dataBits.length > 4 ? dataBits[4] : "jar";
            CharSequence[] groupBits = groupId.split("\\.");
            String groupPath = String.join((CharSequence)File.separator, groupBits);
            String fileName = artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + extension;
            return storeRoot.resolve(groupPath).resolve(artifactId).resolve(version).resolve(fileName);
        };

        public static ObjectSchema fastHash(MessageDigest digest) {
            return new FastHashSchema(digest);
        }

        public Path getObjectPath(Path var1, String var2) throws IOException;
    }
}

