/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream.util;

import dev.deftu.filestream.util.ProcessorType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Architecture {
    UNKNOWN(ProcessorType.UNKNOWN, "unknown", new HashSet<String>()),
    X86(ProcessorType.X86, "x86", Architecture.createAliases("x86", "amd32", "i386", "i486", "i586", "i686")),
    X86_64(ProcessorType.X64, "x86_64", Architecture.createAliases("x86_64", "amd64", "x64")),
    ARM(ProcessorType.X86, "arm", Architecture.createAliases("armv7l", "armv7", "armel", "armle", "armv", "arm")),
    AARCH(ProcessorType.X86, "aarch32", Architecture.createAliases("aarch32", "arm32")),
    AARCH_64(ProcessorType.X64, "aarch64", Architecture.createAliases("aarch64", "arm64")),
    MIPS(ProcessorType.X86, "mips", Architecture.createAliases("misle", "mipsel", "mips")),
    MIPS_64(ProcessorType.X64, "mips64", Architecture.createAliases("mips64", "mips64el", "mips")),
    PPC(ProcessorType.X86, "ppc", Architecture.createAliases("ppcel", "ppcle", "powerpc", "ppc")),
    PPC_64(ProcessorType.X64, "ppc64", Architecture.createAliases("ppc64", "powerpc64", "ppc64el", "ppc64le")),
    S390X(ProcessorType.X64, "s390x", Architecture.createAliases("s390x", "s390")),
    SPARCV9(ProcessorType.X64, "sparcv9", Architecture.createAliases("sparcv9", "sparc"));

    private final ProcessorType processorType;
    private final String name;
    private final Set<String> aliases;

    private Architecture(ProcessorType processorType, String name, Set<String> aliases) {
        this.processorType = processorType;
        this.name = name;
        this.aliases = aliases;
    }

    @NotNull
    public ProcessorType getProcessorType() {
        return this.processorType;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Set<String> getAliases() {
        return this.aliases;
    }

    private static Set<String> createAliases(String ... aliases) {
        return new HashSet<String>(Arrays.asList(aliases));
    }

    @NotNull
    public static String raw() {
        String value = Architecture.rawProcessArchitecture();
        if (value == null) {
            value = Architecture.rawProcessArchitecture64();
        }
        if (value == null) {
            value = Architecture.rawArch();
        }
        if (value == null) {
            throw new IllegalStateException("Failed to determine system architecture");
        }
        if ((value = value.toLowerCase()).equals("zarch_64")) {
            value = "s390x";
        }
        if (value.equals("ppc64") && Objects.equals(System.getProperty("sun.cpu.endian"), "little")) {
            value = "ppc64le";
        }
        return value;
    }

    @NotNull
    public static Architecture find() {
        Architecture value = UNKNOWN;
        String name = Architecture.raw();
        int platformByteCount = name.contains("64") ? 8 : 4;
        int maxAliasesSize = Arrays.stream(Architecture.values()).mapToInt(it -> it.getAliases().size()).max().orElse(0);
        for (int i2 = 0; i2 < maxAliasesSize; ++i2) {
            for (Architecture arch : Architecture.values()) {
                int byteCount;
                String alias;
                Set<String> aliases = arch.getAliases();
                if (aliases.size() <= i2 || !name.contains(alias = (String)aliases.toArray()[i2]) || (byteCount = arch.getProcessorType().getBitSize() / 8) != platformByteCount) continue;
                value = arch;
            }
        }
        return value;
    }

    @Nullable
    private static String rawProcessArchitecture() {
        try {
            return System.getenv("PROCESSOR_ARCHITECTURE");
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    private static String rawProcessArchitecture64() {
        try {
            return System.getenv("PROCESSOR_ARCHITEW6432");
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    private static String rawArch() {
        try {
            return System.getProperty("os.arch");
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

