/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.lwjgl.isolatedloader;

import dev.deftu.filestream.FileStream;
import dev.deftu.filestream.api.Store;
import dev.deftu.filestream.store.FileStore;
import dev.deftu.lwjgl.isolatedloader.Lwjgl3Downloader;
import dev.deftu.lwjgl.isolatedloader.Lwjgl3Transformer;
import dev.deftu.lwjgl.isolatedloader.classloader.IsolatedClassLoader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Path;
import java.util.Set;

public class Lwjgl3Manager {
    private static Store store;
    private static IsolatedClassLoader classLoader;
    private static ClassLoader parentClassLoader;

    private Lwjgl3Manager() {
    }

    public static void initialize(ClassLoader parent, String[] lwjglModules) throws IOException {
        if (store == null) {
            FileStore globalStore = new FileStore(FileStream.getLocalStorage(), "Deftu", Store.ObjectSchema.DIRECT);
            store = globalStore.getSubStore("Isolated LWJGL3 Loader");
        }
        if (parentClassLoader != null && parentClassLoader != parent) {
            throw new IllegalArgumentException("Parent class loader cannot be changed");
        }
        parentClassLoader = parent;
        Set<Path> jars = Lwjgl3Downloader.download(lwjglModules);
        URL[] urls2 = (URL[])jars.stream().map(Lwjgl3Transformer::maybeTransform).map(path -> {
            try {
                return path.toUri().toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).distinct().toArray(URL[]::new);
        if (classLoader == null) {
            classLoader = new IsolatedClassLoader(urls2, parent);
        } else {
            for (URL url : urls2) {
                classLoader.loadUrl(url);
            }
        }
        try {
            Path nativesDir = store.getSubStore("natives", Store.ObjectSchema.DIRECT).getStoreRoot();
            System.out.println(nativesDir);
            classLoader.loadClass("dev.deftu.lwjgl.isolatedloader.bootstrap.Lwjgl3Bootstrapper").getMethod("setup", Path.class).invoke(null, nativesDir);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T getIsolated(Class<T> clazz, String implementationName, Object ... args) {
        try {
            Class<?> implementationClass = classLoader.loadClass(implementationName);
            Class[] parameterTypes = new Class[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                parameterTypes[i2] = args[i2].getClass();
            }
            Constructor<?> constructor = implementationClass.getConstructor(parameterTypes);
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(args);
            return clazz.cast(instance);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Store getStore() {
        return store;
    }

    public static IsolatedClassLoader getClassLoader() {
        return classLoader;
    }
}

