/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.lwjgl.isolatedloader.classloader;

import dev.deftu.lwjgl.isolatedloader.classloader.NoOpClassLoader;
import dev.deftu.lwjgl.isolatedloader.utils.CombinedEnumeration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class IsolatedClassLoader
extends URLClassLoader {
    private final ClassLoader delegatedClassLoader;
    private final Set<String> loadingExceptions = new HashSet<String>();
    private final Map<String, Class<?>> classReferenceCache = new ConcurrentHashMap();

    public IsolatedClassLoader(URL[] urls2, ClassLoader delegatedClassLoader) {
        super(urls2, (ClassLoader)NoOpClassLoader.INSTANCE);
        this.delegatedClassLoader = delegatedClassLoader;
        this.loadingExceptions.add("java.");
        this.loadingExceptions.add("javax.");
        this.loadingExceptions.add("sun.");
        this.loadingExceptions.add("com.sun.");
        this.loadingExceptions.add("jdk.");
        this.loadingExceptions.add("org.w3c.");
        this.loadingExceptions.add("org.apache.logging.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> cachedClass = this.classReferenceCache.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        for (String exception : this.loadingExceptions) {
            if (!name.startsWith(exception)) continue;
            Class<?> delegatedClass = this.delegatedClassLoader.loadClass(name);
            this.classReferenceCache.put(name, delegatedClass);
            return delegatedClass;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                cls = this.findClass(name);
            }
            this.classReferenceCache.put(name, cls);
            return cls;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            String path = name.replace('.', '/').concat(".class");
            URL resource = this.getResource(path);
            if (resource == null) {
                throw new ClassNotFoundException(name + " - " + path);
            }
            try (InputStream inputStream2 = resource.openStream();){
                byte[] classBytes = this.readAllBytes(inputStream2);
                CodeSource codeSource = new CodeSource(resource, (CodeSigner[])null);
                Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length, codeSource);
                return clazz;
            }
            catch (IOException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        URL isolatedResource = super.findResource(name);
        if (isolatedResource != null) {
            return isolatedResource;
        }
        return this.delegatedClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> isolatedResources = super.findResources(name);
        Enumeration<URL> delegatedResources = this.delegatedClassLoader.getResources(name);
        return new CombinedEnumeration<URL>(isolatedResources, delegatedResources);
    }

    public void loadUrl(URL url) {
        this.addURL(url);
    }

    public void addLoadingException(String exception) {
        this.loadingExceptions.add(exception);
    }

    private byte[] readAllBytes(InputStream inputStream2) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        while ((bytesRead = inputStream2.read(buffer)) != -1) {
            outputStream2.write(buffer, 0, bytesRead);
        }
        return outputStream2.toByteArray();
    }

    static {
        IsolatedClassLoader.registerAsParallelCapable();
    }
}

