/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.lwjgl.isolatedloader.metadata;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArtifactMetadata {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String extension;
    @Nullable
    private String artifactHash;

    public ArtifactMetadata(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this(groupId, artifactId, version, null, null);
    }

    public ArtifactMetadata(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier) {
        this(groupId, artifactId, version, classifier, null);
    }

    public ArtifactMetadata(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @Nullable String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension == null ? "jar" : extension;
    }

    public void resolveHash(@NotNull URL mavenUrl) throws IOException {
        if (this.artifactHash != null) {
            return;
        }
        String url = mavenUrl.toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + this.getMavenPath();
        url = url + ".sha1";
        this.artifactHash = ArtifactMetadata.readUrl(url);
    }

    @Nullable
    public String getArtifactHash() {
        return this.artifactHash;
    }

    @NotNull
    public String getFileName() {
        return this.artifactId + "-" + this.version + (this.classifier != null ? "-" + this.classifier : "") + "." + (this.extension != null ? this.extension : "jar");
    }

    @NotNull
    public String getMavenPath() {
        return this.groupId.replace(".", "/") + "/" + this.artifactId + "/" + this.version + "/" + this.getFileName();
    }

    @NotNull
    public String getArtifactDeclaration() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + (this.classifier != null ? ":" + this.classifier : "") + (this.extension != null && !this.extension.equals("jar") ? ":" + this.extension : "");
    }

    public String toString() {
        return "ArtifactMetadata{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", classifier='" + this.classifier + '\'' + ", extension='" + this.extension + '\'' + ", artifactHash='" + this.artifactHash + '\'' + '}';
    }

    private static String readUrl(String targetUrl) throws IOException {
        try (Scanner scanner = new Scanner(new URL(targetUrl).openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }
}

