/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.SerializedCollection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b#\b\u0000\u0018\u0000 b*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00060\u0003j\u0002`\u00042\b\u0012\u0004\u0012\u00028\u00000\u00052\u00060\u0006j\u0002`\u0007:\u0003bcdB\u0011\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J \u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0096\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\"\u0010$J\u0017\u0010%\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010%\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b%\u0010(J\u001d\u0010+\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016\u00a2\u0006\u0004\b+\u0010,J%\u0010+\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016\u00a2\u0006\u0004\b+\u0010-J\u000f\u0010.\u001a\u00020'H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b0\u0010\u0017J\u0017\u00101\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b1\u0010&J\u001d\u00102\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016\u00a2\u0006\u0004\b2\u0010,J\u001d\u00103\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016\u00a2\u0006\u0004\b3\u0010,J%\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b6\u00107J)\u0010;\u001a\b\u0012\u0004\u0012\u00028\u000109\"\u0004\b\u0001\u001082\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u000109H\u0016\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f09H\u0016\u00a2\u0006\u0004\b;\u0010=J\u001a\u0010?\u001a\u00020\u00122\b\u0010>\u001a\u0004\u0018\u00010\u000fH\u0096\u0002\u00a2\u0006\u0004\b?\u0010&J\u000f\u0010@\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b@\u0010AJ\u000f\u0010C\u001a\u00020BH\u0016\u00a2\u0006\u0004\bC\u0010DJ\u000f\u0010E\u001a\u00020'H\u0002\u00a2\u0006\u0004\bE\u0010/J\u000f\u0010F\u001a\u00020'H\u0002\u00a2\u0006\u0004\bF\u0010/J\u0017\u0010H\u001a\u00020'2\u0006\u0010G\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bH\u0010\u000bJ\u0017\u0010J\u001a\u00020'2\u0006\u0010I\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bJ\u0010\u000bJ\u001b\u0010K\u001a\u00020\u00122\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\fH\u0002\u00a2\u0006\u0004\bK\u0010LJ\u001f\u0010N\u001a\u00020'2\u0006\u0010M\u001a\u00020\b2\u0006\u0010G\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bN\u0010OJ\u001f\u0010P\u001a\u00020'2\u0006\u0010M\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\bP\u0010(J-\u0010Q\u001a\u00020'2\u0006\u0010M\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0006\u0010G\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bQ\u0010RJ\u0017\u0010S\u001a\u00028\u00002\u0006\u0010M\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bS\u0010\u0017J\u001f\u0010V\u001a\u00020'2\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bV\u0010OJ5\u0010X\u001a\u00020\b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0006\u0010W\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bX\u0010YR\u001c\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u0000098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u0016\u0010\\\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010^\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0014\u0010a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010A\u00a8\u0006e"}, d2={"Lkotlin/collections/builders/ListBuilder;", "E", "", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "Lkotlin/collections/AbstractMutableList;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "", "initialCapacity", "<init>", "(I)V", "", "build", "()Ljava/util/List;", "", "writeReplace", "()Ljava/lang/Object;", "", "isEmpty", "()Z", "index", "get", "(I)Ljava/lang/Object;", "element", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "", "iterator", "()Ljava/util/Iterator;", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "add", "(Ljava/lang/Object;)Z", "", "(ILjava/lang/Object;)V", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "(ILjava/util/Collection;)Z", "clear", "()V", "removeAt", "remove", "removeAll", "retainAll", "fromIndex", "toIndex", "subList", "(II)Ljava/util/List;", "T", "", "array", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", "()[Ljava/lang/Object;", "other", "equals", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "registerModification", "checkIsMutable", "n", "ensureExtraCapacity", "minCapacity", "ensureCapacityInternal", "contentEquals", "(Ljava/util/List;)Z", "i", "insertAtInternal", "(II)V", "addAtInternal", "addAllInternal", "(ILjava/util/Collection;I)V", "removeAtInternal", "rangeOffset", "rangeLength", "removeRangeInternal", "retain", "retainOrRemoveAllInternal", "(IILjava/util/Collection;Z)I", "backing", "[Ljava/lang/Object;", "length", "I", "isReadOnly", "Z", "getSize", "size", "Companion", "Itr", "BuilderSubList", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListBuilder.kt\nkotlin/collections/builders/ListBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,722:1\n1#2:723\n*E\n"})
public final class ListBuilder<E>
extends AbstractMutableList<E>
implements List<E>,
RandomAccess,
Serializable,
KMutableList {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private E[] backing;
    private int length;
    private boolean isReadOnly;
    @NotNull
    private static final ListBuilder Empty;

    public ListBuilder(int initialCapacity) {
        this.backing = ListBuilderKt.arrayOfUninitializedElements(initialCapacity);
    }

    public /* synthetic */ ListBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public final List<E> build() {
        this.checkIsMutable();
        this.isReadOnly = true;
        return this.length > 0 ? (List)this : (List)Empty;
    }

    private final Object writeReplace() {
        if (!this.isReadOnly) {
            throw new NotSerializableException("The list cannot be serialized while it is being built.");
        }
        return new SerializedCollection(this, 0);
    }

    @Override
    public int getSize() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public E get(int index) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.backing[index];
    }

    @Override
    public E set(int index, E element) {
        this.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        E old = this.backing[index];
        this.backing[index] = element;
        return old;
    }

    @Override
    public int indexOf(Object element) {
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (!Intrinsics.areEqual(this.backing[i2], element)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            if (!Intrinsics.areEqual(this.backing[i2], element)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        return new Itr(this, index);
    }

    @Override
    public boolean add(E element) {
        this.checkIsMutable();
        this.addAtInternal(this.length, element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        this.addAtInternal(index, element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        int n = elements.size();
        this.addAllInternal(this.length, elements, n);
        return n > 0;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        int n = elements.size();
        this.addAllInternal(index, elements, n);
        return n > 0;
    }

    @Override
    public void clear() {
        this.checkIsMutable();
        this.removeRangeInternal(0, this.length);
    }

    @Override
    public E removeAt(int index) {
        this.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.removeAtInternal(index);
    }

    @Override
    public boolean remove(Object element) {
        this.checkIsMutable();
        int i2 = this.indexOf(element);
        if (i2 >= 0) {
            this.removeAt(i2);
        }
        return i2 >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        return this.retainOrRemoveAllInternal(0, this.length, elements, false) > 0;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        return this.retainOrRemoveAllInternal(0, this.length, elements, true) > 0;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.length);
        return new BuilderSubList<E>(this.backing, fromIndex, toIndex - fromIndex, null, this);
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        if (array.length < this.length) {
            T[] TArray = Arrays.copyOfRange(this.backing, 0, this.length, array.getClass());
            Intrinsics.checkNotNullExpressionValue(TArray, "copyOfRange(...)");
            return TArray;
        }
        ArraysKt.copyInto(this.backing, array, 0, 0, this.length);
        return CollectionsKt.terminateCollectionToArray(this.length, array);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return ArraysKt.copyOfRange(this.backing, 0, this.length);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof List && this.contentEquals((List)other);
    }

    @Override
    public int hashCode() {
        return ListBuilderKt.access$subarrayContentHashCode(this.backing, 0, this.length);
    }

    @Override
    @NotNull
    public String toString() {
        return ListBuilderKt.access$subarrayContentToString(this.backing, 0, this.length, this);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    private final void checkIsMutable() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException();
        }
    }

    private final void ensureExtraCapacity(int n) {
        this.ensureCapacityInternal(this.length + n);
    }

    private final void ensureCapacityInternal(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (minCapacity > this.backing.length) {
            int newSize = AbstractList.Companion.newCapacity$kotlin_stdlib(this.backing.length, minCapacity);
            this.backing = ListBuilderKt.copyOfUninitializedElements(this.backing, newSize);
        }
    }

    private final boolean contentEquals(List<?> other) {
        return ListBuilderKt.access$subarrayContentEquals(this.backing, 0, this.length, other);
    }

    private final void insertAtInternal(int i2, int n) {
        this.ensureExtraCapacity(n);
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n2 = this.length;
        int n3 = i2 + n;
        ArraysKt.copyInto(EArray, EArray2, n3, i2, n2);
        this.length += n;
    }

    private final void addAtInternal(int i2, E element) {
        this.registerModification();
        this.insertAtInternal(i2, 1);
        this.backing[i2] = element;
    }

    private final void addAllInternal(int i2, Collection<? extends E> elements, int n) {
        this.registerModification();
        this.insertAtInternal(i2, n);
        Iterator<E> it = elements.iterator();
        for (int j = 0; j < n; ++j) {
            this.backing[i2 + j] = it.next();
        }
    }

    private final E removeAtInternal(int i2) {
        this.registerModification();
        E old = this.backing[i2];
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n = i2 + 1;
        int n2 = this.length;
        ArraysKt.copyInto(EArray, EArray2, i2, n, n2);
        ListBuilderKt.resetAt(this.backing, this.length - 1);
        int n3 = this.length;
        this.length = n3 + -1;
        return old;
    }

    private final void removeRangeInternal(int rangeOffset, int rangeLength) {
        if (rangeLength > 0) {
            this.registerModification();
        }
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n = rangeOffset + rangeLength;
        int n2 = this.length;
        ArraysKt.copyInto(EArray, EArray2, rangeOffset, n, n2);
        ListBuilderKt.resetRange(this.backing, this.length - rangeLength, this.length);
        this.length -= rangeLength;
    }

    private final int retainOrRemoveAllInternal(int rangeOffset, int rangeLength, Collection<? extends E> elements, boolean retain) {
        int i2 = 0;
        int j = 0;
        while (i2 < rangeLength) {
            if (elements.contains(this.backing[rangeOffset + i2]) == retain) {
                this.backing[rangeOffset + j++] = this.backing[rangeOffset + i2++];
                continue;
            }
            ++i2;
        }
        int removed = rangeLength - j;
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n = rangeOffset + rangeLength;
        int n2 = this.length;
        int n3 = rangeOffset + j;
        ArraysKt.copyInto(EArray, EArray2, n3, n, n2);
        ListBuilderKt.resetRange(this.backing, this.length - removed, this.length);
        if (removed > 0) {
            this.registerModification();
        }
        this.length -= removed;
        return removed;
    }

    public ListBuilder() {
        this(0, 1, null);
    }

    static {
        ListBuilder listBuilder;
        Companion = new Companion(null);
        ListBuilder it = listBuilder = new ListBuilder(0);
        boolean bl = false;
        it.isReadOnly = true;
        Empty = listBuilder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0018\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u00022\u00060\u0003j\u0002`\u00042\b\u0012\u0004\u0012\u00028\u00010\u00052\u00060\u0006j\u0002`\u0007:\u0001eBC\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001e\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ \u0010!\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010 \u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\n2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\n2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b%\u0010$J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010&H\u0096\u0002\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010)H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010)2\u0006\u0010\u001d\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b*\u0010,J\u0017\u0010-\u001a\u00020\u001a2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010-\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b-\u0010/J\u001d\u00102\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000100H\u0016\u00a2\u0006\u0004\b2\u00103J%\u00102\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000100H\u0016\u00a2\u0006\u0004\b2\u00104J\u000f\u00105\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b7\u0010\u001fJ\u0017\u00108\u001a\u00020\u001a2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b8\u0010.J\u001d\u00109\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000100H\u0016\u00a2\u0006\u0004\b9\u00103J\u001d\u0010:\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000100H\u0016\u00a2\u0006\u0004\b:\u00103J%\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b=\u0010>J)\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00020\b\"\u0004\b\u0002\u0010?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00020\bH\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010A\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\bH\u0016\u00a2\u0006\u0004\bA\u0010CJ\u001a\u0010E\u001a\u00020\u001a2\b\u0010D\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0004\bE\u0010.J\u000f\u0010F\u001a\u00020\nH\u0016\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010I\u001a\u00020HH\u0016\u00a2\u0006\u0004\bI\u0010JJ\u000f\u0010K\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\bK\u00106J\u000f\u0010L\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\bL\u00106J\u000f\u0010M\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\bM\u00106J\u001b\u0010O\u001a\u00020\u001a2\n\u0010D\u001a\u0006\u0012\u0002\b\u00030NH\u0002\u00a2\u0006\u0004\bO\u0010PJ\u001f\u0010R\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\n2\u0006\u0010 \u001a\u00028\u0001H\u0002\u00a2\u0006\u0004\bR\u0010/J-\u0010T\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u0001002\u0006\u0010S\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bT\u0010UJ\u0017\u0010V\u001a\u00028\u00012\u0006\u0010Q\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bV\u0010\u001fJ\u001f\u0010Y\u001a\u00020\u00172\u0006\u0010W\u001a\u00020\n2\u0006\u0010X\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bY\u0010ZJ5\u0010\\\u001a\u00020\n2\u0006\u0010W\u001a\u00020\n2\u0006\u0010X\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u0001002\u0006\u0010[\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\\\u0010]R\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010^R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010_R\u0016\u0010\f\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010_R\u001c\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010`R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010aR\u0014\u0010c\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010GR\u0014\u0010d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010\u001c\u00a8\u0006f"}, d2={"Lkotlin/collections/builders/ListBuilder$BuilderSubList;", "E", "", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "Lkotlin/collections/AbstractMutableList;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "", "backing", "", "offset", "length", "parent", "Lkotlin/collections/builders/ListBuilder;", "root", "<init>", "([Ljava/lang/Object;IILkotlin/collections/builders/ListBuilder$BuilderSubList;Lkotlin/collections/builders/ListBuilder;)V", "", "writeReplace", "()Ljava/lang/Object;", "Ljava/io/ObjectInputStream;", "input", "", "readObject", "(Ljava/io/ObjectInputStream;)V", "", "isEmpty", "()Z", "index", "get", "(I)Ljava/lang/Object;", "element", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "", "iterator", "()Ljava/util/Iterator;", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "add", "(Ljava/lang/Object;)Z", "(ILjava/lang/Object;)V", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "(ILjava/util/Collection;)Z", "clear", "()V", "removeAt", "remove", "removeAll", "retainAll", "fromIndex", "toIndex", "subList", "(II)Ljava/util/List;", "T", "array", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", "()[Ljava/lang/Object;", "other", "equals", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "registerModification", "checkForComodification", "checkIsMutable", "", "contentEquals", "(Ljava/util/List;)Z", "i", "addAtInternal", "n", "addAllInternal", "(ILjava/util/Collection;I)V", "removeAtInternal", "rangeOffset", "rangeLength", "removeRangeInternal", "(II)V", "retain", "retainOrRemoveAllInternal", "(IILjava/util/Collection;Z)I", "[Ljava/lang/Object;", "I", "Lkotlin/collections/builders/ListBuilder$BuilderSubList;", "Lkotlin/collections/builders/ListBuilder;", "getSize", "size", "isReadOnly", "Itr", "kotlin-stdlib"})
    public static final class BuilderSubList<E>
    extends AbstractMutableList<E>
    implements List<E>,
    RandomAccess,
    Serializable,
    KMutableList {
        @NotNull
        private E[] backing;
        private final int offset;
        private int length;
        @Nullable
        private final BuilderSubList<E> parent;
        @NotNull
        private final ListBuilder<E> root;

        public BuilderSubList(@NotNull E[] backing, int offset2, int length, @Nullable BuilderSubList<E> parent, @NotNull ListBuilder<E> root) {
            Intrinsics.checkNotNullParameter(backing, "backing");
            Intrinsics.checkNotNullParameter(root, "root");
            this.backing = backing;
            this.offset = offset2;
            this.length = length;
            this.parent = parent;
            this.root = root;
            this.modCount = ((ListBuilder)this.root).modCount;
        }

        private final Object writeReplace() {
            if (!this.isReadOnly()) {
                throw new NotSerializableException("The list cannot be serialized while it is being built.");
            }
            return new SerializedCollection(this, 0);
        }

        private final void readObject(ObjectInputStream input) {
            throw new InvalidObjectException("Deserialization is supported via proxy only");
        }

        @Override
        public int getSize() {
            this.checkForComodification();
            return this.length;
        }

        @Override
        public boolean isEmpty() {
            this.checkForComodification();
            return this.length == 0;
        }

        @Override
        public E get(int index) {
            this.checkForComodification();
            AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
            return this.backing[this.offset + index];
        }

        @Override
        public E set(int index, E element) {
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
            E old = this.backing[this.offset + index];
            this.backing[this.offset + index] = element;
            return old;
        }

        @Override
        public int indexOf(Object element) {
            this.checkForComodification();
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (!Intrinsics.areEqual(this.backing[this.offset + i2], element)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object element) {
            this.checkForComodification();
            for (int i2 = this.length - 1; i2 >= 0; --i2) {
                if (!Intrinsics.areEqual(this.backing[this.offset + i2], element)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator(int index) {
            this.checkForComodification();
            AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
            return new Itr(this, index);
        }

        @Override
        public boolean add(E element) {
            this.checkIsMutable();
            this.checkForComodification();
            this.addAtInternal(this.offset + this.length, element);
            return true;
        }

        @Override
        public void add(int index, E element) {
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
            this.addAtInternal(this.offset + index, element);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends E> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            int n = elements.size();
            this.addAllInternal(this.offset + this.length, elements, n);
            return n > 0;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
            int n = elements.size();
            this.addAllInternal(this.offset + index, elements, n);
            return n > 0;
        }

        @Override
        public void clear() {
            this.checkIsMutable();
            this.checkForComodification();
            this.removeRangeInternal(this.offset, this.length);
        }

        @Override
        public E removeAt(int index) {
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
            return this.removeAtInternal(this.offset + index);
        }

        @Override
        public boolean remove(Object element) {
            this.checkIsMutable();
            this.checkForComodification();
            int i2 = this.indexOf(element);
            if (i2 >= 0) {
                this.removeAt(i2);
            }
            return i2 >= 0;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            return this.retainOrRemoveAllInternal(this.offset, this.length, elements, false) > 0;
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            return this.retainOrRemoveAllInternal(this.offset, this.length, elements, true) > 0;
        }

        @Override
        @NotNull
        public List<E> subList(int fromIndex, int toIndex) {
            AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.length);
            return new BuilderSubList<E>(this.backing, this.offset + fromIndex, toIndex - fromIndex, this, this.root);
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] array) {
            Intrinsics.checkNotNullParameter(array, "array");
            this.checkForComodification();
            if (array.length < this.length) {
                T[] TArray = Arrays.copyOfRange(this.backing, this.offset, this.offset + this.length, array.getClass());
                Intrinsics.checkNotNullExpressionValue(TArray, "copyOfRange(...)");
                return TArray;
            }
            ArraysKt.copyInto(this.backing, array, 0, this.offset, this.offset + this.length);
            return CollectionsKt.terminateCollectionToArray(this.length, array);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            this.checkForComodification();
            return ArraysKt.copyOfRange(this.backing, this.offset, this.offset + this.length);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            this.checkForComodification();
            return other == this || other instanceof List && this.contentEquals((List)other);
        }

        @Override
        public int hashCode() {
            this.checkForComodification();
            return ListBuilderKt.access$subarrayContentHashCode(this.backing, this.offset, this.length);
        }

        @Override
        @NotNull
        public String toString() {
            this.checkForComodification();
            return ListBuilderKt.access$subarrayContentToString(this.backing, this.offset, this.length, this);
        }

        private final void registerModification() {
            ++this.modCount;
        }

        private final void checkForComodification() {
            if (((ListBuilder)this.root).modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final void checkIsMutable() {
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
        }

        private final boolean isReadOnly() {
            return ((ListBuilder)this.root).isReadOnly;
        }

        private final boolean contentEquals(List<?> other) {
            return ListBuilderKt.access$subarrayContentEquals(this.backing, this.offset, this.length, other);
        }

        private final void addAtInternal(int i2, E element) {
            this.registerModification();
            if (this.parent != null) {
                super.addAtInternal(i2, element);
            } else {
                ((ListBuilder)this.root).addAtInternal(i2, element);
            }
            this.backing = ((ListBuilder)this.root).backing;
            int n = this.length;
            this.length = n + 1;
        }

        private final void addAllInternal(int i2, Collection<? extends E> elements, int n) {
            this.registerModification();
            if (this.parent != null) {
                super.addAllInternal(i2, elements, n);
            } else {
                ((ListBuilder)this.root).addAllInternal(i2, elements, n);
            }
            this.backing = ((ListBuilder)this.root).backing;
            this.length += n;
        }

        private final E removeAtInternal(int i2) {
            this.registerModification();
            Object old = this.parent != null ? super.removeAtInternal(i2) : ((ListBuilder)this.root).removeAtInternal(i2);
            int n = this.length;
            this.length = n + -1;
            return old;
        }

        private final void removeRangeInternal(int rangeOffset, int rangeLength) {
            if (rangeLength > 0) {
                this.registerModification();
            }
            if (this.parent != null) {
                super.removeRangeInternal(rangeOffset, rangeLength);
            } else {
                ((ListBuilder)this.root).removeRangeInternal(rangeOffset, rangeLength);
            }
            this.length -= rangeLength;
        }

        private final int retainOrRemoveAllInternal(int rangeOffset, int rangeLength, Collection<? extends E> elements, boolean retain) {
            int removed;
            int n = removed = this.parent != null ? super.retainOrRemoveAllInternal(rangeOffset, rangeLength, elements, retain) : ((ListBuilder)this.root).retainOrRemoveAllInternal(rangeOffset, rangeLength, elements, retain);
            if (removed > 0) {
                this.registerModification();
            }
            this.length -= removed;
            return removed;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u00028\u00020\u0002B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\r\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00028\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00028\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00028\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001bR\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lkotlin/collections/builders/ListBuilder$BuilderSubList$Itr;", "E", "", "Lkotlin/collections/builders/ListBuilder$BuilderSubList;", "list", "", "index", "<init>", "(Lkotlin/collections/builders/ListBuilder$BuilderSubList;I)V", "", "hasPrevious", "()Z", "hasNext", "previousIndex", "()I", "nextIndex", "previous", "()Ljava/lang/Object;", "next", "element", "", "set", "(Ljava/lang/Object;)V", "add", "remove", "()V", "checkForComodification", "Lkotlin/collections/builders/ListBuilder$BuilderSubList;", "I", "lastIndex", "expectedModCount", "kotlin-stdlib"})
        @SourceDebugExtension(value={"SMAP\nListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListBuilder.kt\nkotlin/collections/builders/ListBuilder$BuilderSubList$Itr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,722:1\n1#2:723\n*E\n"})
        private static final class Itr<E>
        implements ListIterator<E>,
        KMutableListIterator {
            @NotNull
            private final BuilderSubList<E> list;
            private int index;
            private int lastIndex;
            private int expectedModCount;

            public Itr(@NotNull BuilderSubList<E> list, int index) {
                Intrinsics.checkNotNullParameter(list, "list");
                this.list = list;
                this.index = index;
                this.lastIndex = -1;
                this.expectedModCount = ((BuilderSubList)this.list).modCount;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < ((BuilderSubList)this.list).length;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public E previous() {
                this.checkForComodification();
                if (this.index <= 0) {
                    throw new NoSuchElementException();
                }
                this.index += -1;
                this.lastIndex = this.index;
                return (E)((BuilderSubList)this.list).backing[((BuilderSubList)this.list).offset + this.lastIndex];
            }

            @Override
            public E next() {
                this.checkForComodification();
                if (this.index >= ((BuilderSubList)this.list).length) {
                    throw new NoSuchElementException();
                }
                int n = this.index;
                this.index = n + 1;
                this.lastIndex = n;
                return (E)((BuilderSubList)this.list).backing[((BuilderSubList)this.list).offset + this.lastIndex];
            }

            @Override
            public void set(E element) {
                this.checkForComodification();
                if (!(this.lastIndex != -1)) {
                    boolean bl = false;
                    String string = "Call next() or previous() before replacing element from the iterator.";
                    throw new IllegalStateException(string.toString());
                }
                this.list.set(this.lastIndex, element);
            }

            @Override
            public void add(E element) {
                this.checkForComodification();
                int n = this.index;
                this.index = n + 1;
                this.list.add(n, element);
                this.lastIndex = -1;
                this.expectedModCount = ((BuilderSubList)this.list).modCount;
            }

            @Override
            public void remove() {
                this.checkForComodification();
                if (!(this.lastIndex != -1)) {
                    boolean bl = false;
                    String string = "Call next() or previous() before removing element from the iterator.";
                    throw new IllegalStateException(string.toString());
                }
                this.list.removeAt(this.lastIndex);
                this.index = this.lastIndex;
                this.lastIndex = -1;
                this.expectedModCount = ((BuilderSubList)this.list).modCount;
            }

            private final void checkForComodification() {
                if (((BuilderSubList)this.list).root.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lkotlin/collections/builders/ListBuilder$Companion;", "", "<init>", "()V", "Lkotlin/collections/builders/ListBuilder;", "", "Empty", "Lkotlin/collections/builders/ListBuilder;", "kotlin-stdlib"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\r\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001bR\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lkotlin/collections/builders/ListBuilder$Itr;", "E", "", "Lkotlin/collections/builders/ListBuilder;", "list", "", "index", "<init>", "(Lkotlin/collections/builders/ListBuilder;I)V", "", "hasPrevious", "()Z", "hasNext", "previousIndex", "()I", "nextIndex", "previous", "()Ljava/lang/Object;", "next", "element", "", "set", "(Ljava/lang/Object;)V", "add", "remove", "()V", "checkForComodification", "Lkotlin/collections/builders/ListBuilder;", "I", "lastIndex", "expectedModCount", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListBuilder.kt\nkotlin/collections/builders/ListBuilder$Itr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,722:1\n1#2:723\n*E\n"})
    private static final class Itr<E>
    implements ListIterator<E>,
    KMutableListIterator {
        @NotNull
        private final ListBuilder<E> list;
        private int index;
        private int lastIndex;
        private int expectedModCount;

        public Itr(@NotNull ListBuilder<E> list, int index) {
            Intrinsics.checkNotNullParameter(list, "list");
            this.list = list;
            this.index = index;
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ListBuilder)this.list).length;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            this.index += -1;
            this.lastIndex = this.index;
            return (E)((ListBuilder)this.list).backing[this.lastIndex];
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.index >= ((ListBuilder)this.list).length) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = n + 1;
            this.lastIndex = n;
            return (E)((ListBuilder)this.list).backing[this.lastIndex];
        }

        @Override
        public void set(E element) {
            this.checkForComodification();
            if (!(this.lastIndex != -1)) {
                boolean bl = false;
                String string = "Call next() or previous() before replacing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.set(this.lastIndex, element);
        }

        @Override
        public void add(E element) {
            this.checkForComodification();
            int n = this.index;
            this.index = n + 1;
            this.list.add(n, element);
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (!(this.lastIndex != -1)) {
                boolean bl = false;
                String string = "Call next() or previous() before removing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.removeAt(this.lastIndex);
            this.index = this.lastIndex;
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        private final void checkForComodification() {
            if (((ListBuilder)this.list).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

