/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.config.plugins.PluginType;

public class Node {
    private final Node parent;
    private final String name;
    private String value;
    private final PluginType<?> type;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<Node> children = new ArrayList<Node>();
    private Object object;

    public Node(Node parent, String name, PluginType<?> type2) {
        this.parent = parent;
        this.name = name;
        this.type = type2;
    }

    public Node() {
        this.parent = null;
        this.name = null;
        this.type = null;
    }

    public Node(Node node2) {
        this.parent = node2.parent;
        this.name = node2.name;
        this.type = node2.type;
        this.attributes.putAll(node2.getAttributes());
        this.value = node2.getValue();
        for (Node child : node2.getChildren()) {
            this.children.add(new Node(child));
        }
        this.object = node2.object;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setObject(Object obj) {
        this.object = obj;
    }

    public Object getObject() {
        return this.object;
    }

    public PluginType<?> getType() {
        return this.type;
    }

    public String toString() {
        if (this.object == null) {
            return "null";
        }
        return this.type.isObjectPrintable() ? this.object.toString() : this.type.getPluginClass().getName() + " with name " + this.name;
    }
}

