/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.callback;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.points.BeforeReturn;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.Locals;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

public class CallbackInjector
extends Injector {
    private final boolean cancellable;
    private final LocalCapture localCapture;
    private final String identifier;
    private final Map<Integer, String> ids = new HashMap<Integer, String>();
    private int totalInjections = 0;
    private int callbackInfoVar = -1;
    private String lastId;
    private String lastDesc;
    private Target lastTarget;
    private String callbackInfoClass;

    public CallbackInjector(InjectionInfo info, boolean cancellable, LocalCapture localCapture, String identifier) {
        super(info);
        this.cancellable = cancellable;
        this.localCapture = localCapture;
        this.identifier = identifier;
    }

    @Override
    protected void sanityCheck(Target target, List<InjectionPoint> injectionPoints) {
        super.sanityCheck(target, injectionPoints);
        if (target.isStatic != this.isStatic) {
            throw new InvalidInjectionException(this.info, "'static' modifier of callback method does not match target in " + this);
        }
        if ("<init>".equals(target.method.name)) {
            for (InjectionPoint injectionPoint : injectionPoints) {
                if (injectionPoint.getClass().equals(BeforeReturn.class)) continue;
                throw new InvalidInjectionException(this.info, "Found injection point type " + injectionPoint.getClass().getSimpleName() + " targetting a ctor in " + this + ". Only RETURN allowed for a ctor target");
            }
        }
    }

    @Override
    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> myNodes, AbstractInsnNode node2, Set<InjectionPoint> nominators) {
        InjectionNodes.InjectionNode injectionNode = target.addInjectionNode(node2);
        for (InjectionPoint ip : nominators) {
            String id2 = ip.getId();
            if (Strings.isNullOrEmpty((String)id2)) continue;
            String existingId = this.ids.get(injectionNode.getId());
            if (existingId != null && !existingId.equals(id2)) {
                Injector.logger.warn("Conflicting id for {} insn in {}, found id {} on {}, previously defined as {}", Bytecode.getOpcodeName(node2), target.toString(), id2, this.info, existingId);
                break;
            }
            this.ids.put(injectionNode.getId(), id2);
        }
        myNodes.add(injectionNode);
        ++this.totalInjections;
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode node2) {
        LocalVariableNode[] locals = null;
        if (this.localCapture.isCaptureLocals() || this.localCapture.isPrintLocals()) {
            locals = Locals.getLocalsAt(this.classNode, target.method, node2.getCurrentTarget());
        }
        this.inject(new Callback(this.methodNode, target, node2, locals, this.localCapture.isCaptureLocals()));
    }

    private void inject(Callback callback2) {
        if (this.localCapture.isPrintLocals()) {
            this.printLocals(callback2);
            this.info.addCallbackInvocation(this.methodNode);
            return;
        }
        MethodNode callbackMethod = this.methodNode;
        if (!callback2.checkDescriptor(this.methodNode.desc)) {
            if (this.info.getTargets().size() > 1) {
                return;
            }
            if (callback2.canCaptureLocals) {
                MethodNode surrogateHandler = Bytecode.findMethod(this.classNode, this.methodNode.name, callback2.getDescriptor());
                if (surrogateHandler != null && Annotations.getVisible(surrogateHandler, Surrogate.class) != null) {
                    callbackMethod = surrogateHandler;
                } else {
                    String message = this.generateBadLVTMessage(callback2);
                    switch (this.localCapture) {
                        case CAPTURE_FAILEXCEPTION: {
                            Injector.logger.error("Injection error: {}", message);
                            callbackMethod = this.generateErrorMethod(callback2, "org/spongepowered/asm/mixin/injection/throwables/InjectionError", message);
                            break;
                        }
                        case CAPTURE_FAILSOFT: {
                            Injector.logger.warn("Injection warning: {}", message);
                            return;
                        }
                        default: {
                            Injector.logger.error("Critical injection failure: {}", message);
                            throw new InjectionError(message);
                        }
                    }
                }
            } else {
                String returnableSig = this.methodNode.desc.replace("Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;");
                if (callback2.checkDescriptor(returnableSig)) {
                    throw new InvalidInjectionException(this.info, "Invalid descriptor on " + this.info + "! CallbackInfoReturnable is required!");
                }
                MethodNode surrogateHandler = Bytecode.findMethod(this.classNode, this.methodNode.name, callback2.getDescriptor());
                if (surrogateHandler != null && Annotations.getVisible(surrogateHandler, Surrogate.class) != null) {
                    callbackMethod = surrogateHandler;
                } else {
                    throw new InvalidInjectionException(this.info, "Invalid descriptor on " + this.info + "! Expected " + callback2.getDescriptor() + " but found " + this.methodNode.desc);
                }
            }
        }
        this.dupReturnValue(callback2);
        if (this.cancellable || this.totalInjections > 1) {
            this.createCallbackInfo(callback2, true);
        }
        this.invokeCallback(callback2, callbackMethod);
        this.injectCancellationCode(callback2);
        callback2.inject();
        this.info.notifyInjected(callback2.target);
    }

    private String generateBadLVTMessage(Callback callback2) {
        int position = callback2.target.indexOf(callback2.node);
        List<String> expected = CallbackInjector.summariseLocals(this.methodNode.desc, callback2.target.arguments.length + 1);
        List<String> found = CallbackInjector.summariseLocals(callback2.getDescriptorWithAllLocals(), callback2.frameSize);
        return String.format("LVT in %s has incompatible changes at opcode %d in callback %s.\nExpected: %s\n   Found: %s", callback2.target, position, this, expected, found);
    }

    private MethodNode generateErrorMethod(Callback callback2, String errorClass, String message) {
        MethodNode method = this.info.addMethod(this.methodNode.access, this.methodNode.name + "$missing", callback2.getDescriptor());
        method.maxLocals = Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(callback2.getDescriptor()), !this.isStatic);
        method.maxStack = 3;
        InsnList insns = method.instructions;
        insns.add(new TypeInsnNode(187, errorClass));
        insns.add(new InsnNode(89));
        insns.add(new LdcInsnNode(message));
        insns.add(new MethodInsnNode(183, errorClass, "<init>", "(Ljava/lang/String;)V", false));
        insns.add(new InsnNode(191));
        return method;
    }

    private void printLocals(Callback callback2) {
        Type[] args = Type.getArgumentTypes(callback2.getDescriptorWithAllLocals());
        SignaturePrinter methodSig = new SignaturePrinter(callback2.target.method, callback2.argNames);
        SignaturePrinter handlerSig = new SignaturePrinter(this.methodNode.name, callback2.target.returnType, args, callback2.argNames);
        handlerSig.setModifiers(this.methodNode);
        PrettyPrinter printer = new PrettyPrinter();
        printer.kv("Target Class", this.classNode.name.replace('/', '.'));
        printer.kv("Target Method", methodSig);
        printer.kv("Target Max LOCALS", callback2.target.getMaxLocals());
        printer.kv("Initial Frame Size", callback2.frameSize);
        printer.kv("Callback Name", this.methodNode.name);
        printer.kv("Instruction", "%s %s", callback2.node.getClass().getSimpleName(), Bytecode.getOpcodeName(callback2.node.getCurrentTarget().getOpcode()));
        printer.hr();
        if (callback2.locals.length > callback2.frameSize) {
            printer.add("  %s  %20s  %s", "LOCAL", "TYPE", "NAME");
            for (int l = 0; l < callback2.locals.length; ++l) {
                String marker;
                String string = marker = l == callback2.frameSize ? ">" : " ";
                if (callback2.locals[l] != null) {
                    printer.add("%s [%3d]  %20s  %-50s %s", marker, l, SignaturePrinter.getTypeName(callback2.localTypes[l], false), CallbackInjector.meltSnowman(l, callback2.locals[l].name), l >= callback2.frameSize ? "<capture>" : "");
                    continue;
                }
                boolean isTop = l > 0 && callback2.localTypes[l - 1] != null && callback2.localTypes[l - 1].getSize() > 1;
                printer.add("%s [%3d]  %20s", marker, l, isTop ? "<top>" : "-");
            }
            printer.hr();
        }
        printer.add().add("/**").add(" * Expected callback signature").add(" * /");
        printer.add("%s {", handlerSig);
        printer.add("    // Method body").add("}").add().print(System.err);
    }

    private void createCallbackInfo(Callback callback2, boolean store) {
        if (callback2.target != this.lastTarget) {
            this.lastId = null;
            this.lastDesc = null;
        }
        this.lastTarget = callback2.target;
        String id2 = this.getIdentifier(callback2);
        String desc = callback2.getCallbackInfoConstructorDescriptor();
        if (id2.equals(this.lastId) && desc.equals(this.lastDesc) && !callback2.isAtReturn && !this.cancellable) {
            return;
        }
        this.instanceCallbackInfo(callback2, id2, desc, store);
    }

    private void loadOrCreateCallbackInfo(Callback callback2) {
        if (this.cancellable || this.totalInjections > 1) {
            callback2.add(new VarInsnNode(25, this.callbackInfoVar), false, true);
        } else {
            this.createCallbackInfo(callback2, false);
        }
    }

    private void dupReturnValue(Callback callback2) {
        if (!callback2.isAtReturn) {
            return;
        }
        callback2.add(new InsnNode(89));
        callback2.add(new VarInsnNode(callback2.target.returnType.getOpcode(54), callback2.marshalVar()));
    }

    protected void instanceCallbackInfo(Callback callback2, String id2, String desc, boolean store) {
        this.lastId = id2;
        this.lastDesc = desc;
        this.callbackInfoVar = callback2.marshalVar();
        this.callbackInfoClass = callback2.target.getCallbackInfoClass();
        boolean head = store && this.totalInjections > 1 && !callback2.isAtReturn && !this.cancellable;
        callback2.add(new TypeInsnNode(187, this.callbackInfoClass), true, !store, head);
        callback2.add(new InsnNode(89), true, true, head);
        callback2.add(new LdcInsnNode(id2), true, !store, head);
        callback2.add(new InsnNode(this.cancellable ? 4 : 3), true, !store, head);
        if (callback2.isAtReturn) {
            callback2.add(new VarInsnNode(callback2.target.returnType.getOpcode(21), callback2.marshalVar()), true, !store);
            callback2.add(new MethodInsnNode(183, this.callbackInfoClass, "<init>", desc, false));
        } else {
            callback2.add(new MethodInsnNode(183, this.callbackInfoClass, "<init>", desc, false), false, false, head);
        }
        if (store) {
            callback2.target.addLocalVariable(this.callbackInfoVar, "callbackInfo" + this.callbackInfoVar, "L" + this.callbackInfoClass + ";");
            callback2.add(new VarInsnNode(58, this.callbackInfoVar), false, false, head);
        }
    }

    private void invokeCallback(Callback callback2, MethodNode callbackMethod) {
        if (!this.isStatic) {
            callback2.add(new VarInsnNode(25, 0), false, true);
        }
        if (callback2.captureArgs()) {
            Bytecode.loadArgs(callback2.target.arguments, callback2, this.isStatic ? 0 : 1, -1);
        }
        this.loadOrCreateCallbackInfo(callback2);
        if (callback2.canCaptureLocals) {
            Locals.loadLocals(callback2.localTypes, callback2, callback2.frameSize, callback2.extraArgs);
        }
        this.invokeHandler(callback2, callbackMethod);
    }

    private String getIdentifier(Callback callback2) {
        String baseId = Strings.isNullOrEmpty((String)this.identifier) ? callback2.target.method.name : this.identifier;
        String locationId = this.ids.get(callback2.node.getId());
        return baseId + (Strings.isNullOrEmpty((String)locationId) ? "" : ":" + locationId);
    }

    protected void injectCancellationCode(Callback callback2) {
        if (!this.cancellable) {
            return;
        }
        callback2.add(new VarInsnNode(25, this.callbackInfoVar));
        callback2.add(new MethodInsnNode(182, this.callbackInfoClass, CallbackInfo.getIsCancelledMethodName(), CallbackInfo.getIsCancelledMethodSig(), false));
        LabelNode notCancelled = new LabelNode();
        callback2.add(new JumpInsnNode(153, notCancelled));
        this.injectReturnCode(callback2);
        callback2.add(notCancelled);
    }

    protected void injectReturnCode(Callback callback2) {
        if (callback2.target.returnType.equals(Type.VOID_TYPE)) {
            callback2.add(new InsnNode(177));
        } else {
            callback2.add(new VarInsnNode(25, callback2.marshalVar()));
            String accessor = CallbackInfoReturnable.getReturnAccessor(callback2.target.returnType);
            String descriptor = CallbackInfoReturnable.getReturnDescriptor(callback2.target.returnType);
            callback2.add(new MethodInsnNode(182, this.callbackInfoClass, accessor, descriptor, false));
            if (callback2.target.returnType.getSort() == 10) {
                callback2.add(new TypeInsnNode(192, callback2.target.returnType.getInternalName()));
            }
            callback2.add(new InsnNode(callback2.target.returnType.getOpcode(172)));
        }
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    private static List<String> summariseLocals(String desc, int pos) {
        return CallbackInjector.summariseLocals(Type.getArgumentTypes(desc), pos);
    }

    private static List<String> summariseLocals(Type[] locals, int pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (locals != null) {
            while (pos < locals.length) {
                if (locals[pos] != null) {
                    list.add(locals[pos].toString());
                }
                ++pos;
            }
        }
        return list;
    }

    static String meltSnowman(int index, String varName) {
        return varName != null && '\u2603' == varName.charAt(0) ? "var" + index : varName;
    }

    private class Callback
    extends InsnList {
        private final MethodNode handler;
        private final AbstractInsnNode head;
        final Target target;
        final InjectionNodes.InjectionNode node;
        final LocalVariableNode[] locals;
        final Type[] localTypes;
        final int frameSize;
        final int extraArgs;
        final boolean canCaptureLocals;
        final boolean isAtReturn;
        final String desc;
        final String descl;
        final String[] argNames;
        int ctor;
        int invoke;
        private int marshalVar = -1;
        private boolean captureArgs = true;

        Callback(MethodNode handler, Target target, InjectionNodes.InjectionNode node2, LocalVariableNode[] locals, boolean captureLocals) {
            this.handler = handler;
            this.target = target;
            this.head = target.insns.getFirst();
            this.node = node2;
            this.locals = locals;
            this.localTypes = locals != null ? new Type[locals.length] : null;
            this.frameSize = Bytecode.getFirstNonArgLocalIndex(target.arguments, !CallbackInjector.this.isStatic());
            ArrayList<String> argNames = null;
            if (locals != null) {
                int baseArgIndex = CallbackInjector.this.isStatic() ? 0 : 1;
                argNames = new ArrayList<String>();
                for (int l = 0; l <= locals.length; ++l) {
                    if (l == this.frameSize) {
                        argNames.add(target.returnType == Type.VOID_TYPE ? "ci" : "cir");
                    }
                    if (l >= locals.length || locals[l] == null) continue;
                    this.localTypes[l] = Type.getType(locals[l].desc);
                    if (l < baseArgIndex) continue;
                    argNames.add(CallbackInjector.meltSnowman(l, locals[l].name));
                }
            }
            this.extraArgs = Math.max(0, Bytecode.getFirstNonArgLocalIndex(this.handler) - (this.frameSize + 1));
            this.argNames = argNames != null ? argNames.toArray(new String[argNames.size()]) : null;
            this.canCaptureLocals = captureLocals && locals != null && locals.length > this.frameSize;
            this.isAtReturn = this.node.getCurrentTarget() instanceof InsnNode && this.isValueReturnOpcode(this.node.getCurrentTarget().getOpcode());
            this.desc = target.getCallbackDescriptor(this.localTypes, target.arguments);
            this.descl = target.getCallbackDescriptor(true, this.localTypes, target.arguments, this.frameSize, this.extraArgs);
            this.invoke = target.arguments.length + (this.canCaptureLocals ? this.localTypes.length - this.frameSize : 0);
        }

        private boolean isValueReturnOpcode(int opcode) {
            return opcode >= 172 && opcode < 177;
        }

        String getDescriptor() {
            return this.canCaptureLocals ? this.descl : this.desc;
        }

        String getDescriptorWithAllLocals() {
            return this.target.getCallbackDescriptor(true, this.localTypes, this.target.arguments, this.frameSize, Short.MAX_VALUE);
        }

        String getCallbackInfoConstructorDescriptor() {
            return this.isAtReturn ? CallbackInfo.getConstructorDescriptor(this.target.returnType) : CallbackInfo.getConstructorDescriptor();
        }

        void add(AbstractInsnNode insn, boolean ctorStack, boolean invokeStack) {
            this.add(insn, ctorStack, invokeStack, false);
        }

        void add(AbstractInsnNode insn, boolean ctorStack, boolean invokeStack, boolean head) {
            if (head) {
                this.target.insns.insertBefore(this.head, insn);
            } else {
                this.add(insn);
            }
            this.ctor += ctorStack ? 1 : 0;
            this.invoke += invokeStack ? 1 : 0;
        }

        void inject() {
            this.target.insertBefore(this.node, (InsnList)this);
            this.target.addToStack(Math.max(this.invoke, this.ctor));
        }

        boolean checkDescriptor(String desc) {
            Type[] myTypes;
            if (this.getDescriptor().equals(desc)) {
                return true;
            }
            if (this.target.getSimpleCallbackDescriptor().equals(desc) && !this.canCaptureLocals) {
                this.captureArgs = false;
                return true;
            }
            Type[] inTypes = Type.getArgumentTypes(desc);
            if (inTypes.length != (myTypes = Type.getArgumentTypes(this.descl)).length) {
                return false;
            }
            for (int arg = 0; arg < myTypes.length; ++arg) {
                Type type2 = inTypes[arg];
                if (type2.equals(myTypes[arg])) continue;
                if (type2.getSort() == 9) {
                    return false;
                }
                if (Annotations.getInvisibleParameter(this.handler, Coerce.class, arg) == null) {
                    return false;
                }
                if (Injector.canCoerce(inTypes[arg], myTypes[arg])) continue;
                return false;
            }
            return true;
        }

        boolean captureArgs() {
            return this.captureArgs;
        }

        int marshalVar() {
            if (this.marshalVar < 0) {
                this.marshalVar = this.target.allocateLocal();
            }
            return this.marshalVar;
        }
    }
}

