/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.input;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.settings.GameSettings;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.input.KnitInputCode;
import xyz.meowing.knit.api.input.KnitKey;
import xyz.meowing.knit.api.input.KnitKeyboard;
import xyz.meowing.knit.api.input.KnitMouse;
import xyz.meowing.knit.api.input.KnitMouseButton;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/meowing/knit/api/input/KnitInputs;", "", "<init>", "()V", "", "code", "Lxyz/meowing/knit/api/input/KnitInputCode;", "get", "(I)Lxyz/meowing/knit/api/input/KnitInputCode;", "scanCode", "", "getDisplayName", "(II)Ljava/lang/String;", "Knit"})
public final class KnitInputs {
    @NotNull
    public static final KnitInputs INSTANCE = new KnitInputs();

    private KnitInputs() {
    }

    @NotNull
    public final KnitInputCode get(int code) {
        KnitInputCode knitInputCode;
        if (KnitKeyboard.isKeyboardButton(code)) {
            knitInputCode = new KnitKey(code);
        } else if (KnitMouse.INSTANCE.isMouseButton(code)) {
            knitInputCode = new KnitMouseButton(code);
        } else {
            throw new IllegalArgumentException("Code " + code + " is not a valid key or mouse button");
        }
        return knitInputCode;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getDisplayName(int code, int scanCode) {
        String string = GameSettings.func_74298_c((int)code);
        if (string == null) {
            return "Unknown";
        }
        String name = string;
        if (name.length() == 1) {
            String string2 = name.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            return string2;
        }
        return name;
    }

    public static /* synthetic */ String getDisplayName$default(int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return KnitInputs.getDisplayName(n, n2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getDisplayName(int code) {
        return KnitInputs.getDisplayName$default(code, 0, 2, null);
    }
}

