/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.text;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.text.core.FormattingCodes;
import xyz.meowing.knit.api.text.internal.ChainBuilder;
import xyz.meowing.knit.api.text.internal.TextBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000e\u0010\bJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lxyz/meowing/knit/api/text/KnitText;", "", "<init>", "()V", "", "text", "Lxyz/meowing/knit/api/text/internal/TextBuilder;", "literal", "(Ljava/lang/String;)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "empty", "()Lxyz/meowing/knit/api/text/internal/TextBuilder;", "Lnet/minecraft/util/IChatComponent;", "fromVanilla", "(Lnet/minecraft/util/IChatComponent;)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "fromFormatted", "Lxyz/meowing/knit/api/text/internal/ChainBuilder;", "builder", "()Lxyz/meowing/knit/api/text/internal/ChainBuilder;", "Knit"})
@SourceDebugExtension(value={"SMAP\nKnitText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnitText.kt\nxyz/meowing/knit/api/text/KnitText\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class KnitText {
    @NotNull
    public static final KnitText INSTANCE = new KnitText();

    private KnitText() {
    }

    @JvmStatic
    @NotNull
    public static final TextBuilder literal(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return new TextBuilder(text);
    }

    @JvmStatic
    @NotNull
    public static final TextBuilder empty() {
        return new TextBuilder("");
    }

    @JvmStatic
    @NotNull
    public static final TextBuilder fromVanilla(@NotNull IChatComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        TextBuilder builder = new TextBuilder("");
        builder.setVanilla$Knit(text);
        return builder;
    }

    @JvmStatic
    @NotNull
    public static final TextBuilder fromFormatted(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        char[] cArray = new char[]{'\u00a7'};
        List parts = StringsKt.split$default((CharSequence)text, cArray, false, 0, 6, null);
        if (parts.size() <= 1) {
            return KnitText.literal(text);
        }
        TextBuilder root = INSTANCE.empty();
        TextBuilder current = null;
        current = KnitText.literal("");
        int n = ((Collection)parts).size();
        for (int i2 = 0; i2 < n; ++i2) {
            char c;
            String content;
            String part;
            block19: {
                char code;
                block18: {
                    String string;
                    if (i2 == 0 && ((CharSequence)parts.get(i2)).length() > 0) {
                        root.append(KnitText.literal((String)parts.get(i2)));
                        continue;
                    }
                    part = (String)parts.get(i2);
                    if (((CharSequence)part).length() == 0) continue;
                    code = Character.toLowerCase(part.charAt(0));
                    if (part.length() > 1) {
                        String string2 = part;
                        int n2 = 1;
                        String string3 = string2.substring(n2);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    } else {
                        string = "";
                    }
                    content = string;
                    c = code;
                    if ('0' <= c ? c < ':' : false) break block18;
                    boolean bl = 'a' <= c ? c < 'g' : false;
                    if (!bl) break block19;
                }
                if (((CharSequence)current.getText$Knit()).length() > 0) {
                    root.append(current);
                }
                current = KnitText.literal(content);
                Integer n3 = FormattingCodes.codeToColor(code);
                if (n3 != null) {
                    int it = ((Number)n3).intValue();
                    boolean bl = false;
                    current.color(it);
                }
                continue;
            }
            if (c == 'r') {
                if (((CharSequence)current.getText$Knit()).length() > 0) {
                    root.append(current);
                }
                current = KnitText.literal(content);
                continue;
            }
            if (c == 'l') {
                TextBuilder.bold$default(current, false, 1, null);
                TextBuilder textBuilder = current;
                textBuilder.setText$Knit(textBuilder.getText$Knit() + content);
                continue;
            }
            if (c == 'o') {
                TextBuilder.italic$default(current, false, 1, null);
                TextBuilder textBuilder = current;
                textBuilder.setText$Knit(textBuilder.getText$Knit() + content);
                continue;
            }
            if (c == 'n') {
                TextBuilder.underlined$default(current, false, 1, null);
                TextBuilder textBuilder = current;
                textBuilder.setText$Knit(textBuilder.getText$Knit() + content);
                continue;
            }
            if (c == 'm') {
                TextBuilder.strikethrough$default(current, false, 1, null);
                TextBuilder textBuilder = current;
                textBuilder.setText$Knit(textBuilder.getText$Knit() + content);
                continue;
            }
            if (c == 'k') {
                TextBuilder.obfuscated$default(current, false, 1, null);
                TextBuilder textBuilder = current;
                textBuilder.setText$Knit(textBuilder.getText$Knit() + content);
                continue;
            }
            TextBuilder textBuilder = current;
            char c2 = '\u00a7';
            textBuilder.setText$Knit(textBuilder.getText$Knit() + (c2 + part));
        }
        if (((CharSequence)current.getText$Knit()).length() > 0) {
            root.append(current);
        }
        return root;
    }

    @JvmStatic
    @NotNull
    public static final ChainBuilder builder() {
        return new ChainBuilder();
    }
}

