/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.text.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lxyz/meowing/knit/api/text/internal/ColorMapper;", "", "<init>", "()V", "", "rgb", "Lnet/minecraft/util/EnumChatFormatting;", "findNearest", "(I)Lnet/minecraft/util/EnumChatFormatting;", "", "Lxyz/meowing/knit/api/text/internal/ColorMapper$ColorEntry;", "COLORS", "Ljava/util/List;", "ColorEntry", "Knit"})
public final class ColorMapper {
    @NotNull
    public static final ColorMapper INSTANCE = new ColorMapper();
    @NotNull
    private static final List<ColorEntry> COLORS;

    private ColorMapper() {
    }

    @NotNull
    public final EnumChatFormatting findNearest(int rgb) {
        Object object = CollectionsKt.last(COLORS).getFormatting();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.util.EnumChatFormatting");
        EnumChatFormatting nearest = (EnumChatFormatting)object;
        double minDistance = Double.MAX_VALUE;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        for (ColorEntry entry : COLORS) {
            int fr = entry.getValue() >> 16 & 0xFF;
            int fg = entry.getValue() >> 8 & 0xFF;
            int fb = entry.getValue() & 0xFF;
            double distance = Math.sqrt((r - fr) * (r - fr) + (g - fg) * (g - fg) + (b - fb) * (b - fb));
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            Object object2 = entry.getFormatting();
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type net.minecraft.util.EnumChatFormatting");
            nearest = (EnumChatFormatting)object2;
        }
        return nearest;
    }

    static {
        ColorEntry[] colorEntryArray = new ColorEntry[]{new ColorEntry("BLACK", 0, EnumChatFormatting.BLACK), new ColorEntry("DARK_BLUE", 170, EnumChatFormatting.DARK_BLUE), new ColorEntry("DARK_GREEN", 43520, EnumChatFormatting.DARK_GREEN), new ColorEntry("DARK_AQUA", 43690, EnumChatFormatting.DARK_AQUA), new ColorEntry("DARK_RED", 0xAA0000, EnumChatFormatting.DARK_RED), new ColorEntry("DARK_PURPLE", 0xAA00AA, EnumChatFormatting.DARK_PURPLE), new ColorEntry("GOLD", 0xFFAA00, EnumChatFormatting.GOLD), new ColorEntry("GRAY", 0xAAAAAA, EnumChatFormatting.GRAY), new ColorEntry("DARK_GRAY", 0x555555, EnumChatFormatting.DARK_GRAY), new ColorEntry("BLUE", 0x5555FF, EnumChatFormatting.BLUE), new ColorEntry("GREEN", 0x55FF55, EnumChatFormatting.GREEN), new ColorEntry("AQUA", 0x55FFFF, EnumChatFormatting.AQUA), new ColorEntry("RED", 0xFF5555, EnumChatFormatting.RED), new ColorEntry("LIGHT_PURPLE", 0xFF55FF, EnumChatFormatting.LIGHT_PURPLE), new ColorEntry("YELLOW", 0xFFFF55, EnumChatFormatting.YELLOW), new ColorEntry("WHITE", 0xFFFFFF, EnumChatFormatting.WHITE)};
        COLORS = CollectionsKt.listOf(colorEntryArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ.\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lxyz/meowing/knit/api/text/internal/ColorMapper$ColorEntry;", "", "", "name", "", "value", "formatting", "<init>", "(Ljava/lang/String;ILjava/lang/Object;)V", "component1", "()Ljava/lang/String;", "component2", "()I", "component3", "()Ljava/lang/Object;", "copy", "(Ljava/lang/String;ILjava/lang/Object;)Lxyz/meowing/knit/api/text/internal/ColorMapper$ColorEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "I", "getValue", "Ljava/lang/Object;", "getFormatting", "Knit"})
    private static final class ColorEntry {
        @NotNull
        private final String name;
        private final int value;
        @NotNull
        private final Object formatting;

        public ColorEntry(@NotNull String name, int value, @NotNull Object formatting) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(formatting, "formatting");
            this.name = name;
            this.value = value;
            this.formatting = formatting;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getValue() {
            return this.value;
        }

        @NotNull
        public final Object getFormatting() {
            return this.formatting;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.value;
        }

        @NotNull
        public final Object component3() {
            return this.formatting;
        }

        @NotNull
        public final ColorEntry copy(@NotNull String name, int value, @NotNull Object formatting) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(formatting, "formatting");
            return new ColorEntry(name, value, formatting);
        }

        public static /* synthetic */ ColorEntry copy$default(ColorEntry colorEntry, String string, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                string = colorEntry.name;
            }
            if ((n2 & 2) != 0) {
                n = colorEntry.value;
            }
            if ((n2 & 4) != 0) {
                object = colorEntry.formatting;
            }
            return colorEntry.copy(string, n, object);
        }

        @NotNull
        public String toString() {
            return "ColorEntry(name=" + this.name + ", value=" + this.value + ", formatting=" + this.formatting + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.value);
            result = result * 31 + this.formatting.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorEntry)) {
                return false;
            }
            ColorEntry colorEntry = (ColorEntry)other;
            if (!Intrinsics.areEqual(this.name, colorEntry.name)) {
                return false;
            }
            if (this.value != colorEntry.value) {
                return false;
            }
            return Intrinsics.areEqual(this.formatting, colorEntry.formatting);
        }
    }
}

