/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u00020\u0006*\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\bJ\u0011\u0010\u000e\u001a\u00020\u0006*\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\bJ\u001b\u0010\u0011\u001a\u00020\u0006*\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0016\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0016\u001a\u00020\u0006*\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0019J\u0019\u0010\u0016\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u001aJ\u0011\u0010\u001b\u001a\u00020\u0006*\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\bJ\u0011\u0010\u001c\u001a\u00020\u0006*\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\bJ!\u0010\u001f\u001a\u00020\u0013*\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010\"\u001a\u00020\u0013*\u00020\u00042\u0006\u0010!\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010#J\u001c\u0010%\u001a\u00020\u0013*\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b%\u0010#J\u001c\u0010&\u001a\u00020\u0013*\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b&\u0010#J\u001c\u0010'\u001a\u00020\u0013*\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b'\u0010#J\u001c\u0010(\u001a\u00020\u0013*\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b(\u0010#R \u0010*\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R0\u0010-\u001a\u001e\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00060\u00060)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010+\u00a8\u0006."}, d2={"Lxyz/meowing/knit/api/utils/NumberUtils;", "", "<init>", "()V", "", "value", "", "format", "(Ljava/lang/Number;)Ljava/lang/String;", "(Ljava/lang/String;)Ljava/lang/String;", "", "unformat", "(Ljava/lang/String;)J", "abbreviate", "formatWithCommas", "", "short", "toDuration", "(JZ)Ljava/lang/String;", "", "", "precision", "toFixed", "(DI)Ljava/lang/String;", "", "(FI)Ljava/lang/String;", "(Ljava/lang/String;I)Ljava/lang/String;", "addSuffix", "toRoman", "min", "max", "clamp", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)D", "total", "percentage", "(Ljava/lang/Number;Ljava/lang/Number;)D", "number", "div", "times", "minus", "plus", "Ljava/util/TreeMap;", "suffixes", "Ljava/util/TreeMap;", "kotlin.jvm.PlatformType", "romanSymbols", "Knit"})
@SourceDebugExtension(value={"SMAP\nNumberUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberUtils.kt\nxyz/meowing/knit/api/utils/NumberUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n434#2:179\n507#2,5:180\n434#2:185\n507#2,5:186\n434#2:191\n507#2,5:192\n1#3:197\n*S KotlinDebug\n*F\n+ 1 NumberUtils.kt\nxyz/meowing/knit/api/utils/NumberUtils\n*L\n54#1:179\n54#1:180,5\n58#1:185\n58#1:186,5\n59#1:191\n59#1:192,5\n*E\n"})
public final class NumberUtils {
    @NotNull
    public static final NumberUtils INSTANCE;
    @NotNull
    private static final TreeMap<Long, String> suffixes;
    @NotNull
    private static final TreeMap<Integer, String> romanSymbols;

    private NumberUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull Number value) {
        Intrinsics.checkNotNullParameter(value, "value");
        long longValue = value.longValue();
        if (longValue == Long.MIN_VALUE) {
            return NumberUtils.format(-9223372036854775807L);
        }
        if (longValue < 0L) {
            return '-' + NumberUtils.format(-longValue);
        }
        if (longValue < 1000L) {
            return String.valueOf(longValue);
        }
        Map.Entry<Long, String> entry = suffixes.floorEntry(longValue);
        Intrinsics.checkNotNull(entry);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = longValue / (divideBy / (long)10);
        boolean hasDecimal = truncated < 100L && !((double)truncated / 10.0 == (double)(truncated / (long)10));
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / (long)10 + suffix;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String format(@NotNull String value) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(value, "value");
        String $this$filter$iv = value;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return NumberUtils.format(Long.parseLong(((StringBuilder)destination$iv$iv).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final long unformat(@NotNull String value) {
        Object v5;
        long l;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(value, "value");
            String $this$filter$iv = value;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv2.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                if (!(!Character.isDigit(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String suffix = string;
            String $this$filter$iv2 = value;
            boolean $i$f$filter2 = false;
            CharSequence index$iv$iv = $this$filter$iv2;
            Appendable destination$iv$iv2 = new StringBuilder();
            boolean $i$f$filterTo2 = false;
            int n2 = $this$filterTo$iv$iv.length();
            for (int index$iv$iv2 = 0; index$iv$iv2 < n2; ++index$iv$iv2) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                if (!Character.isDigit(it)) continue;
                destination$iv$iv2.append(element$iv$iv);
            }
            Long l2 = StringsKt.toLongOrNull(((StringBuilder)destination$iv$iv2).toString());
            long num = l2 != null ? l2 : 0L;
            Set<Map.Entry<Long, String>> set = suffixes.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
            Iterable iterable = set;
            l = num;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
                String string2 = ((String)v).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (!Intrinsics.areEqual(string2, suffix)) continue;
                v5 = t;
                break block3;
            }
            v5 = null;
        }
        Object var17_21 = v5;
        Object object = var17_21;
        return l * (object != null && (object = (Long)object.getKey()) != null ? (Long)object : 1L);
    }

    @NotNull
    public final String abbreviate(@NotNull Number $this$abbreviate) {
        String string;
        Pair<Double, String> pair;
        Intrinsics.checkNotNullParameter($this$abbreviate, "<this>");
        double num = Math.abs($this$abbreviate.doubleValue());
        String sign = $this$abbreviate.doubleValue() < 0.0 ? "-" : "";
        if (num >= 1.0E12) {
            pair = TuplesKt.to(1.0E12, "T");
        } else if (num >= 1.0E9) {
            pair = TuplesKt.to(1.0E9, "B");
        } else if (num >= 1000000.0) {
            pair = TuplesKt.to(1000000.0, "M");
        } else if (num >= 1000.0) {
            pair = TuplesKt.to(1000.0, "k");
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(sign);
            String string2 = "%.0f";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{num};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            return stringBuilder.append(string3).toString();
        }
        Pair<Double, String> pair2 = pair;
        double divisor = ((Number)pair2.component1()).doubleValue();
        String suffix = pair2.component2();
        double value = num / divisor;
        if (value % 1.0 == 0.0) {
            string = String.valueOf((int)value);
        } else {
            String string4 = "%.1f";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{value};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
            String decimal = string5;
            string = StringsKt.endsWith$default(decimal, ".0", false, 2, null) ? StringsKt.dropLast(decimal, 2) : decimal;
        }
        String formatted = string;
        return sign + formatted + suffix;
    }

    @NotNull
    public final String formatWithCommas(@NotNull Number $this$formatWithCommas) {
        Intrinsics.checkNotNullParameter($this$formatWithCommas, "<this>");
        String string = "%,.0f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{$this$formatWithCommas.doubleValue()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String toDuration(long $this$toDuration, boolean bl) {
        StringBuilder stringBuilder;
        long seconds = $this$toDuration / (long)1000;
        long days = seconds / (long)86400;
        long hours = seconds % (long)86400 / (long)3600;
        long minutes = seconds % (long)3600 / (long)60;
        long remainingSeconds = seconds % (long)60;
        if (bl) {
            return days > 0L ? "" + days + 'd' : (hours > 0L ? "" + hours + 'h' : (minutes > 0L ? "" + minutes + 'm' : "" + remainingSeconds + 's'));
        }
        StringBuilder $this$toDuration_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        if (days > 0L) {
            $this$toDuration_u24lambda_u245.append(days + "d ");
        }
        if (hours > 0L) {
            $this$toDuration_u24lambda_u245.append(hours + "h ");
        }
        if (minutes > 0L) {
            $this$toDuration_u24lambda_u245.append(minutes + "m ");
        }
        if (remainingSeconds > 0L) {
            $this$toDuration_u24lambda_u245.append("" + remainingSeconds + 's');
        }
        return ((Object)StringsKt.trimEnd((CharSequence)stringBuilder.toString())).toString();
    }

    public static /* synthetic */ String toDuration$default(NumberUtils numberUtils, long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return numberUtils.toDuration(l, bl);
    }

    @NotNull
    public final String toFixed(double $this$toFixed, int precision) {
        if (Double.isNaN($this$toFixed)) {
            return String.valueOf($this$toFixed);
        }
        int scale = (int)Math.pow(10.0, precision);
        double rounded = (double)MathKt.roundToInt($this$toFixed * (double)scale) / (double)scale;
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)String.valueOf(rounded), stringArray, false, 0, 6, null);
        return parts.size() == 2 ? (String)parts.get(0) + '.' + StringsKt.padEnd((String)parts.get(1), precision, '0') : (String)parts.get(0) + '.' + StringsKt.repeat("0", precision);
    }

    @NotNull
    public final String toFixed(float $this$toFixed, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        float rounded = (float)MathKt.roundToInt($this$toFixed * (float)scale) / (float)scale;
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)String.valueOf(rounded), stringArray, false, 0, 6, null);
        return parts.size() == 2 ? (String)parts.get(0) + '.' + StringsKt.padEnd((String)parts.get(1), precision, '0') : (String)parts.get(0) + '.' + StringsKt.repeat("0", precision);
    }

    @NotNull
    public final String toFixed(@NotNull String $this$toFixed, int precision) {
        Intrinsics.checkNotNullParameter($this$toFixed, "<this>");
        Double d = StringsKt.toDoubleOrNull($this$toFixed);
        if (d == null) {
            return $this$toFixed;
        }
        double number = d;
        int scale = (int)Math.pow(10.0, precision);
        double rounded = (double)MathKt.roundToInt(number * (double)scale) / (double)scale;
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)String.valueOf(rounded), stringArray, false, 0, 6, null);
        return parts.size() == 2 ? (String)parts.get(0) + '.' + StringsKt.padEnd((String)parts.get(1), precision, '0') : (String)parts.get(0) + '.' + StringsKt.repeat("0", precision);
    }

    @NotNull
    public final String addSuffix(@NotNull Number $this$addSuffix) {
        Intrinsics.checkNotNullParameter($this$addSuffix, "<this>");
        long l = $this$addSuffix.longValue();
        boolean bl = 11L <= l ? l < 14L : false;
        if (bl) {
            return $this$addSuffix + "th";
        }
        long l2 = l % (long)10;
        return l2 == 1L ? $this$addSuffix + "st" : (l2 == 2L ? $this$addSuffix + "nd" : (l2 == 3L ? $this$addSuffix + "rd" : $this$addSuffix + "th"));
    }

    @NotNull
    public final String toRoman(@NotNull Number $this$toRoman) {
        String string;
        Intrinsics.checkNotNullParameter($this$toRoman, "<this>");
        int n = $this$toRoman.intValue();
        if (!(n > 0)) {
            boolean bl = false;
            String string2 = $this$toRoman + " must be positive!";
            throw new IllegalArgumentException(string2.toString());
        }
        Integer l = romanSymbols.floorKey(n);
        Integer n2 = l;
        if (n2 != null && n == n2) {
            String string3 = romanSymbols.get(n);
            Intrinsics.checkNotNull(string3);
            string = string3;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(romanSymbols.get(l));
            Intrinsics.checkNotNull(l);
            string = stringBuilder.append(this.toRoman(n - l)).toString();
        }
        return string;
    }

    public final double clamp(@NotNull Number $this$clamp, @NotNull Number min, @NotNull Number max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return RangesKt.coerceIn($this$clamp.doubleValue(), min.doubleValue(), max.doubleValue());
    }

    public final double percentage(@NotNull Number $this$percentage, @NotNull Number total) {
        Intrinsics.checkNotNullParameter($this$percentage, "<this>");
        Intrinsics.checkNotNullParameter(total, "total");
        return total.doubleValue() == 0.0 ? 0.0 : $this$percentage.doubleValue() / total.doubleValue() * (double)100;
    }

    public final double div(@NotNull Number $this$div, @NotNull Number number) {
        Intrinsics.checkNotNullParameter($this$div, "<this>");
        Intrinsics.checkNotNullParameter(number, "number");
        return $this$div.doubleValue() / number.doubleValue();
    }

    public final double times(@NotNull Number $this$times, @NotNull Number number) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        Intrinsics.checkNotNullParameter(number, "number");
        return $this$times.doubleValue() * number.doubleValue();
    }

    public final double minus(@NotNull Number $this$minus, @NotNull Number number) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(number, "number");
        return $this$minus.doubleValue() - number.doubleValue();
    }

    public final double plus(@NotNull Number $this$plus, @NotNull Number number) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(number, "number");
        return $this$plus.doubleValue() + number.doubleValue();
    }

    static {
        Pair[] pairArray;
        INSTANCE = new NumberUtils();
        Pair[] $this$suffixes_u24lambda_u240 = pairArray = new TreeMap();
        boolean bl = false;
        ((Map)$this$suffixes_u24lambda_u240).put(1000L, "k");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000L, "m");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000L, "b");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000L, "t");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000000L, "p");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000000000L, "e");
        suffixes = pairArray;
        pairArray = new Pair[]{TuplesKt.to(1000, "M"), TuplesKt.to(900, "CM"), TuplesKt.to(500, "D"), TuplesKt.to(400, "CD"), TuplesKt.to(100, "C"), TuplesKt.to(90, "XC"), TuplesKt.to(50, "L"), TuplesKt.to(40, "XL"), TuplesKt.to(10, "X"), TuplesKt.to(9, "IX"), TuplesKt.to(5, "V"), TuplesKt.to(4, "IV"), TuplesKt.to(1, "I")};
        romanSymbols = new TreeMap(MapsKt.mapOf(pairArray));
    }
}

