/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000b\u001a\u00020\n*\u00020\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u000e\u001a\u00020\n*\u00020\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\fJ%\u0010\u0010\u001a\u00020\n*\u00020\u00042\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\fJ%\u0010\u0011\u001a\u00020\n*\u00020\u00042\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\fJ\u0011\u0010\u0012\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0014\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0011\u0010\u0015\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0011\u0010\u0016\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0011\u0010\u0017\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0013J%\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\b\"\u00020\u001b\u00a2\u0006\u0004\b\u0019\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u0013J\u0011\u0010\u001e\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u0013J#\u0010!\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010$\u001a\u00020\u0005*\u00020\u00042\u0006\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010%J#\u0010'\u001a\u00020\u0004*\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010(J3\u0010.\u001a\u00020,*\u00020\u001b2\u0006\u0010)\u001a\u00020\u00042\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040+\u0012\u0004\u0012\u00020,0*\u00a2\u0006\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00101R\u0014\u00103\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00101R \u00106\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u0005048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00068"}, d2={"Lxyz/meowing/knit/api/utils/StringUtils;", "", "<init>", "()V", "", "", "decodeRoman", "(Ljava/lang/String;)I", "", "prefixes", "", "startsWithOneOf", "(Ljava/lang/String;[Ljava/lang/String;)Z", "suffixes", "endsWithOneOf", "values", "containsAny", "containsAll", "spaceCaps", "(Ljava/lang/String;)Ljava/lang/String;", "toKebabCase", "toSnakeCase", "toCamelCase", "toPascalCase", "patterns", "remove", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "Lkotlin/text/Regex;", "(Ljava/lang/String;[Lkotlin/text/Regex;)Ljava/lang/String;", "removeSpace", "removeWhitespace", "maxLength", "suffix", "truncate", "(Ljava/lang/String;ILjava/lang/String;)Ljava/lang/String;", "substring", "countOccurrences", "(Ljava/lang/String;Ljava/lang/String;)I", "prefix", "wrapWith", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "text", "Lkotlin/Function1;", "", "", "func", "matchAndRun", "(Lkotlin/text/Regex;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "spaceRegex", "Lkotlin/text/Regex;", "spaceCapsRegex1", "spaceCapsRegex2", "", "", "romanValues", "Ljava/util/Map;", "Knit"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\nxyz/meowing/knit/api/utils/StringUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,106:1\n12637#2,2:107\n12637#2,2:109\n12637#2,2:111\n12434#2,2:113\n12883#2,3:120\n12883#2,3:123\n1573#3:115\n1604#3,4:116\n488#4,11:126\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\nxyz/meowing/knit/api/utils/StringUtils\n*L\n32#1:107,2\n36#1:109,2\n40#1:111,2\n44#1:113,2\n73#1:120,3\n77#1:123,3\n63#1:115\n63#1:116,4\n85#1:126,11\n*E\n"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();
    @NotNull
    private static final Regex spaceRegex = new Regex("\\s");
    @NotNull
    private static final Regex spaceCapsRegex1 = new Regex("(?<=[a-z])(?=[A-Z])");
    @NotNull
    private static final Regex spaceCapsRegex2 = new Regex("(?<=[A-Z])(?=[A-Z][a-z])");
    @NotNull
    private static final Map<Character, Integer> romanValues;

    private StringUtils() {
    }

    public final int decodeRoman(@NotNull String $this$decodeRoman) {
        Intrinsics.checkNotNullParameter($this$decodeRoman, "<this>");
        int result = 0;
        int prevValue = 0;
        for (int i2 = StringsKt.getLastIndex($this$decodeRoman); -1 < i2; --i2) {
            String string = $this$decodeRoman.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            Integer n = romanValues.get(Character.valueOf(string.charAt(i2)));
            int currentValue = n != null ? n : 0;
            result += currentValue < prevValue ? -currentValue : currentValue;
            prevValue = currentValue;
        }
        return result;
    }

    public final boolean startsWithOneOf(@NotNull String $this$startsWithOneOf, String ... prefixes) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$startsWithOneOf, "<this>");
            Intrinsics.checkNotNullParameter(prefixes, "prefixes");
            String[] $this$any$iv = prefixes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default($this$startsWithOneOf, it, false, 2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean endsWithOneOf(@NotNull String $this$endsWithOneOf, String ... suffixes) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$endsWithOneOf, "<this>");
            Intrinsics.checkNotNullParameter(suffixes, "suffixes");
            String[] $this$any$iv = suffixes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!StringsKt.endsWith$default($this$endsWithOneOf, it, false, 2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean containsAny(@NotNull String $this$containsAny, String ... values2) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$containsAny, "<this>");
            Intrinsics.checkNotNullParameter(values2, "values");
            String[] $this$any$iv = values2;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)$this$containsAny, it, false, 2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean containsAll(@NotNull String $this$containsAll, String ... values2) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$containsAll, "<this>");
            Intrinsics.checkNotNullParameter(values2, "values");
            String[] $this$all$iv = values2;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (StringsKt.contains$default((CharSequence)$this$containsAll, it, false, 2, null)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final String spaceCaps(@NotNull String $this$spaceCaps) {
        Intrinsics.checkNotNullParameter($this$spaceCaps, "<this>");
        CharSequence charSequence = $this$spaceCaps;
        Regex regex = spaceCapsRegex1;
        String string = " ";
        charSequence = regex.replace(charSequence, string);
        regex = spaceCapsRegex2;
        string = " ";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    @NotNull
    public final String toKebabCase(@NotNull String $this$toKebabCase) {
        Intrinsics.checkNotNullParameter($this$toKebabCase, "<this>");
        String string = this.spaceCaps($this$toKebabCase).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return StringsKt.replace$default(string, " ", "-", false, 4, null);
    }

    @NotNull
    public final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        Intrinsics.checkNotNullParameter($this$toSnakeCase, "<this>");
        String string = this.spaceCaps($this$toSnakeCase).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return StringsKt.replace$default(string, " ", "_", false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toCamelCase(@NotNull String $this$toCamelCase) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toCamelCase, "<this>");
        String[] stringArray = new String[]{" "};
        Iterable $this$mapIndexed$iv = StringsKt.split$default((CharSequence)this.spaceCaps($this$toCamelCase), stringArray, false, 0, 6, null);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string;
            void s;
            void i2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (i2 == false) {
                String string3 = s.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            } else {
                string = StringsKt.capitalize((String)s);
            }
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final String toPascalCase(@NotNull String $this$toPascalCase) {
        Intrinsics.checkNotNullParameter($this$toPascalCase, "<this>");
        String[] stringArray = new String[]{" "};
        return CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)this.spaceCaps($this$toPascalCase), stringArray, false, 0, 6, null), "", null, null, 0, null, StringUtils::toPascalCase$lambda$5, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String remove(@NotNull String $this$remove, String ... patterns) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$remove, "<this>");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        String[] stringArray = patterns;
        String initial$iv = $this$remove;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int j = 0; j < n; ++j) {
            void s;
            void element$iv;
            void var10_10 = element$iv = $this$fold$iv[j];
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, (String)s, "", false, 4, null);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String remove(@NotNull String $this$remove, Regex ... patterns) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$remove, "<this>");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        Regex[] regexArray = patterns;
        String initial$iv = $this$remove;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int j = 0; j < n; ++j) {
            void r;
            void element$iv;
            void var10_10 = element$iv = $this$fold$iv[j];
            String acc = accumulator$iv;
            boolean bl = false;
            CharSequence charSequence = acc;
            String string = "";
            accumulator$iv = r.replace(charSequence, string);
        }
        return accumulator$iv;
    }

    @NotNull
    public final String removeSpace(@NotNull String $this$removeSpace) {
        Intrinsics.checkNotNullParameter($this$removeSpace, "<this>");
        CharSequence charSequence = $this$removeSpace;
        Regex regex = spaceRegex;
        String string = "";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String removeWhitespace(@NotNull String $this$removeWhitespace) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$removeWhitespace, "<this>");
        String $this$filterNot$iv = $this$removeWhitespace;
        boolean $i$f$filterNot = false;
        CharSequence charSequence = $this$filterNot$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterNotTo = false;
        for (int j = 0; j < $this$filterNotTo$iv$iv.length(); ++j) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(j);
            boolean bl = false;
            if (CharsKt.isWhitespace(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    @NotNull
    public final String truncate(@NotNull String $this$truncate, int maxLength, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter($this$truncate, "<this>");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        return $this$truncate.length() <= maxLength ? $this$truncate : StringsKt.take($this$truncate, maxLength - suffix.length()) + suffix;
    }

    public static /* synthetic */ String truncate$default(StringUtils stringUtils, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = "...";
        }
        return stringUtils.truncate(string, n, string2);
    }

    public final int countOccurrences(@NotNull String $this$countOccurrences, @NotNull String substring) {
        Intrinsics.checkNotNullParameter($this$countOccurrences, "<this>");
        Intrinsics.checkNotNullParameter(substring, "substring");
        return CollectionsKt.sumOfInt(StringsKt.windowed$default($this$countOccurrences, substring.length(), 0, false, arg_0 -> StringUtils.countOccurrences$lambda$9(substring, arg_0), 6, null));
    }

    @NotNull
    public final String wrapWith(@NotNull String $this$wrapWith, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter($this$wrapWith, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        return prefix + $this$wrapWith + suffix;
    }

    public static /* synthetic */ String wrapWith$default(StringUtils stringUtils, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string2;
        }
        return stringUtils.wrapWith(string, string2, string3);
    }

    public final void matchAndRun(@NotNull Regex $this$matchAndRun, @NotNull String text, @NotNull Function1<? super List<String>, Unit> func) {
        block2: {
            Intrinsics.checkNotNullParameter($this$matchAndRun, "<this>");
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(func, "func");
            Object object = Regex.find$default($this$matchAndRun, text, 0, 2, null);
            if (object == null || (object = object.getDestructured()) == null) break block2;
            Object match = object;
            boolean bl = false;
            List<String> values2 = ((MatchResult.Destructured)match).toList();
            try {
                func.invoke(values2);
            }
            catch (Exception exception) {
            }
        }
    }

    private static final CharSequence toPascalCase$lambda$5(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.capitalize(it);
    }

    private static final int countOccurrences$lambda$9(String $substring, CharSequence it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $substring) ? 1 : 0;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('M'), 1000), TuplesKt.to(Character.valueOf('D'), 500), TuplesKt.to(Character.valueOf('C'), 100), TuplesKt.to(Character.valueOf('L'), 50), TuplesKt.to(Character.valueOf('X'), 10), TuplesKt.to(Character.valueOf('V'), 5), TuplesKt.to(Character.valueOf('I'), 1)};
        romanValues = MapsKt.mapOf(pairArray);
    }
}

