/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.animations;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.vexel.animations.AnimationManager;
import xyz.meowing.vexel.animations.AnimationTarget;
import xyz.meowing.vexel.animations.AnimationType;
import xyz.meowing.vexel.animations.EasingType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u001f\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BG\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0017H&\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010+\u001a\u0004\b,\u0010-R\u001f\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010.\u001a\u0004\b/\u00100R\u0016\u00101\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010\"R\u0016\u00102\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R$\u00105\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00148\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b5\u00103\u001a\u0004\b5\u0010\u0016\u00a8\u00066"}, d2={"Lxyz/meowing/vexel/animations/Animation;", "T", "", "Lxyz/meowing/vexel/animations/AnimationTarget;", "target", "", "duration", "Lxyz/meowing/vexel/animations/EasingType;", "type", "Lxyz/meowing/vexel/animations/AnimationType;", "animationType", "", "elementId", "Lkotlin/Function0;", "", "onComplete", "<init>", "(Lxyz/meowing/vexel/animations/AnimationTarget;JLxyz/meowing/vexel/animations/EasingType;Lxyz/meowing/vexel/animations/AnimationType;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "start", "()V", "", "update", "()Z", "", "t", "applyEasing", "(F)F", "end", "progress", "interpolate", "(Ljava/lang/Object;Ljava/lang/Object;F)Ljava/lang/Object;", "Lxyz/meowing/vexel/animations/AnimationTarget;", "getTarget", "()Lxyz/meowing/vexel/animations/AnimationTarget;", "J", "getDuration", "()J", "Lxyz/meowing/vexel/animations/EasingType;", "getType", "()Lxyz/meowing/vexel/animations/EasingType;", "Lxyz/meowing/vexel/animations/AnimationType;", "getAnimationType", "()Lxyz/meowing/vexel/animations/AnimationType;", "Ljava/lang/String;", "getElementId", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function0;", "getOnComplete", "()Lkotlin/jvm/functions/Function0;", "startTime", "isStarted", "Z", "value", "isCompleted", "Vexel"})
public abstract class Animation<T> {
    @NotNull
    private final AnimationTarget<T> target;
    private final long duration;
    @NotNull
    private final EasingType type;
    @NotNull
    private final AnimationType animationType;
    @NotNull
    private final String elementId;
    @Nullable
    private final Function0<Unit> onComplete;
    private long startTime;
    private boolean isStarted;
    private boolean isCompleted;

    public Animation(@NotNull AnimationTarget<T> target, long duration, @NotNull EasingType type2, @NotNull AnimationType animationType, @NotNull String elementId, @Nullable Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter((Object)animationType, "animationType");
        Intrinsics.checkNotNullParameter(elementId, "elementId");
        this.target = target;
        this.duration = duration;
        this.type = type2;
        this.animationType = animationType;
        this.elementId = elementId;
        this.onComplete = onComplete;
    }

    public /* synthetic */ Animation(AnimationTarget animationTarget, long l, EasingType easingType, AnimationType animationType, String string, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function0 = null;
        }
        this(animationTarget, l, easingType, animationType, string, function0);
    }

    @NotNull
    public final AnimationTarget<T> getTarget() {
        return this.target;
    }

    public final long getDuration() {
        return this.duration;
    }

    @NotNull
    public final EasingType getType() {
        return this.type;
    }

    @NotNull
    public final AnimationType getAnimationType() {
        return this.animationType;
    }

    @NotNull
    public final String getElementId() {
        return this.elementId;
    }

    @Nullable
    public final Function0<Unit> getOnComplete() {
        return this.onComplete;
    }

    public final boolean isCompleted() {
        return this.isCompleted;
    }

    public final void start() {
        if (!this.isStarted) {
            this.startTime = System.currentTimeMillis();
            this.isStarted = true;
            AnimationManager.INSTANCE.register(this);
        }
    }

    public final boolean update() {
        if (!this.isStarted || this.isCompleted) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        float progress = RangesKt.coerceIn((float)elapsed / (float)this.duration, 0.0f, 1.0f);
        float easedProgress = this.applyEasing(progress);
        this.target.getSetter().invoke(this.interpolate(this.target.getStartValue(), this.target.getEndValue(), easedProgress));
        if (progress >= 1.0f) {
            this.isCompleted = true;
            Function0<Unit> function0 = this.onComplete;
            if (function0 != null) {
                function0.invoke();
            }
            return true;
        }
        return false;
    }

    private final float applyEasing(float t) {
        float f;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                f = t;
                break;
            }
            case 2: {
                f = t * t;
                break;
            }
            case 3: {
                f = 1.0f - (1.0f - t) * (1.0f - t);
                break;
            }
            case 4: {
                if (t < 0.5f) {
                    f = 2.0f * t * t;
                    break;
                }
                f = 1.0f - 2.0f * (1.0f - t) * (1.0f - t);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    public abstract T interpolate(T var1, T var2, float var3);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EasingType.values().length];
            try {
                nArray[EasingType.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EasingType.EASE_IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EasingType.EASE_OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EasingType.EASE_IN_OUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

