/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.components.core;

import java.awt.Color;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.vexel.Vexel;
import xyz.meowing.vexel.animations.EasingType;
import xyz.meowing.vexel.animations.ExtensionsKt;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.utils.style.Image;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ;\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010#\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010\u001bR\"\u0010.\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\u001e\u001a\u0004\b/\u0010 \"\u0004\b0\u0010\"R\"\u00102\u001a\u0002018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\"\u00108\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u0010#\u001a\u0004\b9\u0010%\"\u0004\b:\u0010'\u00a8\u0006;"}, d2={"Lxyz/meowing/vexel/components/core/SvgImage;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "svgPath", "", "startingWidth", "startingHeight", "Ljava/awt/Color;", "color", "<init>", "(Ljava/lang/String;FFLjava/awt/Color;)V", "mouseX", "mouseY", "", "onRender", "(FF)V", "angle", "", "duration", "Lxyz/meowing/vexel/animations/EasingType;", "type", "Lkotlin/Function0;", "onComplete", "rotateTo", "(FJLxyz/meowing/vexel/animations/EasingType;Lkotlin/jvm/functions/Function0;)Lxyz/meowing/vexel/components/core/SvgImage;", "newColor", "setSvgColor", "(Ljava/awt/Color;)V", "reloadImage", "()V", "Ljava/lang/String;", "getSvgPath", "()Ljava/lang/String;", "setSvgPath", "(Ljava/lang/String;)V", "F", "getStartingWidth", "()F", "setStartingWidth", "(F)V", "getStartingHeight", "setStartingHeight", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "imageId", "getImageId", "setImageId", "Lxyz/meowing/vexel/utils/style/Image;", "image", "Lxyz/meowing/vexel/utils/style/Image;", "getImage", "()Lxyz/meowing/vexel/utils/style/Image;", "setImage", "(Lxyz/meowing/vexel/utils/style/Image;)V", "rotation", "getRotation", "setRotation", "Vexel"})
public final class SvgImage
extends VexelElement<SvgImage> {
    @NotNull
    private String svgPath;
    private float startingWidth;
    private float startingHeight;
    @NotNull
    private Color color;
    @NotNull
    private String imageId;
    @NotNull
    private Image image;
    private float rotation;

    public SvgImage(@NotNull String svgPath, float startingWidth, float startingHeight, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(svgPath, "svgPath");
        Intrinsics.checkNotNullParameter(color, "color");
        super(null, null, 3, null);
        this.svgPath = svgPath;
        this.startingWidth = startingWidth;
        this.startingHeight = startingHeight;
        this.color = color;
        this.imageId = String.valueOf(UUID.randomUUID());
        this.image = Vexel.INSTANCE.getRenderEngine().createImage(this.svgPath, (int)this.startingWidth, (int)this.startingHeight, this.color, this.imageId);
        this.setWidth(this.startingWidth);
        this.setHeight(this.startingHeight);
        this.setSizing(Size.Auto, Size.Auto);
        this.setPositioning(Pos.ParentPixels, Pos.ParentPixels);
        this.ignoreMouseEvents();
        this.setSizing(this.startingWidth, Size.Pixels, this.startingHeight, Size.Pixels);
    }

    public /* synthetic */ SvgImage(String string, float f, float f2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            f = 80.0f;
        }
        if ((n & 4) != 0) {
            f2 = 80.0f;
        }
        if ((n & 8) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        this(string, f, f2, color);
    }

    @NotNull
    public final String getSvgPath() {
        return this.svgPath;
    }

    public final void setSvgPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.svgPath = string;
    }

    public final float getStartingWidth() {
        return this.startingWidth;
    }

    public final void setStartingWidth(float f) {
        this.startingWidth = f;
    }

    public final float getStartingHeight() {
        return this.startingHeight;
    }

    public final void setStartingHeight(float f) {
        this.startingHeight = f;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.color = color;
    }

    @NotNull
    public final String getImageId() {
        return this.imageId;
    }

    public final void setImageId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.imageId = string;
    }

    @NotNull
    public final Image getImage() {
        return this.image;
    }

    public final void setImage(@NotNull Image image) {
        Intrinsics.checkNotNullParameter(image, "<set-?>");
        this.image = image;
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float f) {
        this.rotation = f;
    }

    @Override
    protected void onRender(float mouseX, float mouseY) {
        if (((CharSequence)this.svgPath).length() == 0) {
            return;
        }
        this.startingWidth = this.getWidth();
        this.startingHeight = this.getHeight();
        float centerX = this.getX() + this.getWidth() / 2.0f;
        float centerY = this.getY() + this.getHeight() / 2.0f;
        if (!(this.rotation == 0.0f)) {
            Vexel.INSTANCE.getRenderEngine().push();
            Vexel.INSTANCE.getRenderEngine().translate(centerX, centerY);
            Vexel.INSTANCE.getRenderEngine().rotate((float)Math.toRadians(this.rotation));
            Vexel.INSTANCE.getRenderEngine().translate(-centerX, -centerY);
        }
        Vexel.INSTANCE.getRenderEngine().svg(this.imageId, this.getX(), this.getY(), this.startingWidth, this.startingHeight, (float)this.color.getAlpha() / 255.0f);
        if (!(this.rotation == 0.0f)) {
            Vexel.INSTANCE.getRenderEngine().pop();
        }
    }

    @NotNull
    public final SvgImage rotateTo(float angle, long duration, @NotNull EasingType type2, @Nullable Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        ExtensionsKt.animateFloat$default(this, () -> SvgImage.rotateTo$lambda$0(this), arg_0 -> SvgImage.rotateTo$lambda$1(this, arg_0), angle, duration, type2, null, onComplete, 32, null);
        return this;
    }

    public static /* synthetic */ SvgImage rotateTo$default(SvgImage svgImage, float f, long l, EasingType easingType, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 300L;
        }
        if ((n & 4) != 0) {
            easingType = EasingType.EASE_OUT;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        return svgImage.rotateTo(f, l, easingType, function0);
    }

    public final void setSvgColor(@NotNull Color newColor) {
        Intrinsics.checkNotNullParameter(newColor, "newColor");
        if (!Intrinsics.areEqual(this.color, newColor)) {
            this.color = newColor;
            this.reloadImage();
        }
    }

    private final void reloadImage() {
        this.image = Vexel.INSTANCE.getRenderEngine().createImage(this.svgPath, (int)this.startingWidth, (int)this.startingHeight, this.color, this.imageId);
    }

    private static final float rotateTo$lambda$0(SvgImage this$0) {
        return this$0.rotation;
    }

    private static final Unit rotateTo$lambda$1(SvgImage this$0, float it) {
        this$0.rotation = it;
        return Unit.INSTANCE;
    }

    public SvgImage() {
        this(null, 0.0f, 0.0f, null, 15, null);
    }
}

