/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.elements;

import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.vexel.animations.EasingType;
import xyz.meowing.vexel.animations.ExtensionsKt;
import xyz.meowing.vexel.animations.PresetsKt;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.elements.ColorPickerPanel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001Bo\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0015J'\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0015J\u001f\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b!\u0010\u0015J\u001f\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00022\b\b\u0002\u0010#\u001a\u00020\u001b\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010(R\"\u0010)\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b/\u00101\"\u0004\b2\u00103R\"\u00104\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00100\u001a\u0004\b4\u00101\"\u0004\b5\u00103R\"\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0017\u0010:\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R$\u0010?\u001a\u0004\u0018\u00010>8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Lxyz/meowing/vexel/elements/ColorPicker;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Ljava/awt/Color;", "initialColor", "", "backgroundColor", "borderColor", "", "borderRadius", "borderThickness", "", "padding", "hoverColor", "pressedColor", "Lxyz/meowing/vexel/components/base/Size;", "widthType", "heightType", "<init>", "(Ljava/awt/Color;IIFF[FLjava/lang/Integer;Ljava/lang/Integer;Lxyz/meowing/vexel/components/base/Size;Lxyz/meowing/vexel/components/base/Size;)V", "", "togglePicker", "()V", "openPicker", "closePicker", "mouseX", "mouseY", "button", "", "handleMouseClick", "(FFI)Z", "updatePickerPosition", "onRender", "(FF)V", "destroy", "color", "silent", "setColor", "(Ljava/awt/Color;Z)Lxyz/meowing/vexel/elements/ColorPicker;", "I", "getBackgroundColor", "()I", "selectedColor", "Ljava/awt/Color;", "getSelectedColor", "()Ljava/awt/Color;", "setSelectedColor", "(Ljava/awt/Color;)V", "isPickerOpen", "Z", "()Z", "setPickerOpen", "(Z)V", "isAnimating", "setAnimating", "Lkotlin/Pair;", "lastPosition", "Lkotlin/Pair;", "Lxyz/meowing/vexel/components/core/Rectangle;", "previewRect", "Lxyz/meowing/vexel/components/core/Rectangle;", "getPreviewRect", "()Lxyz/meowing/vexel/components/core/Rectangle;", "Lxyz/meowing/vexel/elements/ColorPickerPanel;", "pickerPanel", "Lxyz/meowing/vexel/elements/ColorPickerPanel;", "getPickerPanel", "()Lxyz/meowing/vexel/elements/ColorPickerPanel;", "setPickerPanel", "(Lxyz/meowing/vexel/elements/ColorPickerPanel;)V", "Vexel"})
public final class ColorPicker
extends VexelElement<ColorPicker> {
    private final int backgroundColor;
    @NotNull
    private Color selectedColor;
    private boolean isPickerOpen;
    private boolean isAnimating;
    @NotNull
    private Pair<Float, Float> lastPosition;
    @NotNull
    private final Rectangle previewRect;
    @Nullable
    private ColorPickerPanel pickerPanel;

    public ColorPicker(@NotNull Color initialColor, int backgroundColor, int borderColor, float borderRadius, float borderThickness, @NotNull float[] padding, @Nullable Integer hoverColor, @Nullable Integer pressedColor, @NotNull Size widthType, @NotNull Size heightType) {
        Intrinsics.checkNotNullParameter(initialColor, "initialColor");
        Intrinsics.checkNotNullParameter(padding, "padding");
        Intrinsics.checkNotNullParameter((Object)widthType, "widthType");
        Intrinsics.checkNotNullParameter((Object)heightType, "heightType");
        super(widthType, heightType);
        this.backgroundColor = backgroundColor;
        this.selectedColor = initialColor;
        this.lastPosition = new Pair<Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.previewRect = (Rectangle)((Rectangle)((Rectangle)new Rectangle(this.selectedColor.getRGB(), borderColor, borderRadius, borderThickness, padding, hoverColor, pressedColor, Size.ParentPerc, Size.ParentPerc, false, 512, null).setSizing(100.0f, Size.ParentPerc, 100.0f, Size.ParentPerc)).ignoreMouseEvents()).childOf(this);
        this.setSizing(30.0f, Size.Pixels, 20.0f, Size.Pixels);
        this.setPositioning(Pos.ParentPixels, Pos.ParentPixels);
        this.onClick((arg_0, arg_1, arg_2) -> ColorPicker._init_$lambda$0(this, arg_0, arg_1, arg_2));
    }

    public /* synthetic */ ColorPicker(Color color, int n, int n2, float f, float f2, float[] fArray, Integer n3, Integer n4, Size size, Size size2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        if ((n5 & 2) != 0) {
            n = -15264234;
        }
        if ((n5 & 4) != 0) {
            n2 = -10461088;
        }
        if ((n5 & 8) != 0) {
            f = 4.0f;
        }
        if ((n5 & 0x10) != 0) {
            f2 = 1.0f;
        }
        if ((n5 & 0x20) != 0) {
            float[] fArray2 = new float[]{4.0f, 4.0f, 4.0f, 4.0f};
            fArray = fArray2;
        }
        if ((n5 & 0x40) != 0) {
            n3 = -2142220208;
        }
        if ((n5 & 0x80) != 0) {
            n4 = -2144325584;
        }
        if ((n5 & 0x100) != 0) {
            size = Size.Pixels;
        }
        if ((n5 & 0x200) != 0) {
            size2 = Size.Pixels;
        }
        this(color, n, n2, f, f2, fArray, n3, n4, size, size2);
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public final Color getSelectedColor() {
        return this.selectedColor;
    }

    public final void setSelectedColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.selectedColor = color;
    }

    public final boolean isPickerOpen() {
        return this.isPickerOpen;
    }

    public final void setPickerOpen(boolean bl) {
        this.isPickerOpen = bl;
    }

    public final boolean isAnimating() {
        return this.isAnimating;
    }

    public final void setAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    @NotNull
    public final Rectangle getPreviewRect() {
        return this.previewRect;
    }

    @Nullable
    public final ColorPickerPanel getPickerPanel() {
        return this.pickerPanel;
    }

    public final void setPickerPanel(@Nullable ColorPickerPanel colorPickerPanel) {
        this.pickerPanel = colorPickerPanel;
    }

    public final void togglePicker() {
        if (this.isPickerOpen) {
            this.closePicker();
        } else {
            this.openPicker();
        }
    }

    public final void openPicker() {
        VexelElement vexelElement;
        if (this.isPickerOpen || this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        float currentX = this.previewRect.getScreenX();
        float currentY = this.previewRect.getScreenY() + this.previewRect.getHeight() + 3.0f;
        this.lastPosition = new Pair<Float, Float>(Float.valueOf(currentX), Float.valueOf(currentY));
        ColorPickerPanel colorPickerPanel = this.pickerPanel = (ColorPickerPanel)((ColorPickerPanel)((ColorPickerPanel)((ColorPickerPanel)new ColorPickerPanel(this.selectedColor, this.backgroundColor, 0, this.previewRect, 4, null).setSizing(Size.Auto, Size.Auto)).setPositioning(currentX, Pos.ScreenPixels, currentY, Pos.ScreenPixels)).setFloating()).childOf(this.getRootElement());
        if (colorPickerPanel != null) {
            ColorPickerPanel cfr_ignored_0 = (ColorPickerPanel)colorPickerPanel.onValueChange(arg_0 -> ColorPicker.openPicker$lambda$1(this, arg_0));
        }
        if ((vexelElement = this.pickerPanel) != null && (vexelElement = vexelElement.getBackground()) != null) {
            Rectangle cfr_ignored_1 = (Rectangle)PresetsKt.fadeIn$default(vexelElement, 200L, EasingType.EASE_OUT, false, () -> ColorPicker.openPicker$lambda$2(this), 4, null);
        }
        ColorPickerPanel colorPickerPanel2 = this.pickerPanel;
        if (colorPickerPanel2 != null) {
            ExtensionsKt.animateFloat$default(colorPickerPanel2, ColorPicker::openPicker$lambda$3, arg_0 -> ColorPicker.openPicker$lambda$4(this, arg_0), 1.0f, 200L, EasingType.EASE_OUT, null, null, 96, null);
        }
        this.isPickerOpen = true;
    }

    public final void closePicker() {
        if (!this.isPickerOpen || this.pickerPanel == null || this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        VexelElement vexelElement = this.pickerPanel;
        if (vexelElement != null && (vexelElement = vexelElement.getBackground()) != null) {
            Rectangle cfr_ignored_0 = (Rectangle)PresetsKt.fadeOut$default(vexelElement, 200L, EasingType.EASE_IN, false, () -> ColorPicker.closePicker$lambda$5(this), 4, null);
        }
        ColorPickerPanel colorPickerPanel = this.pickerPanel;
        if (colorPickerPanel != null) {
            ExtensionsKt.animateFloat$default(colorPickerPanel, ColorPicker::closePicker$lambda$6, arg_0 -> ColorPicker.closePicker$lambda$7(this, arg_0), 0.0f, 200L, EasingType.EASE_IN, null, null, 96, null);
        }
        this.isPickerOpen = false;
    }

    @Override
    public boolean handleMouseClick(float mouseX, float mouseY, int button2) {
        boolean handled = super.handleMouseClick(mouseX, mouseY, button2);
        if (this.isPickerOpen && this.pickerPanel != null) {
            ColorPickerPanel colorPickerPanel = this.pickerPanel;
            Intrinsics.checkNotNull(colorPickerPanel);
            if (!(colorPickerPanel.isPointInside(mouseX, mouseY) || this.isPointInside(mouseX, mouseY) || this.isAnimating)) {
                this.closePicker();
            }
        }
        return handled;
    }

    private final void updatePickerPosition() {
        block1: {
            float currentX = this.previewRect.getScreenX();
            float currentY = this.previewRect.getScreenY() + this.previewRect.getHeight() + 3.0f;
            if (((Number)this.lastPosition.getFirst()).floatValue() == currentX && ((Number)this.lastPosition.getSecond()).floatValue() == currentY) break block1;
            this.lastPosition = new Pair<Float, Float>(Float.valueOf(currentX), Float.valueOf(currentY));
            ColorPickerPanel colorPickerPanel = this.pickerPanel;
            if (colorPickerPanel != null) {
                ColorPickerPanel cfr_ignored_0 = (ColorPickerPanel)colorPickerPanel.setPositioning(currentX, Pos.ScreenPixels, currentY, Pos.ScreenPixels);
            }
        }
    }

    @Override
    protected void onRender(float mouseX, float mouseY) {
        this.previewRect.setHovered(this.getHovered());
        this.previewRect.setPressed(this.getPressed());
        this.previewRect.setHoverColor(this.selectedColor.darker().getRGB());
        this.previewRect.setPressedColor(this.selectedColor.darker().getRGB());
        if (this.isPickerOpen && this.pickerPanel != null) {
            if (!this.previewRect.isVisibleInScrollableParents()) {
                this.closePicker();
            } else {
                this.updatePickerPosition();
            }
        }
    }

    @Override
    public void destroy() {
        if (this.isPickerOpen) {
            this.closePicker();
        }
        super.destroy();
    }

    @NotNull
    public final ColorPicker setColor(@NotNull Color color, boolean silent) {
        block1: {
            Intrinsics.checkNotNullParameter(color, "color");
            this.selectedColor = color;
            this.previewRect.setBackgroundColor(color.getRGB());
            if (silent) break block1;
            Function1<Object, Unit> function1 = this.getOnValueChange();
            if (function1 != null) {
                function1.invoke(color);
            }
        }
        return this;
    }

    public static /* synthetic */ ColorPicker setColor$default(ColorPicker colorPicker, Color color, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return colorPicker.setColor(color, bl);
    }

    private static final boolean _init_$lambda$0(ColorPicker this$0, float f, float f2, int n) {
        if (!this$0.isAnimating) {
            this$0.togglePicker();
        }
        return true;
    }

    private static final Unit openPicker$lambda$1(ColorPicker this$0, Object color) {
        block0: {
            Intrinsics.checkNotNullParameter(color, "color");
            this$0.selectedColor = (Color)color;
            this$0.previewRect.setBackgroundColor(((Color)color).getRGB());
            Function1<Object, Unit> function1 = this$0.getOnValueChange();
            if (function1 == null) break block0;
            function1.invoke(color);
        }
        return Unit.INSTANCE;
    }

    private static final Unit openPicker$lambda$2(ColorPicker this$0) {
        this$0.isAnimating = false;
        return Unit.INSTANCE;
    }

    private static final float openPicker$lambda$3() {
        return 0.0f;
    }

    private static final Unit openPicker$lambda$4(ColorPicker this$0, float alpha) {
        block2: {
            VexelElement vexelElement;
            VexelElement vexelElement2;
            VexelElement vexelElement3 = this$0.pickerPanel;
            if (vexelElement3 != null && (vexelElement3 = ((ColorPickerPanel)vexelElement3).getPickerArea()) != null) {
                ((ColorPickerPanel.ColorPickerArea)vexelElement3).setAlpha(alpha);
            }
            if ((vexelElement2 = this$0.pickerPanel) != null && (vexelElement2 = ((ColorPickerPanel)vexelElement2).getHueSlider()) != null) {
                ((ColorPickerPanel.HueSlider)vexelElement2).setAlpha(alpha);
            }
            if ((vexelElement = this$0.pickerPanel) == null || (vexelElement = ((ColorPickerPanel)vexelElement).getAlphaSlider()) == null) break block2;
            ((ColorPickerPanel.AlphaSlider)vexelElement).setAlpha(alpha);
        }
        return Unit.INSTANCE;
    }

    private static final Unit closePicker$lambda$5(ColorPicker this$0) {
        List<VexelElement<?>> list = this$0.getRootElement().getChildren();
        ColorPickerPanel colorPickerPanel = this$0.pickerPanel;
        Intrinsics.checkNotNull(colorPickerPanel);
        list.remove(colorPickerPanel);
        ColorPickerPanel colorPickerPanel2 = this$0.pickerPanel;
        Intrinsics.checkNotNull(colorPickerPanel2);
        colorPickerPanel2.destroy();
        this$0.pickerPanel = null;
        this$0.isAnimating = false;
        return Unit.INSTANCE;
    }

    private static final float closePicker$lambda$6() {
        return 1.0f;
    }

    private static final Unit closePicker$lambda$7(ColorPicker this$0, float alpha) {
        block2: {
            VexelElement vexelElement;
            VexelElement vexelElement2;
            VexelElement vexelElement3 = this$0.pickerPanel;
            if (vexelElement3 != null && (vexelElement3 = ((ColorPickerPanel)vexelElement3).getPickerArea()) != null) {
                ((ColorPickerPanel.ColorPickerArea)vexelElement3).setAlpha(alpha);
            }
            if ((vexelElement2 = this$0.pickerPanel) != null && (vexelElement2 = ((ColorPickerPanel)vexelElement2).getHueSlider()) != null) {
                ((ColorPickerPanel.HueSlider)vexelElement2).setAlpha(alpha);
            }
            if ((vexelElement = this$0.pickerPanel) == null || (vexelElement = ((ColorPickerPanel)vexelElement).getAlphaSlider()) == null) break block2;
            ((ColorPickerPanel.AlphaSlider)vexelElement).setAlpha(alpha);
        }
        return Unit.INSTANCE;
    }

    public ColorPicker() {
        this(null, 0, 0, 0.0f, 0.0f, null, null, null, null, null, 1023, null);
    }
}

