/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.elements;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.vexel.Vexel;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.utils.render.api.RenderApi;
import xyz.meowing.vexel.utils.style.Gradient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003QRSB+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\rJ\u001f\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u0018R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010\u001aR\"\u0010*\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(\"\u0004\b,\u0010\u001aR\"\u0010-\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010&\u001a\u0004\b.\u0010(\"\u0004\b/\u0010\u001aR\"\u00100\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010&\u001a\u0004\b1\u0010(\"\u0004\b2\u0010\u001aR\"\u00103\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u00109\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u00104\u001a\u0004\b:\u00106\"\u0004\b;\u00108R\"\u0010<\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00104\u001a\u0004\b=\u00106\"\u0004\b>\u00108R\u0017\u0010?\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b?\u0010\u001e\u001a\u0004\b@\u0010AR\u001b\u0010C\u001a\u00060BR\u00020\u00008\u0006\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010FR\u001b\u0010H\u001a\u00060GR\u00020\u00008\u0006\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR\u001b\u0010M\u001a\u00060LR\u00020\u00008\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\u00a8\u0006T"}, d2={"Lxyz/meowing/vexel/elements/ColorPickerPanel;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Ljava/awt/Color;", "initialColor", "", "backgroundColor", "borderColor", "Lxyz/meowing/vexel/components/core/Rectangle;", "sourceColorPicker", "<init>", "(Ljava/awt/Color;IILxyz/meowing/vexel/components/core/Rectangle;)V", "", "setupInteractions", "()V", "", "mouseX", "mouseY", "", "handleMouseMove", "(FF)Z", "button", "handleMouseRelease", "(FFI)Z", "updatePickerFromMouse", "(FF)V", "updateHueFromMouse", "(F)V", "updateAlphaFromMouse", "updateColor", "onRender", "Lxyz/meowing/vexel/components/core/Rectangle;", "currentColor", "Ljava/awt/Color;", "getCurrentColor", "()Ljava/awt/Color;", "setCurrentColor", "(Ljava/awt/Color;)V", "currentHue", "F", "getCurrentHue", "()F", "setCurrentHue", "currentSaturation", "getCurrentSaturation", "setCurrentSaturation", "currentBrightness", "getCurrentBrightness", "setCurrentBrightness", "currentAlpha", "getCurrentAlpha", "setCurrentAlpha", "draggingPicker", "Z", "getDraggingPicker", "()Z", "setDraggingPicker", "(Z)V", "draggingHue", "getDraggingHue", "setDraggingHue", "draggingAlpha", "getDraggingAlpha", "setDraggingAlpha", "background", "getBackground", "()Lxyz/meowing/vexel/components/core/Rectangle;", "Lxyz/meowing/vexel/elements/ColorPickerPanel$ColorPickerArea;", "pickerArea", "Lxyz/meowing/vexel/elements/ColorPickerPanel$ColorPickerArea;", "getPickerArea", "()Lxyz/meowing/vexel/elements/ColorPickerPanel$ColorPickerArea;", "Lxyz/meowing/vexel/elements/ColorPickerPanel$HueSlider;", "hueSlider", "Lxyz/meowing/vexel/elements/ColorPickerPanel$HueSlider;", "getHueSlider", "()Lxyz/meowing/vexel/elements/ColorPickerPanel$HueSlider;", "Lxyz/meowing/vexel/elements/ColorPickerPanel$AlphaSlider;", "alphaSlider", "Lxyz/meowing/vexel/elements/ColorPickerPanel$AlphaSlider;", "getAlphaSlider", "()Lxyz/meowing/vexel/elements/ColorPickerPanel$AlphaSlider;", "ColorPickerArea", "HueSlider", "AlphaSlider", "Vexel"})
public final class ColorPickerPanel
extends VexelElement<ColorPickerPanel> {
    @NotNull
    private final Rectangle sourceColorPicker;
    @NotNull
    private Color currentColor;
    private float currentHue;
    private float currentSaturation;
    private float currentBrightness;
    private float currentAlpha;
    private boolean draggingPicker;
    private boolean draggingHue;
    private boolean draggingAlpha;
    @NotNull
    private final Rectangle background;
    @NotNull
    private final ColorPickerArea pickerArea;
    @NotNull
    private final HueSlider hueSlider;
    @NotNull
    private final AlphaSlider alphaSlider;

    public ColorPickerPanel(@NotNull Color initialColor, int backgroundColor, int borderColor, @NotNull Rectangle sourceColorPicker) {
        Intrinsics.checkNotNullParameter(initialColor, "initialColor");
        Intrinsics.checkNotNullParameter(sourceColorPicker, "sourceColorPicker");
        super(null, null, 3, null);
        this.sourceColorPicker = sourceColorPicker;
        this.currentColor = initialColor;
        this.currentAlpha = (float)initialColor.getAlpha() / 255.0f;
        float[] fArray = new float[]{8.0f, 8.0f, 8.0f, 8.0f};
        this.background = (Rectangle)((Rectangle)((Rectangle)new Rectangle(backgroundColor, borderColor, 2.0f, 1.0f, fArray, null, null, null, null, false, 992, null).setSizing(0.0f, Size.Auto, 170.0f, Size.Pixels)).ignoreMouseEvents()).childOf(this);
        this.pickerArea = (ColorPickerArea)((ColorPickerArea)((ColorPickerArea)new ColorPickerArea().setSizing(150.0f, Size.Pixels, 95.0f, Size.ParentPerc)).setPositioning(Pos.ParentPixels, Pos.ParentCenter)).childOf(this.background);
        this.hueSlider = (HueSlider)((HueSlider)((HueSlider)((HueSlider)new HueSlider().setSizing(20.0f, Size.Pixels, 95.0f, Size.ParentPerc)).setPositioning(Pos.AfterSibling, Pos.ParentCenter)).setOffset(5.0f, 0.0f)).childOf(this.background);
        this.alphaSlider = (AlphaSlider)((AlphaSlider)((AlphaSlider)((AlphaSlider)new AlphaSlider().setSizing(20.0f, Size.Pixels, 95.0f, Size.ParentPerc)).setPositioning(Pos.AfterSibling, Pos.ParentCenter)).setOffset(5.0f, 0.0f)).childOf(this.background);
        float[] hsb = Color.RGBtoHSB(initialColor.getRed(), initialColor.getGreen(), initialColor.getBlue(), null);
        this.currentHue = hsb[0];
        this.currentSaturation = hsb[1];
        this.currentBrightness = hsb[2];
        this.setupInteractions();
        this.updateColor();
    }

    public /* synthetic */ ColorPickerPanel(Color color, int n, int n2, Rectangle rectangle, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = -15264234;
        }
        if ((n3 & 4) != 0) {
            n2 = -11513776;
        }
        this(color, n, n2, rectangle);
    }

    @NotNull
    public final Color getCurrentColor() {
        return this.currentColor;
    }

    public final void setCurrentColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.currentColor = color;
    }

    public final float getCurrentHue() {
        return this.currentHue;
    }

    public final void setCurrentHue(float f) {
        this.currentHue = f;
    }

    public final float getCurrentSaturation() {
        return this.currentSaturation;
    }

    public final void setCurrentSaturation(float f) {
        this.currentSaturation = f;
    }

    public final float getCurrentBrightness() {
        return this.currentBrightness;
    }

    public final void setCurrentBrightness(float f) {
        this.currentBrightness = f;
    }

    public final float getCurrentAlpha() {
        return this.currentAlpha;
    }

    public final void setCurrentAlpha(float f) {
        this.currentAlpha = f;
    }

    public final boolean getDraggingPicker() {
        return this.draggingPicker;
    }

    public final void setDraggingPicker(boolean bl) {
        this.draggingPicker = bl;
    }

    public final boolean getDraggingHue() {
        return this.draggingHue;
    }

    public final void setDraggingHue(boolean bl) {
        this.draggingHue = bl;
    }

    public final boolean getDraggingAlpha() {
        return this.draggingAlpha;
    }

    public final void setDraggingAlpha(boolean bl) {
        this.draggingAlpha = bl;
    }

    @NotNull
    public final Rectangle getBackground() {
        return this.background;
    }

    @NotNull
    public final ColorPickerArea getPickerArea() {
        return this.pickerArea;
    }

    @NotNull
    public final HueSlider getHueSlider() {
        return this.hueSlider;
    }

    @NotNull
    public final AlphaSlider getAlphaSlider() {
        return this.alphaSlider;
    }

    private final void setupInteractions() {
        this.pickerArea.onMouseClick((arg_0, arg_1, arg_2) -> ColorPickerPanel.setupInteractions$lambda$0(this, arg_0, arg_1, arg_2));
        this.hueSlider.onMouseClick((arg_0, arg_1, arg_2) -> ColorPickerPanel.setupInteractions$lambda$1(this, arg_0, arg_1, arg_2));
        this.alphaSlider.onMouseClick((arg_0, arg_1, arg_2) -> ColorPickerPanel.setupInteractions$lambda$2(this, arg_0, arg_1, arg_2));
    }

    @Override
    public boolean handleMouseMove(float mouseX, float mouseY) {
        boolean result = super.handleMouseMove(mouseX, mouseY);
        if (this.draggingPicker) {
            this.updatePickerFromMouse(mouseX, mouseY);
        } else if (this.draggingHue) {
            this.updateHueFromMouse(mouseY);
        } else if (this.draggingAlpha) {
            this.updateAlphaFromMouse(mouseY);
        }
        return result;
    }

    @Override
    public boolean handleMouseRelease(float mouseX, float mouseY, int button2) {
        boolean result = super.handleMouseRelease(mouseX, mouseY, button2);
        if (button2 == 0) {
            this.draggingPicker = false;
            this.draggingHue = false;
            this.draggingAlpha = false;
        }
        return result;
    }

    private final void updatePickerFromMouse(float mouseX, float mouseY) {
        float relativeX = (mouseX - this.pickerArea.getX()) / this.pickerArea.getWidth();
        float relativeY = (mouseY - this.pickerArea.getY()) / this.pickerArea.getHeight();
        this.currentSaturation = RangesKt.coerceIn(relativeX, 0.0f, 1.0f);
        this.currentBrightness = RangesKt.coerceIn(1.0f - relativeY, 0.0f, 1.0f);
        this.updateColor();
    }

    private final void updateHueFromMouse(float mouseY) {
        float relativeY = (mouseY - this.hueSlider.getY()) / this.hueSlider.getHeight();
        this.currentHue = RangesKt.coerceIn(relativeY, 0.0f, 1.0f);
        this.updateColor();
    }

    private final void updateAlphaFromMouse(float mouseY) {
        float relativeY = (mouseY - this.alphaSlider.getY()) / this.alphaSlider.getHeight();
        this.currentAlpha = RangesKt.coerceIn(1.0f - relativeY, 0.0f, 1.0f);
        this.updateColor();
    }

    private final void updateColor() {
        block0: {
            int rgb = Color.HSBtoRGB(this.currentHue, this.currentSaturation, this.currentBrightness);
            Color baseColor = new Color(rgb);
            int alpha = RangesKt.coerceIn(MathKt.roundToInt(this.currentAlpha * (float)255), 0, 255);
            this.currentColor = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
            this.pickerArea.setCurrentHue(this.currentHue);
            this.alphaSlider.setCurrentColor(new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue()));
            Function1<Object, Unit> function1 = this.getOnValueChange();
            if (function1 == null) break block0;
            function1.invoke(this.currentColor);
        }
    }

    @Override
    protected void onRender(float mouseX, float mouseY) {
        this.background.setVisible(this.sourceColorPicker.isVisibleInScrollableParents());
    }

    private static final boolean setupInteractions$lambda$0(ColorPickerPanel this$0, float mouseX, float mouseY, int n) {
        this$0.draggingPicker = true;
        this$0.updatePickerFromMouse(mouseX, mouseY);
        return true;
    }

    private static final boolean setupInteractions$lambda$1(ColorPickerPanel this$0, float f, float mouseY, int n) {
        this$0.draggingHue = true;
        this$0.updateHueFromMouse(mouseY);
        return true;
    }

    private static final boolean setupInteractions$lambda$2(ColorPickerPanel this$0, float f, float mouseY, int n) {
        this$0.draggingAlpha = true;
        this$0.updateAlphaFromMouse(mouseY);
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lxyz/meowing/vexel/elements/ColorPickerPanel$AlphaSlider;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Lxyz/meowing/vexel/elements/ColorPickerPanel;", "<init>", "(Lxyz/meowing/vexel/elements/ColorPickerPanel;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "Ljava/awt/Color;", "currentColor", "Ljava/awt/Color;", "getCurrentColor", "()Ljava/awt/Color;", "setCurrentColor", "(Ljava/awt/Color;)V", "alpha", "F", "getAlpha", "()F", "setAlpha", "(F)V", "Vexel"})
    public final class AlphaSlider
    extends VexelElement<AlphaSlider> {
        @NotNull
        private Color currentColor;
        private float alpha;

        public AlphaSlider() {
            super(null, null, 3, null);
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            this.currentColor = color;
            this.alpha = 1.0f;
        }

        @NotNull
        public final Color getCurrentColor() {
            return this.currentColor;
        }

        public final void setCurrentColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "<set-?>");
            this.currentColor = color;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        @Override
        protected void onRender(float mouseX, float mouseY) {
            if (this.alpha <= 0.0f) {
                return;
            }
            Vexel.INSTANCE.getRenderEngine().globalAlpha(this.alpha);
            float checkerSize = 6.0f;
            int cols = (int)(this.getWidth() / checkerSize) + 1;
            int rows = (int)(this.getHeight() / checkerSize) + 1;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    float rectHeight;
                    int checkerColor = (row + col) % 2 == 0 ? -12566464 : -10461088;
                    float rectX = this.getX() + (float)col * checkerSize;
                    float rectY = this.getY() + (float)row * checkerSize;
                    float rectWidth = rectX + checkerSize > this.getX() + this.getWidth() ? this.getX() + this.getWidth() - rectX : checkerSize;
                    float f = rectHeight = rectY + checkerSize > this.getY() + this.getHeight() ? this.getY() + this.getHeight() - rectY : checkerSize;
                    if (!(rectWidth > 0.0f) || !(rectHeight > 0.0f)) continue;
                    RenderApi.DefaultImpls.rect$default(Vexel.INSTANCE.getRenderEngine(), rectX, rectY, rectWidth, rectHeight, checkerColor, 0.0f, 0.0f, 0.0f, 0.0f, 448, null);
                }
            }
            int opaqueColor = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), 255).getRGB();
            int transparentColor = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), 0).getRGB();
            Vexel.INSTANCE.getRenderEngine().gradientRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), opaqueColor, transparentColor, Gradient.TopToBottom, 0.0f);
            float indicatorY = this.getY() + (1.0f - ColorPickerPanel.this.getCurrentAlpha()) * this.getHeight() - 2.0f;
            RenderApi.DefaultImpls.rect$default(Vexel.INSTANCE.getRenderEngine(), this.getX() - 3.0f, indicatorY, this.getWidth() + 6.0f, 4.0f, -1, 2.0f, 0.0f, 0.0f, 0.0f, 448, null);
            Vexel.INSTANCE.getRenderEngine().globalAlpha(1.0f);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lxyz/meowing/vexel/elements/ColorPickerPanel$ColorPickerArea;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Lxyz/meowing/vexel/elements/ColorPickerPanel;", "<init>", "(Lxyz/meowing/vexel/elements/ColorPickerPanel;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "currentHue", "F", "getCurrentHue", "()F", "setCurrentHue", "(F)V", "alpha", "getAlpha", "setAlpha", "Vexel"})
    public final class ColorPickerArea
    extends VexelElement<ColorPickerArea> {
        private float currentHue;
        private float alpha;

        public ColorPickerArea() {
            super(null, null, 3, null);
            this.alpha = 1.0f;
        }

        public final float getCurrentHue() {
            return this.currentHue;
        }

        public final void setCurrentHue(float f) {
            this.currentHue = f;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        @Override
        protected void onRender(float mouseX, float mouseY) {
            if (this.alpha <= 0.0f) {
                return;
            }
            Vexel.INSTANCE.getRenderEngine().globalAlpha(this.alpha);
            int hueColor = Color.HSBtoRGB(this.currentHue, 1.0f, 1.0f);
            int whiteColor = -1;
            int blackColor = -16777216;
            Vexel.INSTANCE.getRenderEngine().gradientRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), whiteColor, hueColor, Gradient.LeftToRight, 0.0f);
            Vexel.INSTANCE.getRenderEngine().gradientRect(this.getX(), this.getY(), this.getWidth(), this.getHeight() + 1.0f, 0, blackColor, Gradient.TopToBottom, 0.0f);
            float indicatorX = this.getX() + ColorPickerPanel.this.getCurrentSaturation() * this.getWidth() - 3.0f;
            float indicatorY = this.getY() + (1.0f - ColorPickerPanel.this.getCurrentBrightness()) * this.getHeight() - 3.0f;
            Vexel.INSTANCE.getRenderEngine().hollowRect(indicatorX, indicatorY, 6.0f, 6.0f, 2.0f, -1, 2.0f);
            Vexel.INSTANCE.getRenderEngine().globalAlpha(1.0f);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lxyz/meowing/vexel/elements/ColorPickerPanel$HueSlider;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Lxyz/meowing/vexel/elements/ColorPickerPanel;", "<init>", "(Lxyz/meowing/vexel/elements/ColorPickerPanel;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "alpha", "F", "getAlpha", "()F", "setAlpha", "(F)V", "Vexel"})
    public final class HueSlider
    extends VexelElement<HueSlider> {
        private float alpha;

        public HueSlider() {
            super(null, null, 3, null);
            this.alpha = 1.0f;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        @Override
        protected void onRender(float mouseX, float mouseY) {
            if (this.alpha <= 0.0f) {
                return;
            }
            Vexel.INSTANCE.getRenderEngine().globalAlpha(this.alpha);
            int steps = (int)(this.getHeight() / 1.0f);
            float stepHeight = this.getHeight() / (float)steps;
            for (int i2 = 0; i2 < steps; ++i2) {
                float hue = (float)i2 / (float)steps;
                int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                Color color = new Color(rgb);
                float rectY = this.getY() + (float)i2 * stepHeight;
                RenderApi.DefaultImpls.rect$default(Vexel.INSTANCE.getRenderEngine(), this.getX(), rectY, this.getWidth(), stepHeight, color.getRGB(), 0.0f, 0.0f, 0.0f, 0.0f, 448, null);
            }
            float indicatorY = this.getY() + ColorPickerPanel.this.getCurrentHue() * this.getHeight() - 2.0f;
            RenderApi.DefaultImpls.rect$default(Vexel.INSTANCE.getRenderEngine(), this.getX() - 3.0f, indicatorY, this.getWidth() + 6.0f, 4.0f, -1, 3.0f, 0.0f, 0.0f, 0.0f, 448, null);
            Vexel.INSTANCE.getRenderEngine().globalAlpha(1.0f);
        }
    }
}

