/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.api;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.api.ZenAPI;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lxyz/meowing/zen/api/ZenAPI;", "", "<init>", "()V", "ws", "Lokhttp3/WebSocket;", "hashUUID", "", "uuid", "zenJarName", "getZenJarName", "()Ljava/lang/String;", "zen"})
public final class ZenAPI {
    @NotNull
    public static final ZenAPI INSTANCE = new ZenAPI();
    @Nullable
    private static WebSocket ws;

    private ZenAPI() {
    }

    private final String hashUUID(String uuid2) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = uuid2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] digest = md.digest(byArray);
        Intrinsics.checkNotNull(digest);
        return ArraysKt.joinToString$default(digest, (CharSequence)"", null, null, 0, null, (Function1)hashUUID.1.INSTANCE, 30, null);
    }

    private final String getZenJarName() {
        File[] files;
        File modsDir = new File(Zen.Companion.getMc().field_71412_D, "mods");
        Object object = files = modsDir.listFiles(ZenAPI::_get_zenJarName_$lambda$0);
        if (files == null || (object = ArraysKt.joinToString$default(object, (CharSequence)",", null, null, 0, null, (Function1)zenJarName.1.INSTANCE, 30, null)) == null) {
            object = "Zen-DevAuthClient.jar";
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _get_zenJarName_$lambda$0(File file, String name) {
        Intrinsics.checkNotNull(name);
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (!StringsKt.endsWith$default(string, ".jar", false, 2, null)) return false;
        String string2 = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        if (!StringsKt.contains$default((CharSequence)string2, "zen", false, 2, null)) return false;
        return true;
    }

    static {
        try {
            String string = Zen.Companion.getMc().func_110432_I().func_148256_e().getId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String uuid2 = string;
            String hashedUUID = INSTANCE.hashUUID(uuid2);
            Pair[] pairArray = new Pair[]{TuplesKt.to("version", Zen.Companion.getModInfo().getVersion()), TuplesKt.to("gameVersion", Zen.Companion.getModInfo().getMcVersion()), TuplesKt.to("hashedUUID", hashedUUID), TuplesKt.to("jarName", INSTANCE.getZenJarName())};
            Map debug = MapsKt.mapOf(pairArray);
            String debugOptions2 = CollectionsKt.joinToString$default(debug.entrySet(), "&", null, null, 0, null, debugOptions.1.INSTANCE, 30, null);
            String url = "ws://zen.mrfast-developer.com:1515/ws?" + debugOptions2;
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            Request request = new Request.Builder().url(url).build();
            ws = client.newWebSocket(request, new WebSocketListener(){

                @Override
                public void onOpen(WebSocket webSocket, Response response) {
                    Intrinsics.checkNotNullParameter(webSocket, "webSocket");
                    Intrinsics.checkNotNullParameter(response, "response");
                    Zen.LOGGER.info("WebSocket opened");
                }

                @Override
                public void onMessage(WebSocket webSocket, String text) {
                    Intrinsics.checkNotNullParameter(webSocket, "webSocket");
                    Intrinsics.checkNotNullParameter(text, "text");
                    Zen.LOGGER.info("Received message: " + text);
                }

                @Override
                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    Intrinsics.checkNotNullParameter(webSocket, "webSocket");
                    Intrinsics.checkNotNullParameter(t, "t");
                    Zen.LOGGER.info("WebSocket error: " + t.getMessage());
                }

                @Override
                public void onClosing(WebSocket webSocket, int code, String reason) {
                    Intrinsics.checkNotNullParameter(webSocket, "webSocket");
                    Intrinsics.checkNotNullParameter(reason, "reason");
                    Zen.LOGGER.info("WebSocket closing: " + code + ' ' + reason);
                    webSocket.close(code, reason);
                }

                @Override
                public void onClosed(WebSocket webSocket, int code, String reason) {
                    Intrinsics.checkNotNullParameter(webSocket, "webSocket");
                    Intrinsics.checkNotNullParameter(reason, "reason");
                    Zen.LOGGER.info("WebSocket closed: " + code + ' ' + reason);
                }
            });
        }
        catch (Exception e) {
            Zen.LOGGER.error("Error initializing ZenAPI", (Throwable)e);
        }
    }
}

